/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.utlis;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialFuzzyMatchVO;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.share.vo.MaterialPlusVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchivesUtil {
    @Autowired
    private IMaterialApi materialApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JSONObject findMatch(List matchList, String categoryIdFieldName, String materialIdFieldName, String categoryFieldName, String materialFieldName, String materialFieldCode, String unitFieldName, String specFieldName, String errorMessageFieldName) {
        MaterialFuzzyMatchVO materialFuzzyMatchVO = new MaterialFuzzyMatchVO();
        MaterialFuzzyMatchVO materialNumberFuzzyMatchVO = new MaterialFuzzyMatchVO();
        HashMap<String, MaterialPlusVO> fuzzyMatchMap = new HashMap<String, MaterialPlusVO>();
        ArrayList<Map> errorList = new ArrayList<Map>();
        ArrayList<Map> sourceList = new ArrayList<Map>();
        HashMap<String, Boolean> materialHashMap = new HashMap<String, Boolean>();
        if (CollectionUtils.isNotEmpty((Collection)matchList)) {
            CommonResponse materialFuzzyMatchVOCommonResponse;
            List list = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)matchList), List.class);
            for (Object map : list) {
                String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                if (!StringUtils.isNotBlank((String)categoryName)) continue;
                materialHashMap.put(categoryName, false);
            }
            materialFuzzyMatchVO.setMaterialCategoryMap(materialHashMap);
            CommonResponse commonResponse = this.materialApi.checkArchive(materialFuzzyMatchVO);
            if (commonResponse.isSuccess() && commonResponse.getData() != null) {
                materialFuzzyMatchVO = (MaterialFuzzyMatchVO)commonResponse.getData();
            }
            for (Map map : list) {
                String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                Map materialCategoryMap = materialFuzzyMatchVO.getMaterialCategoryMap();
                if (StringUtils.isNotBlank((String)categoryName)) {
                    if (!((Boolean)materialCategoryMap.get(categoryName)).booleanValue()) {
                        map.put(errorMessageFieldName, "\u5206\u7c7b\u5fc5\u987b\u5b58\u5728");
                        errorList.add(map);
                    } else {
                        MaterialPlusVO materialPlusVO = new MaterialPlusVO();
                        materialPlusVO.setType(Integer.valueOf(1));
                        materialPlusVO.setCategoryName(categoryName);
                        String spec = Objects.isNull(map.get(specFieldName)) ? null : map.get(specFieldName).toString();
                        materialPlusVO.setSpec(spec);
                        String name = Objects.isNull(map.get(materialFieldName)) ? null : map.get(materialFieldName).toString();
                        materialPlusVO.setName(name);
                        materialPlusVO.setCategoryName(categoryName);
                        String unit = Objects.isNull(map.get(unitFieldName)) ? null : map.get(unitFieldName).toString();
                        materialPlusVO.setUnitName(unit);
                        String materialCode = Objects.isNull(map.get(materialFieldCode)) ? null : map.get(materialFieldCode).toString();
                        materialPlusVO.setCode(materialCode);
                        fuzzyMatchMap.put(map.get("onlyKey").toString(), materialPlusVO);
                        sourceList.add(map);
                    }
                }
                materialNumberFuzzyMatchVO.setFuzzyMatchMap(fuzzyMatchMap);
            }
            if (CollectionUtils.isNotEmpty(sourceList) && (materialFuzzyMatchVOCommonResponse = this.materialApi.fuzzyMatchNumber(materialNumberFuzzyMatchVO)).isSuccess() && materialFuzzyMatchVOCommonResponse.getData() != null) {
                MaterialFuzzyMatchVO data = (MaterialFuzzyMatchVO)materialFuzzyMatchVOCommonResponse.getData();
                Map matchMap = data.getFuzzyMatchMap();
                for (Map map : sourceList) {
                    MaterialPlusVO materialPlusVO;
                    String onlyKey = (String)map.get("onlyKey");
                    if (matchMap == null || (materialPlusVO = (MaterialPlusVO)matchMap.get(onlyKey)) == null) continue;
                    Integer matchStatus = materialPlusVO.getMatchStatus();
                    if (matchStatus != null && matchStatus == 1) {
                        map.put(categoryIdFieldName, materialPlusVO.getCategoryId());
                        map.put(materialIdFieldName, materialPlusVO.getId());
                        map.put(unitFieldName, materialPlusVO.getUnitName());
                        map.put(specFieldName, materialPlusVO.getSpec());
                        map.put(categoryFieldName, materialPlusVO.getCategoryName());
                        map.put(materialFieldName, materialPlusVO.getName());
                        map.put(materialFieldCode, materialPlusVO.getCode());
                    }
                    Integer matchNumber = materialPlusVO.getMatchNumber();
                    String matchStatusDescription = materialPlusVO.getMatchStatusDescription();
                    map.put("matchStatus", matchStatus);
                    map.put("matchNumber", matchNumber);
                    map.put("matchStatusDescription", matchStatusDescription);
                }
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceList", sourceList);
        jsonObject.put("errorList", errorList);
        return jsonObject;
    }

    public JSONObject batchSaveArchive(MaterialInsertArchiveVO archiveVO, List matchList, String categoryIdFieldName, String materialIdFieldName, String categoryFieldName, String materialFieldName, String materialFieldCode, String unitFieldName, String specFieldName, String errorMessageFieldName) {
        HashMap<String, MaterialVO> materialVOMap = new HashMap<String, MaterialVO>();
        Map archiveMap = new HashMap();
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)matchList)) {
            list = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)matchList), List.class);
            for (Map map : list) {
                if (map.get("rowState") == null || map.get("rowState") == "del" || map.get("matchStatus") == null || map.get("matchStatus").toString().equals("1")) continue;
                MaterialVO materialVO = new MaterialVO();
                String categoryName = Objects.isNull(map.get(categoryFieldName)) ? null : map.get(categoryFieldName).toString();
                materialVO.setCategoryName(categoryName);
                String materialName = Objects.isNull(map.get(materialFieldName)) ? null : map.get(materialFieldName).toString();
                materialVO.setName(materialName);
                String spec = Objects.isNull(map.get(specFieldName)) ? null : map.get(specFieldName).toString();
                materialVO.setSpec(spec);
                String unit = Objects.isNull(map.get(unitFieldName)) ? null : map.get(unitFieldName).toString();
                materialVO.setUnitName(unit);
                String code = Objects.isNull(map.get(materialFieldCode)) ? null : map.get(materialFieldCode).toString();
                materialVO.setCode(code);
                materialVO.setType(Integer.valueOf(1));
                String onlyKey = map.get("onlyKey").toString();
                materialVOMap.put(onlyKey, materialVO);
            }
            if (!materialVOMap.isEmpty()) {
                archiveVO.setMaterialVOMap(materialVOMap);
                CommonResponse listCommonResponse = this.materialApi.batchInsertArchiveBySourceBill(archiveVO);
                this.logger.info("\u63d2\u5165" + JSONObject.toJSONString(materialVOMap));
                if (listCommonResponse.isSuccess()) {
                    Map data = (Map)listCommonResponse.getData();
                    if (data != null) {
                        archiveMap = data;
                    }
                } else {
                    throw new BusinessException(listCommonResponse.getMsg());
                }
            }
            for (Map map : list) {
                String onlyKey = map.get("onlyKey").toString();
                if (archiveMap == null || archiveMap.get(onlyKey) == null) continue;
                MaterialVO materialVO = (MaterialVO)archiveMap.get(onlyKey);
                map.put(categoryIdFieldName, materialVO.getCategoryId());
                map.put(materialIdFieldName, materialVO.getId());
                map.put(unitFieldName, materialVO.getUnitName());
                map.put(specFieldName, materialVO.getSpec());
                map.put(categoryFieldName, materialVO.getCategoryName());
                map.put(materialFieldName, materialVO.getName());
                map.put(materialFieldCode, materialVO.getCode());
                map.put("matchStatus", 1);
                map.put("matchStatusDescription", "\u5df2\u5339\u914d");
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceList", list);
        return jsonObject;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<UseApplySubVO> objects = new ArrayList<UseApplySubVO>();
        UseApplySubVO useApplySubVO = new UseApplySubVO();
        useApplySubVO.setMaterialName("555555");
        objects.add(useApplySubVO);
        JSONObject match1 = ArchivesUtil.findMatch1(objects, "materialTypeId", "materialId", "materialTypeName", "materialName", "unit", "spec");
        List sourceList = (List)match1.get((Object)"sourceList");
    }

    public static JSONObject findMatch1(List matchList, String categoryIdFieldName, String materialIdFieldName, String categoryFieldName, String materialFieldName, String unitFieldName, String specFieldName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        List list = (List)JSONObject.parseObject((String)JSONObject.toJSONString((Object)matchList), List.class);
        for (Map map : list) {
            Object o = map.get(materialFieldName);
            System.out.println(o);
            map.put(materialFieldName, 666666);
        }
        jsonObject.put("sourceList", (Object)matchList);
        return jsonObject;
    }
}

