/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeHisEntity;
import com.ejianc.business.plan.bean.PlanChangeSubEntity;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.service.IPlanChangeHisService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.service.IPlanChangeSubService;
import com.ejianc.business.plan.service.impl.PlanChangeThread;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planChange")
public class PlanChangeBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IPlanChangeSubService planChangeSubService;
    @Autowired
    private IPlanChangeHisService planChangeHisService;
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PlanChangeMapper planChangeMapper;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        PlanChangeEntity entity = (PlanChangeEntity)((Object)this.planChangeMapper.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.planChangeService.saveOrUpdate((Object)entity, false);
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5ba1\u6279\u5b8c\u6210\u56de\u8c03\u5904\u7406----------------\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        PlanChangeThread myThread = new PlanChangeThread();
        UserContext userContext = this.sessionManager.getUserContext();
        myThread.setBillId(billId);
        myThread.setState(state);
        myThread.setLogger(this.logger);
        myThread.setPlanChangeService(this.planChangeService);
        myThread.setPlanChangeSubService(this.planChangeSubService);
        myThread.setPlanChangeHisService(this.planChangeHisService);
        myThread.setMaterialMasterPlanService(this.materialMasterPlanService);
        myThread.setMaterialMasterPlanSubService(this.materialMasterPlanSubService);
        myThread.setUserCode(userContext.getUserCode());
        myThread.setUserName(userContext.getUserName());
        Thread thread = new Thread(myThread);
        thread.start();
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        PlanChangeEntity planChange = (PlanChangeEntity)((Object)this.planChangeMapper.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_plan_id", (Object)billId);
        PlanChangeHisEntity hisEntity = (PlanChangeHisEntity)((Object)this.planChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            MaterialMasterPlanEntity newPlanEntity = null;
            MaterialMasterPlanEntity oldPlan = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(planChange.getSourcePlanId()));
            this.logger.info("\u603b\u8ba1\u5212\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldPlan, (Object)hisEntity);
            newPlanEntity = (MaterialMasterPlanEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), MaterialMasterPlanEntity.class));
            newPlanEntity.setCurChangingPlanId(hisEntity.getChangePlanId());
            newPlanEntity.setCreateUserName(oldPlan.getCreateUserName());
            newPlanEntity.setCreateUserCode(oldPlan.getCreateUserCode());
            newPlanEntity.setCreateTime(oldPlan.getCreateTime());
            newPlanEntity.setId(oldPlan.getId());
            newPlanEntity.setVersion(oldPlan.getVersion());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion());
            newPlanEntity.setChangeState(MaterialMasterPlanVO.PLAN_CHANGE_STATE_CHANGING);
            newPlanEntity.setTotalPlanAmt(hisEntity.getOriginalPlanAmt());
            newPlanEntity.setChangeVersion(planChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(planChange.getMaterialSubList())) {
                ArrayList<MaterialMasterPlanSubEntity> list = new ArrayList<MaterialMasterPlanSubEntity>();
                MaterialMasterPlanSubEntity tmp = null;
                Map<Long, Integer> map = oldPlan.getMaterialSubList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (PlanChangeSubEntity detail : planChange.getMaterialSubList()) {
                    tmp = (MaterialMasterPlanSubEntity)((Object)BeanMapper.map((Object)((Object)detail), MaterialMasterPlanSubEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newPlanEntity.setMaterialSubList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.materialMasterPlanSubService.delByPlanIdAndDetailIds(delDetailIds, oldPlan.getId());
            }
            this.planChangeHisService.removeById(hisEntity.getId(), false);
            this.materialMasterPlanService.saveOrUpdate((Object)newPlanEntity, false);
        }
        if (this.planChangeService.saveOrUpdate((Object)planChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u603b\u8ba1\u5212\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        PlanChangeEntity planChange = (PlanChangeEntity)((Object)this.planChangeMapper.selectById(billId));
        planChange.setCommitUserName(null);
        planChange.setCommitUserCode(null);
        planChange.setCommitDate(null);
        this.planChangeService.saveOrUpdate((Object)planChange, false);
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u64a4\u56de\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

