/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.mapper.PlanChangeHisMapper;
import com.ejianc.business.plan.mapper.PlanChangeMapper;
import com.ejianc.business.plan.mapper.PlanChangeSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="planChangeService")
public class PlanChangeServiceImpl
extends BaseServiceImpl<PlanChangeMapper, PlanChangeEntity>
implements IPlanChangeService {
    @Autowired
    private PlanChangeSubMapper planChangeSubMapper;
    @Autowired
    private PlanChangeMapper planChangeMapper;
    @Autowired
    private PlanChangeHisMapper planChangeHisMapper;
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private UseApplyMapper useApplyMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList()) && null != saveEntity.getId()) {
            this.planChangeSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        MaterialMasterPlanEntity planEntity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.selectById(saveEntity.getSourcePlanId()));
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            this.materialMasterPlanService.saveOrUpdate((Object)planEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.planChangeMapper.selectBatchIds(changeIds);
        List planIds = changeList.stream().map(PlanChangeEntity::getSourcePlanId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", planIds);
        List planList = this.materialMasterPlanService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_plan_id as planId"});
        query.in((Object)"source_plan_id", planIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_plan_id"});
        List queryResult = this.planChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = planList.iterator();
        while (iterator.hasNext()) {
            MaterialMasterPlanEntity plan;
            plan.setChangeState(null != hisCountNumMap.get((plan = (MaterialMasterPlanEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(plan.getId()) > 0 ? 2 : 0);
            plan.setCurChangingPlanId(null);
        }
        this.materialMasterPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public PlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_plan_id", (Object)sourcePlanId);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (PlanChangeEntity)((Object)this.planChangeMapper.selectOne((Wrapper)query));
    }

    @Override
    public void querySumApplyNum(PlanChangeVO vo) {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("sourceIds", vo.getMaterialSubList().stream().filter(t2 -> t2.getTargetId() != null).map(PlanChangeSubVO::getTargetId).collect(Collectors.toList()));
        List<UseApplySubVO> applylist = this.useApplyMapper.countSumApplyBySource(queryParam);
        Map<Long, BigDecimal> map = applylist.stream().collect(Collectors.groupingBy(UseApplySubVO::getSourceId, Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
        List materialSubList = vo.getMaterialSubList();
        for (PlanChangeSubVO materialMasterPlanSubVO : materialSubList) {
            materialMasterPlanSubVO.setSumApplyNum(map.get(materialMasterPlanSubVO.getId()));
            materialMasterPlanSubVO.setSurplusApplyNum(ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Double)materialMasterPlanSubVO.getNum()), (BigDecimal)materialMasterPlanSubVO.getSumApplyNum()));
        }
    }
}

