package com.ejianc.business.delivery.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 消耗材送货单
 * 
 * @author generator
 * 
 */
@Mapper
public interface MaterialDeliveryMapper extends BaseCrudMapper<MaterialDeliveryEntity> {

    /**
     * @description: 订单物资明细参照,剩余数量= 订单数量 - 占有量(收料入库,直入直出)
     *
     * @param pageData
     * @param wrapper
     * @return {@link List <  MaterialDeliveryDetailVO >}
     * @author songlx
     * @date: 2023/4/20
     */
    List<MaterialDeliveryDetailVO> querySubData(IPage<MaterialDeliveryDetailEntity> pageData, @Param(Constants.WRAPPER) QueryWrapper wrapper);

}
