package com.ejianc.business.material.controller;

import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @description: HomeStatisticController
 * @author songlx
 * @date 2024/11/11
 * @version 1.0
 */
@Controller
@RequestMapping("homeStatistic")
public class HomeStatisticController implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IMaterialContractService materialContractService;

    /**
     * @Description 项目采买情况
     */
    @RequestMapping(value = "/purchaseInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> purchaseInfo() {
        return CommonResponse.success("查询项目采买情况！", materialContractService.purchaseInfo());
    }


    /**
     * @Description 供应商采买排名前10
     */
    @RequestMapping(value = "/supplierTop", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> supplierTop() {
        return CommonResponse.success("供应商采买排名前10！", materialContractService.supplierTop());
    }


    /**
     * @Description 财务数据
     */
    @RequestMapping(value = "/financeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> financeData() {
        return CommonResponse.success("财务数据！", materialContractService.financeData());
    }


    /**
     * @Description 人效管理
     */
    @RequestMapping(value = "/efficiencyManagement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> efficiencyManagement() {
        return CommonResponse.success("人效管理！", materialContractService.efficiencyManagement());
    }


    /**
     * @Description 仓库管理
     */
    @RequestMapping(value = "/storeMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> storeMny() {
        return CommonResponse.success("仓库管理！", materialContractService.storeMny());
    }

    /**
     * @Description 采购履约状态
     */
    @RequestMapping(value = "/performanceStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> performanceStatus(@RequestParam String startDate, @RequestParam String endDate) {
        return CommonResponse.success("采购履约状态！", materialContractService.performanceStatus(startDate, endDate));
    }



}
