package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @description: 合同文件管理控制
 * @author songlx
 * @date: 2024/6/4
 */
@RestController
@RequestMapping("materialContractFileUpdate")
public class MaterialContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialContractService materialContractService;


    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "/updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        Long billId = updateData.getLong("billId");
        LambdaUpdateWrapper<MaterialContractEntity> updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(MaterialContractEntity::getId, billId);
        updateWrapper.set(MaterialContractEntity::getContractFileId, updateData.getLong("fileId"));
        materialContractService.update(updateWrapper);

        JSONObject resp = new JSONObject();
        resp.put("message", "合同文件信息更新成功");
        return CommonResponse.success("合同文件信息更新成功！", resp);
    }


    @GetMapping(value = "/getBillDataJson")
    public CommonResponse<MaterialContractVO> getBillDataJson(@RequestParam Long id) {
        MaterialContractEntity contractEntity = materialContractService.selectById(id);
        MaterialContractVO vo = BeanMapper.map(contractEntity, MaterialContractVO.class);
/*
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if(CollectionUtils.isNotEmpty(vo.getDetailList())) {
            //合同明细清单处理
            vo.setDetailList(vo.getDetailList().stream().filter(item -> null != item.getDetailNum()).collect(Collectors.toList()));
            vo.getDetailList().forEach(item -> {
                item.setDetailPriceStr(priceFmt.format(null != item.getDetailPrice() ? item.getDetailPrice() : BigDecimal.ZERO));
                item.setDetailTaxPriceStr(priceFmt.format(null != item.getDetailTaxPrice() ? item.getDetailTaxPrice() : BigDecimal.ZERO));
                item.setDetailMnyStr(mnyFmt.format(null != item.getDetailMny() ? item.getDetailMny() : BigDecimal.ZERO));
                item.setDetailTaxMnyStr(mnyFmt.format(null != item.getDetailTaxMny() ? item.getDetailTaxMny() : BigDecimal.ZERO));
                item.setDetailTaxStr(mnyFmt.format(null != item.getDetailTax() ? item.getDetailTax() : BigDecimal.ZERO));
                item.setDetailTaxRateStr(mnyFmt.format(null != item.getDetailTaxRate() ? item.getDetailTaxRate() : BigDecimal.ZERO));

                item.setDetailArtificialPriceStr(priceFmt.format(null != item.getDetailArtificialPrice() ? item.getDetailArtificialPrice() : BigDecimal.ZERO));
                item.setDetailArtificialTaxPriceStr(priceFmt.format(null != item.getDetailArtificialTaxPrice() ? item.getDetailArtificialTaxPrice() : BigDecimal.ZERO));
                item.setDetailArtificialMnyStr(mnyFmt.format(null != item.getDetailArtificialMny() ? item.getDetailArtificialMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxMnyStr(mnyFmt.format(null != item.getDetailArtificialTaxMny() ? item.getDetailArtificialTaxMny() : BigDecimal.ZERO));
                item.setDetailArtificialTaxStr(mnyFmt.format(null != item.getDetailArtificialTax() ? item.getDetailArtificialTax() : BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getOtherCostList())) {
            //合同其他费用列表数据
            vo.getOtherCostList().stream().forEach(item -> {
                item.setCostPriceStr(priceFmt.format(null != item.getCostPrice() ? item.getCostPrice() : BigDecimal.ZERO));
                item.setCostTaxPriceStr(priceFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxRateStr(mnyFmt.format(null != item.getCostTaxPrice() ? item.getCostTaxPrice() : BigDecimal.ZERO));
                item.setCostTaxStr(mnyFmt.format(null != item.getCostTax() ? item.getCostTax() : BigDecimal.ZERO));
                item.setCostMnyStr(mnyFmt.format(null != item.getCostMny() ? item.getCostMny() : BigDecimal.ZERO));
                item.setCostTaxMnyStr(mnyFmt.format(null != item.getCostTaxMny() ? item.getCostTaxMny() : BigDecimal.ZERO));
            });
        }
        if(CollectionUtils.isNotEmpty(vo.getPaymentList())) {
            //合同付款阶段
            vo.getPaymentList().stream().forEach(item -> {
                item.setPaymentScaleStr(mnyFmt.format(null != item.getPaymentScale() ? item.getPaymentScale() : BigDecimal.ZERO));
            });
        }*/
        return CommonResponse.success(vo);
    }

    /**
     * @Description  归档
     */
    @RequestMapping(value = "/onFile", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> onFile(@RequestBody OtherContractVO contractVO){
        return materialContractService.onFile(contractVO);
    }

}
