package com.ejianc.business.material.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.api.ImaterialPicketageApi;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.ListSplitUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 物资合同数据处理服务
 *
 * @author CJ
 */
@Service("materialService")
public class MaterialContractServiceImpl extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity> implements IMaterialContractService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private final String DEFAULT_RULE_CODE = "materialContract";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MaterialContractMapper materialContractMapper;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;

    @Autowired
    private ImaterialPicketageApi materialPicketageApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TOTAL_MNY = "P-t58ih142"; // 【预算材料费总金额】 控 【物资合同总金额】
    private static final String PARAM_NUM = "P-uFOcn644"; // 预算材料清单量控
    private static final String PARAM_TAX_MNY = "P-14dTg745"; // 预算材料清单金额控
    @Autowired
    private IUseApplyService useApplyService;

    //总计划量
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";

    //总计划价
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";


    //总计划价
    private static String PARAM_PRICE_AREA = "P-126hYD10";
    @Autowired
    private IRmatContractApi rmatContractApi;


    @Override
    public List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        List<MaterialContractVO> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(materialContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        MaterialContractEntity saveEntity = null;
        UserContext userContext = sessionManager.getUserContext();

        //设置合同初始化金额、变更前金额
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, BigDecimal.ROUND_HALF_UP);
        MaterialContractEntity dbEntity = null;
        if (null != materialContractVO.getId()) {
            dbEntity = super.selectById(materialContractVO.getId());
        }

        if (dbEntity != null) {
            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());

        } else {
            //创建人信息
            materialContractVO.setCreateUserName(userContext.getUserName());
            //设置初始变更版本号：1
            materialContractVO.setChangeVersion(1);
            //设置审批状态为自由态
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //设置合同变更状态：未变更
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);

            saveEntity = BeanMapper.map(materialContractVO, MaterialContractEntity.class);
        }
        //重新计算合同金额，税金
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList()
                    .stream().filter(detail -> !"del".equals(detail.getRowState()) && (null != detail.getTotalAmount()))
                    .map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream()
                    .filter(cost -> !"del".equals(cost.getRowState()) && (null != cost.getCostAmount()))
                    .map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount())
                    .forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
        }
        //都为空,则是没子表,手动录入的,不需要在合计
       /* if(CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList()) || CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())){
            saveEntity.setAmountWithTax(totalAmountWith);
            saveEntity.setAmountWithoutTax(totalAmountWith.divide(new BigDecimal(1 + saveEntity.getTaxRate() / 100), 8, BigDecimal.ROUND_HALF_UP));
            saveEntity.setTaxFee(saveEntity.getAmountWithTax().subtract(saveEntity.getAmountWithoutTax()).setScale(8, BigDecimal.ROUND_HALF_UP));

        }*/
        boolean b = super.saveOrUpdate(saveEntity, false);
        if(b){
            this.countContractNumAndMnyByEnquiry(saveEntity.getEnquiryPriceBillId());
        }
        return BeanMapper.map(saveEntity, MaterialContractVO.class);
    }



    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper<MaterialContractEntity> wrapper = super.changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }

        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if(id != null){
            check.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        check.getParams().put("code", new Parameter(QueryParam.EQ, code));
        check.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<MaterialContractEntity> contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter(QueryParam.NE, id));
        check.getParams().put("bill_state", new Parameter(QueryParam.NE, BillStateEnum.PASSED_STATE.getBillStateCode()));

        List<ContractChangeEntity> changeList = contractChangeService.queryList(check, false);
        if (CollectionUtils.isNotEmpty(changeList)) {
            return false;
        }
        return true;
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/7/22  校验合同合法性
     * @Description checkContract
     * @Param [id]
     * @Return void
     */
    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = super.selectById(id);
        if (contractEntity == null) {
            throw new BusinessException("所选合同不存在！");
        }
        if (!(contractEntity.getBillState() == 1 || contractEntity.getBillState() == 3)) {
            throw new BusinessException("所选合同未生效！");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> result = new ArrayList<>();
        List<List<SqlParam>> lists = ListSplitUtil.splistList(sqlParamList, 10);
        for (List<SqlParam> list : lists) {
            result.addAll(materialContractMapper.queryAllWarnContracts(list));
        }
        return result;
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return baseMapper.materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<MaterialContractEntity> lambda = Wrappers.<MaterialContractEntity>lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, projectId);
        lambda.eq(MaterialContractEntity::getDr, 0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List<MaterialContractEntity> quoteEntities = super.list(lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax()==null?BigDecimal.ZERO:ce.getAmountWithTax());
        }
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, projectId);
        lambda2.eq(PurchaseSettlementEntity::getDr, 0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.list(lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax()==null?BigDecimal.ZERO:ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List<MaterialPriceVO> detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty(detail)) {
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc) {
                List<MaterialPriceVO> materialPriceVOS = materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null != p) {
                            v.setPlanNum(p.getPlanNum());
                            v.setPlanPrice(p.getPlanPrice());
                        }
                    }
                }
            }
            //结算历史低价和高价只和租户有关
            List<MaterialPriceVO> materialPrices = materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds);
            if (CollectionUtils.isNotEmpty(materialPrices)) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    Long materialId = v.getMaterialId();
                    MaterialPriceVO p = priceVO.get(materialId);
                    if (null != p) {
                        v.setMinPrice(p.getMinPrice());
                        v.setMaxPrice(p.getMaxPrice());
                        v.setPriceArea(p.getMinPrice().setScale(2, BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2, BigDecimal.ROUND_HALF_UP));
                        v.setBuyPrice(p.getBuyPrice());
                    }
                }
            }
        }
        return vo;
    }

    // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
    // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
    // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
    //控制方式 0：不控制，1、提醒，2、无法保存
    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<MaterialPriceVO> detailList = vo.getDetail();
        Map<Long, MaterialPriceVO> numMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            detailList.forEach(detail -> {
                MaterialPriceVO numVO = numMap.get(detail.getMaterialId());
                if (numVO != null) {
                    numVO.setNum(ComputeUtil.safeAdd(numVO.getNum(), detail.getNum()));
                    numVO.setPrice(ComputeUtil.isLessThan(detail.getPrice(), numVO.getPrice()) ? detail.getPrice() : numVO.getPrice());
                    numVO.setTotalAmount(ComputeUtil.safeAdd(numVO.getTotalAmount(), detail.getTotalAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList<>(numMap.values()));
            List<MaterialPriceVO> detail = vo.getDetail();
            if (isJc == 0) {
                List<Long> subIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                // 预算材料费总金额
                /*BudgetProjectProParamControlVO paramControlVO = new BudgetProjectProParamControlVO();
                paramControlVO.setProjectId(vo.getProjectId());
                paramControlVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO.setIds(subIds);
                CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(paramControlVO);
                if (!res.isSuccess()) {
                    throw new BusinessException("预算材料费总金额，查询项目预算信息失败，失败原因：" + res.getMsg());
                }
                // 没有预算不控制，预算不包含不控制
                if (null != res.getData()) {
                    // 预算总金额
                    BudgetProjectProQuantityAndMnyVO quantityAndMnyVO = res.getData();
                    Map<Long, BudgetProjectDetailProVO> detailProMap = quantityAndMnyVO.getDetailProMap();

                    // 【预算材料费总金额】 控 【物资合同总金额】
                    CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
                    if (!response.isSuccess()) {
                        throw new BusinessException("【预算材料费总金额】 控 【物资总计划金额】，获取控制参数失败，失败原因：" + response.getMsg());
                    }
                    List<BillParamVO> billParamVOS = response.getData();

                    if (CollectionUtils.isNotEmpty(billParamVOS)) {
                        for (BillParamVO billParamVO : billParamVOS) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                                BigDecimal budgetTaxMnyResult = quantityAndMnyVO.getMaterialTaxMny().multiply(scale);

                                // 历史累计物资采购合同总金额(含变更中，有变更中取变更中的)
                                BigDecimal lastTotalAmountWithTax = materialContractMapper.sumLastTotalAmountWithTax(vo.getProjectId(), vo.getContractId());

                                // 本期物资采购合同总金额
                                BigDecimal currentAmountWithTax = vo.getAmountWithTax();
                                // 物资采购合同总金额 = 历史累计物资采购合同总金额 + 本期物资采购合同总金额
                                BigDecimal am = lastTotalAmountWithTax.add(currentAmountWithTax);

                                // 周转材合同按照项目维度，获取总金额
                                CommonResponse<BigDecimal> response1 = rmatContractApi.fetchContractTaxMny(vo.getProjectId());
                                if (!response1.isSuccess()) {
                                    throw new BusinessException("周转材合同按照项目维度，合同总金额获取失败，失败原因：" + response.getMsg());
                                }

                                BigDecimal amountWithTax = response1.getData().add(am);

                                // 物资采购合同总金额 和 预算材料费总金额比较
                                if (amountWithTax.compareTo(budgetTaxMnyResult) > 0) {
                                    // 超出金额 = 物资采购合同总金额 - 预算材料费总金额 * X%
                                    BigDecimal over = amountWithTax.subtract(budgetTaxMnyResult);

                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(vo.getContractId(), "amountWithoutTax");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem("物资采购合同总金额超预算材料费总金额");
                                    paramsCheckDsVO.setWarnName("物资采购合同总金额大于预算材料费总金额 * " + roleValue + "%");

                                    // 物资采购合同总金额：XX元，预算材料费总金额 * X%：XX元，超出金额：XX元。
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该项目物资采购合同总金额：")
                                            .append(amountWithTax.setScale(2, RoundingMode.HALF_UP))
                                            .append("元，预算材料费总金额 * ")
                                            .append(roleValue).append("%：")
                                            .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                            .append("元，超出金额：")
                                            .append(over.setScale(2, RoundingMode.HALF_UP))
                                            .append("元。");
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }

                    // 预算材料清单量控
                    CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_NUM, curOrgId);
                    if (!response1.isSuccess()) {
                        throw new BusinessException("预算材料清单量控，获取控制参数失败，失败原因：" + response1.getMsg());
                    }
                    List<BillParamVO> billParamVOS1 = response1.getData();

                    if (CollectionUtils.isNotEmpty(detail) && CollectionUtils.isNotEmpty(billParamVOS1) && !detailProMap.isEmpty()) {
                        // 历史累计物资采购合同材料清单量、金额
                        Map<Long, MaterialPriceVO> lastSubMap = materialContractMapper.sumLastTotalNumAndTotalAmount(vo.getContractId(), vo.getProjectId(), numMap.keySet());

                        // 合并物资总计划材料数据
                        Map<Long, MaterialPriceVO> currentMergeMap = new HashMap<>();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry<Long, MaterialPriceVO> entry : lastSubMap.entrySet()) {
                                Long materialId = entry.getKey();
                                if (numMap.containsKey(materialId)) {
                                    MaterialPriceVO subVO = entry.getValue();
                                    MaterialPriceVO cur = numMap.get(materialId);
                                    BigDecimal num = subVO.getNum();
                                    subVO.setNum(num.add(cur.getNum()));
                                    entry.setValue(subVO);
                                }
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }

                        for (BillParamVO billParamVO : billParamVOS1) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal num = detailProVO.getNum() == null ? BigDecimal.ZERO : detailProVO.getNum();
                                    budgetProjectDetailProVO.setNum(num.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, MaterialPriceVO> entry : currentMergeMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    MaterialPriceVO materialPriceVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 物资采购合同材料清单量 和 预算材料清单量
                                        BigDecimal cNum = materialPriceVO.getNum();
                                        BigDecimal dNum = detailProVO.getNum();
                                        if (cNum.compareTo(dNum) > 0) {
                                            // 超出量 = 物资采购合同材料清单量 - 预算材料清单量 * X%
                                            BigDecimal over = cNum.subtract(dNum);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "num");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                            paramsCheckDsVO.setWarnName("物资采购合同材料清单量大于预算材料清单量 * " + roleValue + "%");

                                            // 档案累计数量：XX，预算材料清单量 * X%：XX，超出量：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append("档案累计数量：")
                                                    .append(cNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单量 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dNum.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出量：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }


                    // 预算材料清单金额控
                    CommonResponse<List<BillParamVO>> response2 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TAX_MNY, curOrgId);
                    if (!response2.isSuccess()) {
                        throw new BusinessException("预算材料清单金额控，获取控制参数失败，失败原因：" + response2.getMsg());
                    }
                    List<BillParamVO> billParamVOS2 = response2.getData();

                    if (CollectionUtils.isNotEmpty(detail) && CollectionUtils.isNotEmpty(billParamVOS2) && !detailProMap.isEmpty()) {
                        // 历史累计物资采购合同材料清单量、金额
                        Map<Long, MaterialPriceVO> lastSubMap = materialContractMapper.sumLastTotalNumAndTotalAmount(vo.getContractId(), vo.getProjectId(), numMap.keySet());

                        // 合并物资总计划材料数据
                        Map<Long, MaterialPriceVO> currentMergeMap = new HashMap<>();
                        if (lastSubMap.isEmpty()) {
                            currentMergeMap.putAll(numMap);
                        } else {
                            for (Map.Entry<Long, MaterialPriceVO> entry : lastSubMap.entrySet()) {
                                Long materialId = entry.getKey();
                                if (numMap.containsKey(materialId)) {
                                    MaterialPriceVO subVO = entry.getValue();
                                    MaterialPriceVO cur = numMap.get(materialId);
                                    BigDecimal amount = subVO.getTotalAmount();
                                    subVO.setTotalAmount(amount.add(cur.getTotalAmount()));
                                    entry.setValue(subVO);
                                }
                            }
                            currentMergeMap.putAll(lastSubMap);
                        }

                        for (BillParamVO billParamVO : billParamVOS2) {
                            if (0 != billParamVO.getControlType()) {
                                BigDecimal roleValue = billParamVO.getRoleValue();
                                BigDecimal scale = roleValue.divide(new BigDecimal("100"));

                                // 根据现在的参数重新计算预算清单的清单量和金额
                                Map<Long, BudgetProjectDetailProVO> dProMap = new HashMap<>();
                                for (Map.Entry<Long, BudgetProjectDetailProVO> entry : detailProMap.entrySet()) {
                                    BudgetProjectDetailProVO detailProVO = entry.getValue();
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = new BudgetProjectDetailProVO();
                                    BigDecimal materialTaxMnyCost = detailProVO.getMaterialTaxMnyCost() == null ? BigDecimal.ZERO : detailProVO.getMaterialTaxMnyCost();
                                    budgetProjectDetailProVO.setMaterialTaxMnyCost(materialTaxMnyCost.multiply(scale));
                                    dProMap.put(entry.getKey(), budgetProjectDetailProVO);
                                }

                                for (Map.Entry<Long, MaterialPriceVO> entry : currentMergeMap.entrySet()) {
                                    Long materialId = entry.getKey();
                                    MaterialPriceVO materialPriceVO = entry.getValue();
                                    // 预算包含档案才控制，不包含的档案不控制
                                    if (dProMap.containsKey(materialId)) {
                                        BudgetProjectDetailProVO detailProVO = dProMap.get(materialId);

                                        // 物资采购合同材料金额 和 预算材料清单金额
                                        BigDecimal cTotalAmount = materialPriceVO.getTotalAmount();
                                        BigDecimal dMaterialTaxMnyCost = detailProVO.getMaterialTaxMnyCost();
                                        if (cTotalAmount.compareTo(dMaterialTaxMnyCost) > 0) {
                                            // 超出量 = 物资采购合同材料金额 - 预算材料清单金额 * X%
                                            BigDecimal over = cTotalAmount.subtract(dMaterialTaxMnyCost);

                                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(materialId, "totalAmount");
                                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                            // 预警项：档案名称+单位+规格型号
                                            paramsCheckDsVO.setWarnItem(materialPriceVO.getMaterialName() + "-" + materialPriceVO.getMeasureUnit() + "-" + materialPriceVO.getSpec());
                                            paramsCheckDsVO.setWarnName("物资采购合同材料金额大于预算材料清单金额 * " + roleValue + "%");

                                            // 档案累计金额：XX，预算材料清单金额 * X%：XX，超出金额：XX。
                                            StringBuffer stringBuffer = new StringBuffer();
                                            stringBuffer.append(" 档案累计金额：")
                                                    .append(cTotalAmount.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，预算材料清单金额 * ")
                                                    .append(roleValue).append("%：")
                                                    .append(dMaterialTaxMnyCost.setScale(2, RoundingMode.HALF_UP))
                                                    .append("，超出金额：")
                                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                                    .append("。");
                                            paramsCheckDsVO.setContent(stringBuffer.toString());
                                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
*/
                // 【物资总计划量】控制【物资合同量】P-8N9Au207 集采不受控制
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("【物资总计划量】控制【物资合同量】，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                            //获取已生效的量
                            List<MaterialPriceVO> vos = new ArrayList<>();
                            vos = materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);
                            Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal num = d.getNum();
                                BigDecimal planNum = d.getPlanNum().multiply(divide);
                                BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                                BigDecimal allNum = hasNum.add(num);
                                if (allNum.compareTo(planNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("合同数量大于总计划数量");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("本次合同数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，已签订数量：").append(hasNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，总计划数量*").append(roleValue).append("%: ").append(planNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(allNum.subtract(planNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }

                // 总计划价格【物资总计划价】控制【物资合同价】P-2Ux27w08  集采不受控制
                CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId);
                if (!response1.isSuccess()) {
                    throw new BusinessException("总计划价格【物资总计划价】控制【物资合同价】，获取控制参数失败，失败原因：" + response1.getMsg());
                }
                List<BillParamVO> billParamVOS1 = response1.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            for (MaterialPriceVO d : detail) {
                                BigDecimal price = d.getPrice();
                                BigDecimal planPrice = d.getPlanPrice();
                                BigDecimal _planPrice = planPrice.multiply(divide);
                                if (price.compareTo(_planPrice) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("合同单价大于总计划单价");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，总计划单价*").append(roleValue).append("%: ").append(_planPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出单价：").append(price.subtract(_planPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }
            }


            // 结算历史价格区间【历史价】控制【物资合同价】P-126hYD10
            CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PRICE_AREA, curOrgId);
            if (!response1.isSuccess()) {
                throw new BusinessException("结算历史价格区间【历史价】控制【物资合同价】，获取控制参数失败，失败原因：" + response1.getMsg());
            }
            List<BillParamVO> billParamVOS1 = response1.getData();

            if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                for (BillParamVO billParamVO : billParamVOS1) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                        for (MaterialPriceVO d : detail) {
                            BigDecimal price = d.getPrice();
                            BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                            BigDecimal minPrice = d.getMinPrice();
                            if (maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                                BigDecimal _maxPrice = maxPrice.multiply(divide);
                                BigDecimal _minPrice = minPrice.multiply(divide);
                                if (price.compareTo(_maxPrice) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("合同单价大于历史价");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("本次合同单价：").append(price.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，物资历史价*").append(roleValue).append("%: ").append(_minPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("~").append(_maxPrice.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出最高价：").append(price.subtract(_maxPrice).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            }
                        }
                    }
                }
            }

        }

        if (isJc.equals(0)) {
            // 施工合同金额控制支出
            CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
            if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
                List<BillParamVO> billParamVOS = sghtkzc.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    BigDecimal sjzcje = this.getSjzcje(vo.getContractId(), vo.getProjectId(), vo.getAmountWithTax());
                    CommonResponse<BigDecimal> res = incomeContractApi.fetchSghtzje(vo.getProjectId());
                    if (!res.isSuccess()) {
                        throw new BusinessException("获取施工合同工总金额失败");
                    }
                    BigDecimal sght = res.getData();
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                            BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                            if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该项目实际支出总金额：")
                                        .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                        .append("，施工合同工总金额*")
                                        .append(roleValue)
                                        .append("%：")
                                        .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                        .append("，超出金额：")
                                        .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                                paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }
                    }
                }
            }
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long contractId, Long projectId, BigDecimal mny) {
        BigDecimal wz = BigDecimal.ZERO;
        if(contractId != null){
            wz = baseMapper.fetchSjzcje(projectId, contractId);
        }
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link BigDecimal}
     */
    @Override
    public BigDecimal fetchAmountWithTax(Long projectId) {
        // 历史累计物资采购合同总金额(含变更中，有变更中取变更中的)
        return materialContractMapper.sumLastTotalAmountWithTax(projectId, null);
    }

    /**
     * @description: 根据定标单溶剂已签合同数量和金额
     *
     * @return {@link MaterialPicketageVO}
     * @author songlx
     * @date: 2023/2/10
     */
    @Override
    public MaterialPicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        if(enquiryPriceBillIds != null){
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper<MaterialContractEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("count(1) as num, IFNULL(sum(amount_with_tax),0) as money")
                        .eq("enquiry_price_bill_id", enquiryPriceBillId);
                Map<String, Object> map = this.getMap(queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if(MapUtils.isNotEmpty(map)){
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(0);
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }

                materialPicketageApi.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null);
    }

    @Override
    public CommonResponse<String> onFile(OtherContractVO contractVO) {
        MaterialContractEntity entity = this.selectById(contractVO.getId());
        if("1".equals(entity.getFileState())){
            throw new BusinessException("不能重复归档");
        }
        entity.setFileState("1");
        this.saveOrUpdate(entity, false);
        CommonResponse<String> back = attachmentApi.updateAttachRef(contractVO.getId(), contractVO.getAttachIds());
        if(!back.isSuccess()){
            throw new BusinessException("归档失败");
        }
        return CommonResponse.success("归档成功！");
    }

    @Override
    public Map<Long, List<MaterialContractPriceResultVO>> queryMaterialContractPrice(MaterialContractPriceQueryVO queryVO) {
        List<MaterialContractPriceResultVO> resultVOS = materialContractMapper.queryMaterialContractPrice(queryVO.getProjectId(), queryVO.getMaterialIds());
        Map<Long, List<MaterialContractPriceResultVO>> map = null;
        if(CollectionUtils.isNotEmpty(resultVOS)){
            map = resultVOS.stream().collect(Collectors.groupingBy(MaterialContractPriceResultVO::getMaterialId));
        } else {
            map = new HashMap<>();
        }
        return map;
    }

    @Override
    public Map<String, BigDecimal> purchaseInfo() {
        return baseMapper.purchaseInfo(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> supplierTop() {
        return baseMapper.supplierTop(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> financeData() {
        return baseMapper.financeData(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> efficiencyManagement() {
        return baseMapper.efficiencyManagement(InvocationInfoProxy.getTenantid());
    }

    @Override
    public Map<String, BigDecimal> storeMny() {
        return baseMapper.storeMny(InvocationInfoProxy.getTenantid());
    }

    /**
     * @description: 采购履约状态：本月/本年
     *
     * 材料申请批次：项目材料用料申请单据数
     *
     * 合同处理数量：被合同或询价引用的用料申请个数
     *
     * 合同签订数量：合同已审批、已提交数量（项目自采）
     *
     * 异常合同数量超期：用料申请5天未被引用的单据数
     *
     * 异常审批数量（超期）：合同审批超过3天的单据数
     *
     * @param startDate
     * @param endDate
     * @return {@link java.util.Map<java.lang.String,java.math.BigDecimal>}
     * @author songlx
     * @date: 2024/11/28
     */
    @Override
    public Map<String, BigDecimal> performanceStatus(String startDate, String endDate) {
        Map<String, BigDecimal> map = new HashMap<>();
        QueryWrapper<UseApplyEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        wrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.between("apply_date", startDate, endDate);
        int applyNum = useApplyService.count(wrapper);
        map.put("applyNum", ComputeUtil.toBigDecimal(applyNum));
        //  合同处理数量：被合同或询价引用的用料申请个数
        BigDecimal refNum = baseMapper.getRefCount(InvocationInfoProxy.getTenantid(), startDate, endDate);
        map.put("refNum", ComputeUtil.nullToZero(refNum));
        //  获取5天未被引用的单据
        BigDecimal unRefFiveDaysNum = baseMapper.getUnRefFiveCount(InvocationInfoProxy.getTenantid(), startDate, endDate);
        map.put("unRefFiveDaysNum", ComputeUtil.nullToZero(unRefFiveDaysNum));

        QueryWrapper<MaterialContractEntity> contractWrapper = new QueryWrapper<>();
        contractWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        contractWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        contractWrapper.between("sign_date", startDate, endDate);
        contractWrapper.isNotNull("project_id");
        int contractSignNum = this.count(contractWrapper);
        map.put("contractSignNum", ComputeUtil.toBigDecimal(contractSignNum));

        //异常审批数量（超期）：合同审批超过3天的单据数
        QueryWrapper<MaterialContractEntity> threeWrapper = new QueryWrapper<>();
        threeWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        threeWrapper.in("bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        threeWrapper.between("sign_date", startDate, endDate);
        threeWrapper.isNotNull("project_id");
        threeWrapper.apply("DATEDIFF( NOW(), commit_date ) > 3");
        int unPassThreeNum = this.count(threeWrapper);
        map.put("unPassThreeNum", ComputeUtil.toBigDecimal(unPassThreeNum));

        return map;
    }
}
