package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICtrlSetApi;
import com.ejianc.business.cost.vo.CtrlSetDetailVO;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:10
 */
@Service(value = "materialMasterPlanService")
public class MaterialMasterPlanServiceImpl extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity> implements IMaterialMasterPlanService {

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741"; // 【预算材料费总金额】 控 【物资总计划金额】
    private static final String PARAM_NUM = "P-uFOcn644"; // 预算材料清单量控
    private static final String PARAM_TAX_MNY = "P-14dTg745"; // 预算材料清单金额控
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private ICtrlSetApi ctrlSetApi;
    @Autowired
    private UseApplyMapper useApplyMapper;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("plan_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if (null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper<MaterialMasterPlanEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = materialMasterPlanMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        //更新子表信息
        if (null != saveEntity.getId()) {
            materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate(saveEntity, false);
        return saveEntity;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, String billType, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(billType)) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(billType)) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    /**
     * 参数控制
     *
     * @param vo 物资总计划vo
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};

        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());

        // 预算材料清单量控、预算材料清单金额控
        List<PlanControlSubVO> materialSubList = vo.getPlanControlSubVOList();
        // 物资总计划没有物资明细，不控制直接返回
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            // 没有预算清单不控制
            List<Long> subIds = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
            // 预算材料清单量
            BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
            paramControlVO1.setProjectId(vo.getProjectId());
            paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
            paramControlVO1.setIds(subIds);
            logger.info("参数：" , JSONObject.toJSONString(paramControlVO1));
            CommonResponse<BudgetProjectProQuantityAndMnyVO> res1 = budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
            if (!res1.isSuccess()) {
                throw new BusinessException("预算材料清单量，查询项目预算信息失败，失败原因：" + res1.getMsg());
            }
            if (null != res1.getData()) {
                BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO = res1.getData();
                Map<Long, BudgetProjectDetailProVO> detailProMap = proQuantityAndMnyVO.getDetailProMap();
                if (!detailProMap.isEmpty()) {
                    //查询控制参数
                    List<Long> categoryIds = materialSubList.stream().map(e -> e.getMaterialCategoryId()).distinct().collect(Collectors.toList());
                    CommonResponse<List<CtrlSetDetailVO>> listCommonResponse = ctrlSetApi.querySetDetailByCategory(categoryIds);
                    if (!listCommonResponse.isSuccess()){
                        throw  new BusinessException("查询物料管控设置失败，失败原因：" + listCommonResponse.getMsg());
                    }
                    if (CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                        List<CtrlSetDetailVO> data = listCommonResponse.getData();
                        Map<Long, List<CtrlSetDetailVO>> controlMap =  data.stream().collect(Collectors.groupingBy(e -> e.getSetId()));
                        //开始组装数据
                        for (PlanControlSubVO planControlSubVO : materialSubList){

                            //判断是否有成本
                            if (detailProMap.containsKey(planControlSubVO.getMaterialId())){
                                //判断是否有规则
                                if (controlMap.containsKey(planControlSubVO.getMaterialCategoryId())){
                                    //获取成本
                                    BudgetProjectDetailProVO budgetProjectDetailProVO = detailProMap.get(planControlSubVO.getMaterialId());
                                    BigDecimal costNum = budgetProjectDetailProVO.getNum();
                                    BigDecimal costMny = budgetProjectDetailProVO.getMaterialTaxMnyCost();
                                    //获取规则
                                    List<CtrlSetDetailVO> ctrlSetDetailVO = controlMap.get(planControlSubVO.getMaterialCategoryId());
                                    //获取计划量
                                    BigDecimal planNum = new BigDecimal(planControlSubVO.getNum().toString());
                                    //获取计划金额
                                    BigDecimal planMny = planControlSubVO.getAmount();
                                    //【材料总计划量】>【材料目标成本量】* X%
                                    for (CtrlSetDetailVO setDetail : ctrlSetDetailVO){
                                        //明细量控2
                                        if (setDetail.getControlType()==1){
                                            BigDecimal cost = ComputeUtil.safeMultiply(costNum, setDetail.getControlScale());
                                            cost = ComputeUtil.safeDiv(cost, new BigDecimal("100"));
                                            if (ComputeUtil.isGreaterThan(planNum, cost)){
                                                BigDecimal exceed = ComputeUtil.safeSub(planNum, cost);
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(planControlSubVO.getMaterialId(), "num");
                                                paramsCheckDsVO.setOrgName("华康");
                                                paramsCheckDsVO.setWarnItem(planControlSubVO.getMaterialName()  + "-" + planControlSubVO.getSpec()+"计划量超额预警");
                                                paramsCheckDsVO.setWarnName("材料总计划量超目标成本量");

                                                StringBuffer stringBuffer = new StringBuffer();
                                                String text = "超出数量="+planNum.setScale(2, RoundingMode.HALF_UP)
                                                        +"-"+costNum.setScale(2, RoundingMode.HALF_UP)
                                                        +"*"+setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)
                                                        +"% ="+exceed.setScale(2, RoundingMode.HALF_UP)+planControlSubVO.getUnit()+"。";
                                                String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();


                                                stringBuffer.append("总计划量：")
                                                        .append(planNum.setScale(2, RoundingMode.HALF_UP))
                                                        .append(planControlSubVO.getUnit())
                                                        .append("，目标成本量：")
                                                        .append(costNum.setScale(2, RoundingMode.HALF_UP))
                                                        .append(planControlSubVO.getUnit())
                                                        .append("，管控比例：")
                                                        .append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP))
                                                        .append("%：")
                                                        .append(redText);
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod()==1?"warn":"alert", paramsCheckDsVO);
                                            }
                                        }else {
                                            //明细金额控
                                            BigDecimal cost = ComputeUtil.safeMultiply(costMny, setDetail.getControlScale());
                                            cost = ComputeUtil.safeDiv(cost, new BigDecimal("100"));
                                            if (ComputeUtil.isGreaterThan(planMny, cost)){
                                                BigDecimal exceed = ComputeUtil.safeSub(planMny, cost);
                                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(planControlSubVO.getMaterialId(), "mny");
                                                paramsCheckDsVO.setOrgName("华康");
                                                paramsCheckDsVO.setWarnItem(planControlSubVO.getMaterialName()  + "-" + planControlSubVO.getSpec()+"计划金额超额预警");
                                                paramsCheckDsVO.setWarnName("材料总计划金额超目标成本金额");
                                                StringBuffer stringBuffer = new StringBuffer();
                                                String text = "超出金额="+planMny.setScale(2, RoundingMode.HALF_UP)
                                                        +"-"+costMny.setScale(2, RoundingMode.HALF_UP)
                                                        +"*"+setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)
                                                        +"% ="+exceed.setScale(2, RoundingMode.HALF_UP)+"元。";
                                                String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                                                stringBuffer.append("总计划金额：")
                                                        .append(planMny.setScale(2, RoundingMode.HALF_UP))
                                                        .append("元，目标成本金额：")
                                                        .append(costMny.setScale(2, RoundingMode.HALF_UP))
                                                        .append("元，管控比例：")
                                                        .append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP))
                                                        .append("%：")
                                                        .append(redText);
                                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod()==1?"warn":"alert", paramsCheckDsVO);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public void querySumApplyNum(MaterialMasterPlanVO vo) {
        //查询该物资用料申请已生效的申请量
        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("sourceIds",  vo.getMaterialSubList().stream().map(MaterialMasterPlanSubVO::getId).collect(Collectors.toList()));
        List<UseApplySubVO> applylist = useApplyMapper.countSumApplyBySource(queryParam);

        Map<Long, BigDecimal> map = applylist.stream().collect(Collectors.groupingBy(UseApplySubVO::getSourceId, Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
        List<MaterialMasterPlanSubVO> materialSubList = vo.getMaterialSubList();
        for (MaterialMasterPlanSubVO materialMasterPlanSubVO : materialSubList) {
            materialMasterPlanSubVO.setSumApplyNum(map.get(materialMasterPlanSubVO.getId()));
            materialMasterPlanSubVO.setSurplusApplyNum(ComputeUtil.safeSub(ComputeUtil.toBigDecimal(materialMasterPlanSubVO.getNum()), materialMasterPlanSubVO.getSumApplyNum()));
        }

    }
}
