package com.ejianc.business.storeCheck.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 仓库盘点物资明细
 *
 * @author CJ
 * @Description: 仓库盘点物资明细
 * @date 2021/3/12 16:00
 */
@TableName(value = "ejc_material_store_check_sub")
public class StoreCheckSubEntity extends BaseEntity {

    private static final long serialVersionUID = -3902537836758868734L;
    /**
     * 所属盘点单据Id
     */
    @TableField(value = "store_check_id")
    private Long storeCheckId;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_category_id")
    private Long materialCategoryId;
    /**
     * 物资分类名称
     */
    @TableField(value = "material_category_name")
    private String materialCategoryName;
    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private Long materialId;
    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;
    /**
     * 规格型号
     */
    @TableField(value = "spec")
    private String spec;
    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;
    /**
     * 账目数量
     */
    @TableField(value = "acc_num")
    private Double accNum;
    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;
    /**
     * 账面金额
     */
    @TableField(value = "acc_amount")
    private BigDecimal accAmount;

    /**
     * 盘点数量
     */
    @TableField(value = "check_num")
    private Double checkNum;

    /**
     * 盘点盈亏
     */
    @TableField(value = "inventory")
    private Double inventory;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;
    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;
    @TableField(value="brand_id")
    private Long brandId; // 品牌id
    @TableField(value="brand_name")
    private String brandName; // 品牌
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getStoreCheckId() {
        return storeCheckId;
    }

    public void setStoreCheckId(Long storeCheckId) {
        this.storeCheckId = storeCheckId;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getAccNum() {
        return accNum;
    }

    public void setAccNum(Double accNum) {
        this.accNum = accNum;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAccAmount() {
        return accAmount;
    }

    public void setAccAmount(BigDecimal accAmount) {
        this.accAmount = accAmount;
    }

    public Double getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(Double checkNum) {
        this.checkNum = checkNum;
    }

    public Double getInventory() {
        return inventory;
    }

    public void setInventory(Double inventory) {
        this.inventory = inventory;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
