package com.ejianc.business.delivery.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材送货单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_delivery")
public class MaterialDeliveryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="order_id")
    private Long orderId; // 订单主键
    @TableField(value="order_bill_code")
    private String orderBillCode; // 订单单据编号
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同code
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="deliver_id")
    private Long deliverId; // 送货人名称
    @TableField(value="deliver_name")
    private String deliverName; // 送货人名称
    @TableField(value="deliver_phone")
    private String deliverPhone; // 送货人联系电话
    @TableField(value="arrive_date")
    private Date arriveDate; // 预计到货日期
    @TableField(value="license_plate")
    private String licensePlate; // 车牌号
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="close_flag")
    private Integer closeFlag; // 是否关闭，0-否，1-是
    @TableField(value="check_status")
    private Integer checkStatus; // 验收状态，0-待接收,1-部分接收,2-全部接收
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="check_type")
    private String checkType; // 验收类型，proMaterial-1,大宗材proMaterial-2,周转材proMaterial-3,零星材料proMaterial-4, 甲供材
    @TableField(value="check_type_name")
    private String checkTypeName; // 验收类型，proMaterial-1,大宗材proMaterial-2,周转材proMaterial-3,零星材料proMaterial-4, 甲供材
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="ticket_num")
    private BigDecimal ticketNum; // 小票数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="system_id")
    private String systemId; // 来源系统主键

    @TableField(value="supplier_id")
    private Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称

    @TableField(value="link_id")
    private Long linkId; // 订单联系人
    @TableField(value="link_name")
    private String linkName; // 订单联系人名称
    @TableField(value="order_expiry_date")
    private Date orderExpiryDate; // 订单要求到货日期
    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; //自动称重设置（0：自动称重，1非自动称重）
    @TableField(value="express_number")
    private String expressNumber; // 物流单号
    @TableField(value="apply_id")
    private Long applyId; // 用料申请主键
    @TableField(value="store_status")
    private Integer storeStatus; // 入库状态，0-待入库,1-部分入库,2-全部入库
    @TableField(exist=false)
    private BigDecimal taxRate;// 税率
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialDeliveryDetailService",pidName = "deliveryId")//此处有pid="xxx"，默认值pid="pid"
    private List<MaterialDeliveryDetailEntity> materialDeliveryDetailList = new ArrayList<>(); // 消耗材送货单明细表

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public String getOrderBillCode() {
        return orderBillCode;
    }

    public void setOrderBillCode(String orderBillCode) {
        this.orderBillCode = orderBillCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDeliverName() {
        return deliverName;
    }

    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    public String getDeliverPhone() {
        return deliverPhone;
    }

    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    public Date getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Integer closeFlag) {
        this.closeFlag = closeFlag;
    }
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }
    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getDeliverId() {
        return deliverId;
    }

    public void setDeliverId(Long deliverId) {
        this.deliverId = deliverId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }

    public String getExpressNumber() {
        return expressNumber;
    }

    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Integer getStoreStatus() {
        return storeStatus;
    }

    public void setStoreStatus(Integer storeStatus) {
        this.storeStatus = storeStatus;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public List<MaterialDeliveryDetailEntity> getMaterialDeliveryDetailList() {
        return materialDeliveryDetailList;
    }

    public void setMaterialDeliveryDetailList(List<MaterialDeliveryDetailEntity> materialDeliveryDetailList) {
        this.materialDeliveryDetailList = materialDeliveryDetailList;
    }
}
