package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.vo.*;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资总计划-变更控制器
 *
 * @author CJ
 * @Description: 物资总计划-变更控制器
 * @date 2021/3/5 10:05
 */
@RestController
@RequestMapping(value = "/planChange/")
public class PlanChangeController {

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IPlanChangeService planChangeService;

    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;

    /**
     * 物资总计划变更-保存、更新
     *
     * @param planVo
     * @return
     */
    @PostMapping(value = "saveOrUpdate")
    public CommonResponse<PlanChangeVO> saveOrUpdate(@RequestBody PlanChangeVO planVo) {

        archivesUtil.checkHaveTempMaterial(planVo.getMaterialSubList());
        //校验项目是否存在未完成的变更计划单存在
        PlanChangeEntity planChangeEntity = planChangeService.getUnFinishedChange(planVo.getSourcePlanId());

        if(null !=planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            return CommonResponse.error("保存失败，该项目存在未完成的变更计划！");
        }

        MaterialMasterPlanEntity masterPlan = materialMasterPlanService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        PlanChangeEntity saveEntity = null;
        if(null == planVo.getId()) {

            saveEntity = BeanMapper.map(planVo, PlanChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        } else {
            saveEntity = planChangeService.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList(planVo.getMaterialSubList(), PlanChangeSubEntity.class));
        }
            saveEntity.setChangeReason(planVo.getChangeReason());
        if(null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        long id = IdWorker.getId();
        if (saveEntity.getId() == null) {
            saveEntity.setId(id);
        }
        List<PlanChangeSubVO> materialSubList = planVo.getMaterialSubList();
        if (CollectionUtils.isNotEmpty(materialSubList)){
            for (PlanChangeSubVO planChangeSubVO : materialSubList) {
                String onlykey= planChangeSubVO.getMaterialCategoryName()+planChangeSubVO.getMaterialName()+planChangeSubVO.getUnit()+planChangeSubVO.getSpec()+planChangeSubVO.getMaterialCode();
                planChangeSubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, saveEntity.getId(), saveEntity.getPlanCode(), saveEntity.getProjectName(),"物资总计划变更");
            JSONObject jsonObject = archivesUtil.batchSaveArchive(archiveVO, materialSubList, "materialCategoryId", "materialId",
                    "materialCategoryName", "materialName", "materialCode","unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<PlanChangeSubVO> list = JSONObject.parseArray(sourceList, PlanChangeSubVO.class);
            List<PlanChangeSubEntity> materialMasterPlanSubEntities = BeanMapper.mapList(list, PlanChangeSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }

        saveEntity = planChangeService.saveOrUpdatePlanChange(saveEntity);

        return CommonResponse.success("保存成功！", BeanMapper.map(saveEntity, PlanChangeVO.class));
    }

    @GetMapping("queryDetail")
    public CommonResponse<PlanChangeVO> queryDetail(@RequestParam(value = "id") Long id) {
        PlanChangeVO vo = null;
        PlanChangeEntity dbEntity = planChangeService.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, PlanChangeVO.class);
            if (CollectionUtils.isNotEmpty(vo.getMaterialSubList())) {
                planChangeService.querySumApplyNum(vo);
            }
        }
        return CommonResponse.success("查询物资总计划详情成功！", vo);
    }

    @PostMapping(value = "delete")
    public CommonResponse<String> delete(@RequestBody List<PlanChangeHisVO> vos) {
        planChangeService.deleteChangePlan(vos.stream().map(PlanChangeHisVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }
}
