package com.ejianc.business.plan.service;

import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:08
 */
public interface IMaterialMasterPlanService extends IBaseService<MaterialMasterPlanEntity> {

    /**
     * 根据编码查询物资总计划
     *
     * @param planCode
     * @return
     */
    MaterialMasterPlanVO queryByCode(String planCode);

    /**
     * 根据项目Id来查询物资总计划
     *
     * @param projectId
     * @return
     */
    MaterialMasterPlanVO queryByProjectId(Long projectId);

	/**
	 * 保存或更新物资总计划
	 *
	 * @param saveEntity
	 */
	MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity);

	/**
	 * 参数控制
	 *
	 * @param vo 物资总计划vo
	 *
	 * @return {@link ParamsCheckVO}
	 */
	ParamsCheckVO checkParams(PlanControlVO vo);

    void querySumApplyNum(MaterialMasterPlanVO vo);
}
