/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.InstoreBillEntity;
import com.ejianc.business.material.bean.InstoreBillMaterialEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreBillMaterialService;
import com.ejianc.business.material.service.IInstoreBillService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreBillMaterialVO;
import com.ejianc.business.material.vo.InstoreBillVO;
import com.ejianc.business.material.vo.InstoreExportVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/instoreBill/"})
public class InstoreBillController {
    private static final String BILL_CODE = "MATERIAL-INSTORE";
    @Autowired
    IInstoreBillService instoreBillService;
    @Autowired
    IInstoreService instoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IInstoreBillMaterialService instoreBillMaterialService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    IStoreService storeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBrandApi brandApi;

    @RequestMapping(value={"checkParamsById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParamsById(@RequestBody MaterialPriceVO vo) {
        Long projectId;
        InstoreBillEntity byId;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        Long id = vo.getId();
        if (id != null && null != (byId = (InstoreBillEntity)((Object)this.instoreBillService.selectById(id))) && null != (projectId = byId.getProjectId())) {
            List<InstoreBillMaterialEntity> instoreMaterialList;
            vo.setProjectId(projectId);
            if (CollectionUtils.isEmpty((Collection)vo.getDetail()) && CollectionUtils.isNotEmpty(instoreMaterialList = byId.getInstoreMaterialList())) {
                ArrayList detail = new ArrayList();
                instoreMaterialList.forEach(item -> {
                    MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                    materialPriceVO.setId(item.getMaterialId());
                    materialPriceVO.setMaterialId(item.getMaterialId());
                    materialPriceVO.setMaterialName(item.getMaterialName());
                    materialPriceVO.setSpec(item.getMaterialSpec());
                    materialPriceVO.setNum(item.getInstoreNumber());
                    detail.add(materialPriceVO);
                });
                vo.setDetail(detail);
            }
            paramsCheckVO = this.instoreBillMaterialService.checkParams(vo);
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = this.instoreBillMaterialService.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreBillVO> saveOrUpdate(@RequestBody InstoreBillVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.beforeSave(vo);
        InstoreBillEntity entity = (InstoreBillEntity)((Object)BeanMapper.map((Object)vo, InstoreBillEntity.class));
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"tenant_id", (Object)tenantId);
            wrapper.eq((Object)"bill_code", (Object)vo.getBillCode());
            wrapper.eq(vo.getId() != null, (Object)"id", (Object)vo.getId());
            int count = this.instoreBillService.count((Wrapper)wrapper);
            QueryWrapper instoreEntityQueryWrapper = new QueryWrapper();
            instoreEntityQueryWrapper.eq((Object)"tenant_id", (Object)tenantId);
            instoreEntityQueryWrapper.eq((Object)"bill_code", (Object)vo.getBillCode());
            int count1 = this.instoreService.count((Wrapper)instoreEntityQueryWrapper);
            if (count > 0 || count1 > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u5355\u53f7\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setUserName(this.sessionManager.getUserContext().getUserName());
            entity.setPaymentFlag(0);
        }
        this.instoreBillService.saveOrUpdate((Object)entity, false);
        InstoreBillVO backVo = (InstoreBillVO)BeanMapper.map((Object)((Object)entity), InstoreBillVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    public void beforeSave(InstoreBillVO vo) {
        if (vo.getTaxRate() == null && !MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
            vo.setTaxRate(new BigDecimal("0.00"));
        }
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalAmount = new BigDecimal(0);
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if (!ListUtil.isEmpty((List)vo.getInstoreMaterialList())) {
            String materialName = "";
            for (InstoreBillMaterialVO sub : vo.getInstoreMaterialList()) {
                if ("del".equals(sub.getRowState())) continue;
                sub.setStoreId(vo.getStoreId());
                sub.setInstoreDate(vo.getInstoreDate());
                sub.setStoreState(MaterialStoreState.STORING.getCode());
                sub.setInstoreType(vo.getInstoreType());
                materialName = materialName.length() > 0 ? materialName + "\u3001" + sub.getMaterialName() : materialName + sub.getMaterialName();
                totalCount = totalCount.add(sub.getInstoreNumber());
                totalAmount = totalAmount.add(sub.getAmount());
                if (!MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
                    sub.setTaxRate(vo.getTaxRate());
                }
                totalAmountNoTax = totalAmountNoTax.add(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4)), 8, 4));
            }
            vo.setMaterialName(materialName);
        }
        vo.setTotalAmount(totalAmount);
        vo.setTotalAmountNoTax(totalAmountNoTax);
        vo.setTotalCount(totalCount);
        if ("hasContract".equals(vo.getContractType())) {
            this.materialContractService.checkContract(vo.getContractId());
        }
    }

    @RequestMapping(value={"pushToCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreBillVO> pushToCost(@RequestBody InstoreBillVO vo) {
        this.beforeSave(vo);
        InstoreBillEntity entity = (InstoreBillEntity)((Object)BeanMapper.map((Object)vo, InstoreBillEntity.class));
        this.instoreBillService.processCost(entity);
        this.instoreBillService.saveOrUpdate((Object)entity, false);
        InstoreBillVO backVo = (InstoreBillVO)BeanMapper.map((Object)((Object)entity), InstoreBillVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u5173\u8054\u6210\u529f\uff01", (Object)backVo);
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InstoreBillVO> queryDetail(Long id) {
        InstoreBillEntity entity = (InstoreBillEntity)((Object)this.instoreBillService.selectById(id));
        InstoreBillVO vo = (InstoreBillVO)BeanMapper.map((Object)((Object)entity), InstoreBillVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage<InstoreBillVO> page = this.instoreBillService.queryForList(param, false);
        List list = page.getRecords();
        BigDecimal allTotalAmount = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            allTotalAmount = this.instoreBillMaterialService.countAmount(param);
        }
        for (InstoreBillVO vo : list) {
            vo.setAllTotalAmount(allTotalAmount);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", this.instoreBillService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstoreBillVO> vos) {
        this.instoreBillService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<InstoreBillVO> voPage = this.instoreBillService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            InstoreExportVO exportVO = (InstoreExportVO)BeanMapper.map((Object)vo, InstoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
            exportVO.setInstoreDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getInstoreDate()));
            if (vo.getReceiveDate() != null) {
                exportVO.setReceiveDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getReceiveDate()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getReceiveState())) {
                if ("1".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("\u5f85\u6536");
                } else if ("2".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("\u5df2\u6536\u6599");
                } else {
                    exportVO.setReceiveState("\u5df2\u9000\u56de\uff1a" + vo.getPickReturnReason());
                }
            }
            exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        String fileName = "instoreListExport.xlsx";
        if (queryParam.getParams().get("instoreType") != null) {
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.RECEIVE_IN_STORE.getCode().toString())) {
                fileName = "instoreListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode().toString())) {
                fileName = "straightInoutListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.RETURN_IN_STORE.getCode().toString())) {
                fileName = "pickReturnListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.ALLOCATION_IN_STORE.getCode().toString())) {
                fileName = "allocationInExport.xlsx";
            }
        }
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<InstoreMaterialVO> successList = new ArrayList<InstoreMaterialVO>();
        ArrayList<InstoreMaterialVO> errorList = new ArrayList<InstoreMaterialVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 8) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                InstoreMaterialVO instoreMaterialVO = new InstoreMaterialVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    instoreMaterialVO.setErrorMessage("\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String materialCategoryName = ((String)datas.get(0)).toString().trim();
                    instoreMaterialVO.setMaterialCategoryName(materialCategoryName);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    instoreMaterialVO.setMaterialName((String)datas.get(1));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    instoreMaterialVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    instoreMaterialVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    instoreMaterialVO.setMaterialSpec((String)datas.get(2));
                }
                if (!Objects.isNull(datas.get(3))) {
                    instoreMaterialVO.setMaterialUnit(((String)datas.get(3)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    instoreMaterialVO.setBrandId(null);
                    instoreMaterialVO.setBrandName(null);
                } else {
                    String brandName = (String)datas.get(4);
                    CommonResponse brandVOCommonResponse = this.brandApi.queryBrandByName(brandName);
                    if (!brandVOCommonResponse.isSuccess()) {
                        instoreMaterialVO.setErrorMessage("\u5339\u914d\u67e5\u8be2\u54c1\u724c\u5931\u8d25\uff01");
                        errorList.add(instoreMaterialVO);
                        continue;
                    }
                    if (null == brandVOCommonResponse.getData()) {
                        instoreMaterialVO.setErrorMessage("\u5339\u914d\u67e5\u8be2\u54c1\u724c\u4e3a\u7a7a\uff01");
                        errorList.add(instoreMaterialVO);
                        continue;
                    }
                    instoreMaterialVO.setBrandName(brandName);
                    instoreMaterialVO.setBrandId(((BrandVO)brandVOCommonResponse.getData()).getId());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) && ((String)datas.get(7)).length() > 64) {
                    instoreMaterialVO.setErrorMessage("\u7269\u6599\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    instoreMaterialVO.setMaterialCode((String)datas.get(7));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) && ((String)datas.get(6)).length() > 50) {
                    instoreMaterialVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    instoreMaterialVO.setRemark((String)datas.get(8));
                }
                instoreMaterialVO.setSourceType("import");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        instoreMaterialVO.setInstoreNumber(new BigDecimal((String)datas.get(5)));
                        if (instoreMaterialVO.getInstoreNumber().longValue() < 0L) {
                            instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        instoreMaterialVO.setUnitPrice(new BigDecimal((String)datas.get(6)));
                        if (instoreMaterialVO.getUnitPrice().doubleValue() < 0.0) {
                            instoreMaterialVO.setErrorMessage("\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        instoreMaterialVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    instoreMaterialVO.setUnitPrice(new BigDecimal(0));
                }
                if (instoreMaterialVO.getInstoreNumber() != null && instoreMaterialVO.getUnitPrice() != null) {
                    BigDecimal amount = instoreMaterialVO.getUnitPrice().multiply(instoreMaterialVO.getInstoreNumber());
                    instoreMaterialVO.setAmount(amount);
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)instoreMaterialVO.getErrorMessage())) {
                    MaterialVO vo = new MaterialVO();
                    vo.setName(instoreMaterialVO.getMaterialName());
                    vo.setSpec(instoreMaterialVO.getMaterialSpec());
                    vo.setUnitName(instoreMaterialVO.getMaterialUnit());
                    CommonResponse listCommonResponse = this.materialApi.queryMaterialList(vo);
                    if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                        MaterialVO materialVo = (MaterialVO)((List)listCommonResponse.getData()).get(0);
                        instoreMaterialVO.setMaterialCategoryId(materialVo.getCategoryId());
                        instoreMaterialVO.setMaterialCategoryName(materialVo.getCategoryName());
                        instoreMaterialVO.setMaterialId(materialVo.getId());
                        successList.add(instoreMaterialVO);
                        continue;
                    }
                    instoreMaterialVO.setErrorMessage("\u8be5\u7269\u8d44\u4e0d\u5b58\u5728");
                    instoreMaterialVO.setId(Long.valueOf(i));
                    errorList.add(instoreMaterialVO);
                    continue;
                }
                errorList.add(instoreMaterialVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"sureToReceive"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReceive(@RequestBody InstoreBillVO vo) {
        InstoreBillEntity entity = (InstoreBillEntity)((Object)this.instoreBillService.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setStoreId(vo.getStoreId());
        entity.setStoreName(vo.getStoreName());
        entity.setBillState(1);
        entity.setReceiveState(MaterialAllocationState.RECEIVED.getCode());
        this.instoreBillService.sureToReceive(entity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"sureToReturn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReturn(@RequestBody InstoreBillVO vo) {
        InstoreBillEntity entity = (InstoreBillEntity)((Object)this.instoreBillService.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setReceiveState(MaterialAllocationState.REJECT.getCode());
        entity.setPickReturnReason(vo.getPickReturnReason());
        this.instoreBillService.sureToReturn(entity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryRefNopaymnetList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        Long orgId = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            orgId = Long.parseLong(json.get((Object)"orgId").toString());
            if (json.get((Object)"contractType") != null) {
                param.getParams().put("contractType", new Parameter("in", json.get((Object)"contractType")));
            }
            if (json.get((Object)"supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", json.get((Object)"supplierId")));
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("instoreType", new Parameter("in", (Object)"1,2"));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("paymentFlag", new Parameter("eq", (Object)"0"));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("paymentFlag", new Parameter("eq", null));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        IPage<InstoreBillVO> page = this.instoreBillService.queryForList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5165\u5e93\u5355\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"queryRefNotSettlementList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryRefNotSettlementList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            param.getParams().put("orgId", new Parameter("eq", json.get((Object)"orgId")));
            if (json.get((Object)"contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", json.get((Object)"contractId")));
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("instoreType", new Parameter("in", (Object)"1,2"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("settlementFlag", new Parameter("eq", (Object)"0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("settlementFlag", new Parameter("eq", null));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        IPage<InstoreBillVO> page = this.instoreBillService.queryForList(param, false);
        this.setType(page.getRecords());
        return CommonResponse.success((String)"\u67e5\u8be2\u5165\u5e93\u5355\u6570\u636e\u6210\u529f\uff01", page);
    }

    public void setType(List<InstoreBillVO> list) {
        if (ListUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                InstoreBillEntity entity = (InstoreBillEntity)((Object)((Object)this.instoreBillService.selectById(l.getId())));
                if (ListUtil.isNotEmpty(entity.getInstoreMaterialList())) {
                    List<InstoreBillMaterialEntity> entities = entity.getInstoreMaterialList();
                    l.setInstoreMaterialList(BeanMapper.mapList(entities, InstoreBillMaterialVO.class));
                }
                l.setInstoreTypeName(MaterialStoreType.getStoreTypeNameByCode((Integer)l.getInstoreType()));
            });
        }
    }

    @GetMapping(value={"printDetail"})
    @ResponseBody
    public JSONObject printDetail(@RequestParam(value="id") Long id) {
        JSONObject resp = new JSONObject();
        JSONObject data = new JSONObject();
        InstoreBillEntity entity = (InstoreBillEntity)((Object)this.instoreBillService.selectById(id));
        Map entityMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)entity)), Map.class);
        entityMap.put("InstoreMaterial", entityMap.get("instoreMaterialList"));
        entityMap.remove("instoreMaterialList");
        data.put("Instore", (Object)entityMap);
        resp.put("data", (Object)data);
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01");
        return resp;
    }

    @RequestMapping(value={"queryPhotographList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreBillVO>> queryPhotographList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        param.getOrderMap().put("createTime", "desc");
        IPage<InstoreBillVO> page = this.instoreBillService.queryForList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"saveOrUpdatePhotograph"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreBillVO> saveOrUpdatePhotograph(@RequestBody InstoreBillVO vo) {
        if (vo.getId() == null || vo.getId() == 0L) {
            vo.setTaxRate(new BigDecimal("0.00"));
            BigDecimal totalCount = new BigDecimal(0);
            BigDecimal totalAmount = new BigDecimal(0);
            BigDecimal totalAmountNoTax = new BigDecimal(0);
            vo.setTotalAmount(totalAmount);
            vo.setTotalAmountNoTax(totalAmountNoTax);
            vo.setTotalCount(totalCount);
            vo.setContractType("hasContract");
            vo.setInstoreType(MaterialStoreType.STRAIGHT_IN_STORE.getCode());
            CommonResponse response = this.projectApi.queryProjectList(1);
            if (!response.isSuccess() || ListUtil.isEmpty((List)((List)response.getData()))) {
                return CommonResponse.error((String)"\u6ca1\u627e\u5230\u4efb\u4f55\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u9879\u76ee\uff01");
            }
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)response.getData()).get(0);
            vo.setOrgId(projectRegisterVO.getProjectDepartmentId());
            vo.setOrgName(projectRegisterVO.getName());
            vo.setProjectId(projectRegisterVO.getId());
            vo.setProjectName(projectRegisterVO.getName());
            vo.setInstoreDate(new Date());
            StoreVO storeVO = this.storeService.queryNewestStoreByOrgId(projectRegisterVO.getProjectDepartmentId());
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (storeVO != null) {
                vo.setStoreId(storeVO.getId());
                vo.setStoreName(vo.getStoreName());
            }
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            vo.setBillCode((String)billCode.getData());
            vo.setUserName(this.sessionManager.getUserContext().getUserName());
            vo.setPaymentFlag(Integer.valueOf(0));
        }
        InstoreBillEntity entity = (InstoreBillEntity)((Object)BeanMapper.map((Object)vo, InstoreBillEntity.class));
        this.instoreBillService.saveOrUpdate((Object)entity, false);
        InstoreBillVO backVo = (InstoreBillVO)BeanMapper.map((Object)((Object)entity), InstoreBillVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody InstoreBillVO instoreBillVO, HttpServletResponse response) {
        InstoreBillEntity entity = (InstoreBillEntity)((Object)this.instoreBillService.selectById(instoreBillVO.getId()));
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<InstoreBillMaterialEntity> data = entity.getInstoreMaterialList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                InstoreMaterialVO vo = (InstoreMaterialVO)BeanMapper.map((Object)item, InstoreMaterialVO.class);
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("straightInoutMaterialExport.xlsx", beans, response);
    }
}

