/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"materialContractFileUpdate"})
public class MaterialContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialContractService materialContractService;

    @PostMapping(value={"/updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        Long billId = updateData.getLong("billId");
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(MaterialContractEntity::getContractFileId, (Object)updateData.getLong("fileId"));
        this.materialContractService.update((Wrapper)updateWrapper);
        JSONObject resp = new JSONObject();
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"/getBillDataJson"})
    public CommonResponse<MaterialContractVO> getBillDataJson(@RequestParam Long id) {
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.materialContractService.selectById(id));
        MaterialContractVO vo = (MaterialContractVO)BeanMapper.map((Object)((Object)contractEntity), MaterialContractVO.class);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/onFile"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> onFile(@RequestBody OtherContractVO contractVO) {
        return this.materialContractService.onFile(contractVO);
    }
}

