/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.delivery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.delivery.bean.MaterialDeliveryDetailEntity;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.enums.CloseFlagEnum;
import com.ejianc.business.delivery.enums.DeliverCheckStateEnum;
import com.ejianc.business.delivery.enums.OrderDeliverStateEnum;
import com.ejianc.business.delivery.enums.StoreStatusEnum;
import com.ejianc.business.delivery.mapper.MaterialDeliveryMapper;
import com.ejianc.business.delivery.service.IMaterialDeliveryDetailService;
import com.ejianc.business.delivery.service.IMaterialDeliveryService;
import com.ejianc.business.delivery.vo.MaterialDeliveryDetailVO;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IPurchaseOrderService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialDeliveryService")
public class MaterialDeliveryServiceImpl
extends BaseServiceImpl<MaterialDeliveryMapper, MaterialDeliveryEntity>
implements IMaterialDeliveryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "HK_MATERIAL_DELIVERY";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchaseOrderService orderService;
    @Autowired
    private IMaterialDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IInstoreService storeService;
    @Autowired
    private IInstoreMaterialService storeMaterialService;

    @Override
    public IPage<MaterialDeliveryVO> queryDeliverList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("createTime", "desc");
        }
        IPage page = super.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialDeliveryVO.class));
        return pageData;
    }

    @Override
    public MaterialDeliveryVO saveDeliver(MaterialDeliveryVO saveOrUpdateVO) {
        List checkList;
        Long orderId = saveOrUpdateVO.getOrderId();
        PurchaseOrderEntity orderEntity = (PurchaseOrderEntity)((Object)this.orderService.selectById(orderId));
        Integer sendToSupplier = orderEntity.getSendToSupplier();
        Integer billState = orderEntity.getBillState();
        if (sendToSupplier != 1 || !Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()).contains(billState)) {
            throw new BusinessException("\u91c7\u8d2d\u8ba2\u5355\u534f\u540c\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0c\u4fdd\u5b58\u53d1\u8d27\u5355\u5931\u8d25\uff01");
        }
        QueryParam checkParam = new QueryParam();
        checkParam.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        checkParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (saveOrUpdateVO.getId() != null) {
            checkParam.getParams().put("id", new Parameter("ne", (Object)saveOrUpdateVO.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(checkParam)))) {
            throw new BusinessException("\u5f53\u524d\u8ba2\u5355\u5b58\u5728\u672a\u751f\u6548\u7684\u9001\u8d27\u5355\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getMaterialDeliveryDetailList())) {
            throw new BusinessException("\u9001\u8d27\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialDeliveryEntity.class));
        entity.setLinkId(orderEntity.getEmployeeId());
        entity.setLinkName(orderEntity.getEmployeeName());
        entity.setOrderExpiryDate(orderEntity.getGoodsDate());
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setStoreStatus(StoreStatusEnum.WAIT_STORE.getCode());
        }
        Map<Long, BigDecimal> receiveNumsSumMap = orderEntity.getPurchaseOrderDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, PurchaseOrderDetailEntity::getReceiveNum));
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        for (MaterialDeliveryDetailEntity deliveryDetailEntity : entity.getMaterialDeliveryDetailList()) {
            BigDecimal shippedNumSum;
            Long orderDetailId = deliveryDetailEntity.getOrderDetailId();
            BigDecimal receiveNumsSum = receiveNumsSumMap.get(orderDetailId);
            BigDecimal notShippedNumSum = receiveNumsSum.subtract(shippedNumSum = ComputeUtil.nullToZero((BigDecimal)map.get(orderDetailId)).add(deliveryDetailEntity.getDeliveryNum()));
            if (notShippedNumSum.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException("\u5df2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u63a5\u6536\u6570\u91cf\uff01");
            }
            deliveryDetailEntity.setReceiveNumsSum(receiveNumsSum);
            deliveryDetailEntity.setShippedNumSum(shippedNumSum);
            deliveryDetailEntity.setNotShippedNumSum(notShippedNumSum);
        }
        super.saveOrUpdate((Object)entity, false);
        return (MaterialDeliveryVO)BeanMapper.map((Object)((Object)entity), MaterialDeliveryVO.class);
    }

    @Override
    public Boolean updateDeliverState(MaterialDeliveryVO saveOrUpdateVO) {
        this.logger.info("\u8fdb\u5165\u9001\u8d27\u5355\u53d8\u66f4\u72b6\u6001\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        if (null == saveOrUpdateVO.getSourceId()) {
            throw new BusinessException("\u9001\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        MaterialDeliveryEntity entity = (MaterialDeliveryEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getSourceId()));
        if (null == entity) {
            throw new BusinessException("\u9001\u8d27\u5355\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        if (saveOrUpdateVO.getCheckStatus() == null && saveOrUpdateVO.getCloseFlag() == null) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (saveOrUpdateVO.getCheckStatus() != null) {
            entity.setCheckStatus(saveOrUpdateVO.getCheckStatus());
        }
        if (saveOrUpdateVO.getCloseFlag() != null) {
            entity.setCloseFlag(saveOrUpdateVO.getCloseFlag());
        }
        boolean flag = super.saveOrUpdate((Object)entity, false);
        this.logger.info("\u9001\u8d27\u5355\u53d8\u66f4\u72b6\u6001\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    @Override
    public MaterialDeliveryVO queryInitDelivery(Long orderId) {
        PurchaseOrderEntity orderEntity = (PurchaseOrderEntity)((Object)this.orderService.selectById(orderId));
        MaterialDeliveryVO vo = (MaterialDeliveryVO)BeanMapper.map((Object)((Object)orderEntity), MaterialDeliveryVO.class);
        vo.setOrderId(orderEntity.getId());
        vo.setOrderBillCode(orderEntity.getBillCode());
        vo.setLinkId(orderEntity.getEmployeeId());
        vo.setLinkName(orderEntity.getEmployeeName());
        vo.setOrderExpiryDate(orderEntity.getGoodsDate());
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setDeliverName(null);
        vo.setDeliverPhone(null);
        vo.setArriveDate(null);
        vo.setLicensePlate(null);
        vo.setDepartmentId(null);
        vo.setDepartmentName(null);
        vo.setCloseFlag(null);
        vo.setId(null);
        vo.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        vo.setMemo(null);
        vo.setCloseFlag(CloseFlagEnum.NORMAL.getCode());
        vo.setArriveDate(new Date());
        vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        ArrayList<MaterialDeliveryDetailVO> list = new ArrayList<MaterialDeliveryDetailVO>();
        for (PurchaseOrderDetailEntity orderDetailEntity : orderEntity.getPurchaseOrderDetailList()) {
            BigDecimal notShippedNumSum = ComputeUtil.safeSub((BigDecimal)orderDetailEntity.getReceiveNum(), (BigDecimal)orderDetailEntity.getSumSendNum());
            if (!ComputeUtil.isGreaterThan((BigDecimal)notShippedNumSum, (BigDecimal)BigDecimal.ZERO)) continue;
            MaterialDeliveryDetailVO detailVO = (MaterialDeliveryDetailVO)BeanMapper.map((Object)((Object)orderDetailEntity), MaterialDeliveryDetailVO.class);
            detailVO.setOrderId(orderDetailEntity.getPid());
            detailVO.setOrderDetailId(orderDetailEntity.getId());
            detailVO.setDeliveryNum(notShippedNumSum);
            detailVO.setCheckNum(null);
            detailVO.setReceiveNumsSum(orderDetailEntity.getReceiveNum());
            detailVO.setShippedNumSum(orderDetailEntity.getSumSendNum());
            detailVO.setApplyId(orderDetailEntity.getSourceId());
            detailVO.setApplyDetailId(orderDetailEntity.getSourceDetailId());
            detailVO.setId(Long.valueOf(IdWorker.getId()));
            detailVO.setRowState("add");
            list.add(detailVO);
        }
        vo.setMaterialDeliveryDetailList(list);
        return vo;
    }

    @Override
    public Map<Long, BigDecimal> sumDeliveredGroupByDetailId(Long orderId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("eq", (Object)orderId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List deliveryList = super.queryList(queryParam);
        this.logger.info("\u5df2\u9001\u8d27\u7684\u9001\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)deliveryList));
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)deliveryList)) {
            ArrayList<Long> deliveryIdList = new ArrayList<Long>();
            for (MaterialDeliveryEntity entity : deliveryList) {
                deliveryIdList.add(entity.getId());
            }
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("deliveryId", new Parameter("in", deliveryIdList));
            List deliveryDetailList = this.deliveryDetailService.queryList(detailParam);
            for (MaterialDeliveryDetailEntity detail : deliveryDetailList) {
                Long orderDetailId = detail.getOrderDetailId();
                if (map.containsKey(orderDetailId)) {
                    BigDecimal sum = detail.getDeliveryNum().add((BigDecimal)map.get(orderDetailId));
                    map.put(orderDetailId, sum);
                    continue;
                }
                map.put(orderDetailId, detail.getDeliveryNum());
            }
        }
        return map;
    }

    @Override
    public MaterialDeliveryVO saveCommitAfter(Long id) {
        this.logger.info("\u8fdb\u5165\u63a8\u9001\u9001\u8d27\u5355\u65b9\u6cd5>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        MaterialDeliveryEntity materialDeliveryEntity = (MaterialDeliveryEntity)((Object)super.selectById((Serializable)id));
        Long orderId = materialDeliveryEntity.getOrderId();
        PurchaseOrderEntity orderEntity = (PurchaseOrderEntity)((Object)this.orderService.selectById(orderId));
        materialDeliveryEntity.setCheckStatus(DeliverCheckStateEnum.WAIT_CHECK.getCode());
        materialDeliveryEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        super.saveOrUpdate((Object)materialDeliveryEntity, false);
        Map<Long, BigDecimal> map = this.sumDeliveredGroupByDetailId(orderId);
        this.logger.info("\u5df2\u9001\u8d27\u6750\u6599\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(map));
        Integer orderDeliverState = OrderDeliverStateEnum.PART_DELIVERED.getCode();
        int fullFlag = 0;
        for (PurchaseOrderDetailEntity entity : orderEntity.getPurchaseOrderDetailList()) {
            if (BigDecimal.ZERO.compareTo(entity.getReceiveNum()) == 0) {
                ++fullFlag;
                continue;
            }
            BigDecimal delivery = map.get(entity.getId());
            if (delivery == null) continue;
            entity.setSumSendNum(delivery);
            if (delivery.compareTo(entity.getReceiveNum()) <= -1) continue;
            ++fullFlag;
        }
        if (fullFlag > 0 && fullFlag == orderEntity.getPurchaseOrderDetailList().size()) {
            orderDeliverState = OrderDeliverStateEnum.FULL_DELIVERED.getCode();
        }
        if (!orderDeliverState.equals(orderEntity.getOrderState()) && !OrderDeliverStateEnum.FULL_DELIVERED.getCode().equals(orderEntity.getOrderState())) {
            orderEntity.setOrderState(orderDeliverState);
        }
        this.orderService.saveOrUpdate((Object)orderEntity, false);
        return (MaterialDeliveryVO)BeanMapper.map((Object)((Object)materialDeliveryEntity), MaterialDeliveryVO.class);
    }

    @Override
    public void writeBack(List<InstoreMaterialVO> storeList, boolean flag) {
        if (CollectionUtils.isEmpty(storeList)) {
            return;
        }
        Map<Long, List<InstoreMaterialVO>> storeMap = storeList.stream().filter(x -> null != x.getSourceMainId()).collect(Collectors.groupingBy(InstoreMaterialVO::getSourceMainId));
        if (MapUtils.isEmpty(storeMap)) {
            return;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(storeMap.keySet())));
        List list = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        Map<Long, MaterialDeliveryEntity> map = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        List ids = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("deliveryId", new Parameter("in", ids));
        List detailList = this.deliveryDetailService.queryList(queryParam);
        Map<Long, List<MaterialDeliveryDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(MaterialDeliveryDetailEntity::getDeliveryId));
        List<Long> detailIds = detailList.stream().map(x -> x.getId()).collect(Collectors.toList());
        Map<String, Map<Long, BigDecimal>> storeNumMap = this.getInStoreNumMap(detailIds);
        for (Long id : map.keySet()) {
            MaterialDeliveryEntity entity = map.get(id);
            if (!detailMap.containsKey(id)) {
                entity.setStoreStatus(StoreStatusEnum.FULL_STORE.getCode());
                continue;
            }
            Map<Object, Object> numMap = new HashMap();
            if (storeNumMap.containsKey(String.valueOf(id))) {
                numMap = storeNumMap.get(String.valueOf(id));
            }
            Integer status = StoreStatusEnum.WAIT_STORE.getCode();
            int fullFlag = 0;
            for (MaterialDeliveryDetailEntity detail : detailMap.get(id)) {
                if (ComputeUtil.isEmpty((BigDecimal)detail.getDeliveryNum()).booleanValue()) {
                    ++fullFlag;
                    continue;
                }
                if (!numMap.containsKey(detail.getId())) continue;
                BigDecimal num = (BigDecimal)numMap.get(detail.getId());
                if (ComputeUtil.isGreaterThan((BigDecimal)num, (BigDecimal)detail.getDeliveryNum())) {
                    throw new BusinessException("\u5165\u5e93\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9001\u8d27\u6570\u91cf\uff01");
                }
                if (!ComputeUtil.isGreaterOrEqual((BigDecimal)num, (BigDecimal)detail.getDeliveryNum())) continue;
                ++fullFlag;
            }
            Integer size = detailMap.get(id).size();
            if (fullFlag > 0) {
                status = fullFlag == size ? StoreStatusEnum.FULL_STORE.getCode() : StoreStatusEnum.PART_STORE.getCode();
            }
            entity.setStoreStatus(status);
        }
        super.saveOrUpdateBatch(map.values());
    }

    @Override
    public List<MaterialDeliveryDetailVO> querySubData(IPage<MaterialDeliveryDetailEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = MaterialDeliveryServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<MaterialDeliveryDetailVO> list = ((MaterialDeliveryMapper)this.baseMapper).querySubData(pageData, wrapper);
        return list;
    }

    private Map<String, Map<Long, BigDecimal>> getInStoreNumMap(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<String, Map<Long, BigDecimal>>();
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("in", ids));
        List storeList = this.storeMaterialService.queryList(queryParam);
        if (CollectionUtils.isEmpty((Collection)storeList)) {
            return new HashMap<String, Map<Long, BigDecimal>>();
        }
        Set instoreIds = storeList.stream().map(InstoreMaterialEntity::getInstoreId).collect(Collectors.toSet());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList(instoreIds)));
        List list = this.storeService.queryList(param);
        List pid = list.stream().map(x -> x.getId()).collect(Collectors.toList());
        storeList = storeList.stream().filter(x -> pid.contains(x.getInstoreId())).collect(Collectors.toList());
        Map<String, Map<Long, BigDecimal>> result = storeList.stream().filter(x -> null != x.getSourceMainId()).collect(Collectors.groupingBy(InstoreMaterialEntity::getSourceMainId, Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber, ComputeUtil::safeAdd)));
        return result;
    }
}

