/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.delivery.bean.MaterialDeliveryEntity;
import com.ejianc.business.delivery.service.IMaterialDeliveryService;
import com.ejianc.business.delivery.vo.MaterialDeliveryVO;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.PurchaseOrderDetailEntity;
import com.ejianc.business.material.bean.PurchaseOrderEntity;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.pub.AssignState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.pub.TaskState;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseOrderDetailService;
import com.ejianc.business.material.service.IPurchaseOrderService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.IUseApplySubService;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.business.material.vo.PurchaseOrderVO;
import com.ejianc.business.material.vo.PurchaseSettlementMaterialDetailVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchaseOrder"})
public class PurchaseOrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PURCHASE_ORDER";
    @Autowired
    private IPurchaseOrderService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    IMaterialContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;
    @Autowired
    IStoreService storeService;
    @Autowired
    IInstoreService instoreService;
    @Autowired
    IInstoreMaterialService instoreMaterialService;
    @Autowired
    IUseApplyService useApplyService;
    @Autowired
    IUseApplySubService useApplySubService;
    @Autowired
    IMaterialDeliveryService deliveryService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IPurchaseOrderDetailService purchaseOrderDetailService;

    @RequestMapping(value={"/addByUseApplyAssign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> addByUseApplyAssign(@RequestBody PurchaseOrderVO purchaseOrderVO) {
        Long applyId = purchaseOrderVO.getApplyId();
        UseApplyEntity entity = (UseApplyEntity)((Object)this.useApplyService.getById(applyId));
        PurchaseOrderVO orderVO = (PurchaseOrderVO)BeanMapper.map((Object)((Object)entity), PurchaseOrderVO.class);
        orderVO.setOrderState(Integer.valueOf(0));
        orderVO.setBillDate(new Date());
        orderVO.setApplyId(applyId);
        orderVO.setId(null);
        orderVO.setBillCode(null);
        orderVO.setCreateUserCode(null);
        orderVO.setCreateTime(null);
        orderVO.setUpdateUserCode(null);
        orderVO.setUpdateTime(null);
        orderVO.setBillState(null);
        List purchaseOrderDetailList = purchaseOrderVO.getPurchaseOrderDetailList();
        PurchaseOrderDetailVO detailVO = (PurchaseOrderDetailVO)purchaseOrderDetailList.get(0);
        Long contractId = detailVO.getPurchaseContractId();
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.materialContractService.getById(contractId));
        orderVO.setContractId(contractId);
        orderVO.setContractCode(contractEntity.getCode());
        orderVO.setContractName(contractEntity.getName());
        orderVO.setPurchaseTypeId(contractEntity.getPurchaseType());
        orderVO.setPurchaseTypeName(contractEntity.getPurchaseTypeName());
        orderVO.setPurchaseMode(contractEntity.getPurchaseMode());
        orderVO.setSupplierId(contractEntity.getSupplierId());
        orderVO.setSupplierName(contractEntity.getSupplierName());
        orderVO.setTaxRate(contractEntity.getTaxRate());
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        for (PurchaseOrderDetailVO purchaseOrderDetailVO : purchaseOrderDetailList) {
            purchaseOrderDetailVO.setRowState("add");
            purchaseOrderDetailVO.setSourceId(applyId);
            purchaseOrderDetailVO.setSourceDetailId(purchaseOrderDetailVO.getId());
            purchaseOrderDetailVO.setSourceType(Integer.valueOf(2));
            totalTaxMny = com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)purchaseOrderDetailVO.getTaxMny());
        }
        orderVO.setTotalTaxMny(totalTaxMny);
        orderVO.setPurchaseOrderDetailList(purchaseOrderDetailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)orderVO);
    }

    @RequestMapping(value={"/back"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> back(@RequestBody PurchaseOrderVO purchaseOrderVO) {
        Long applyId = purchaseOrderVO.getApplyId();
        List detailList = purchaseOrderVO.getPurchaseOrderDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (PurchaseOrderDetailVO detailVO : detailList) {
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(PurchaseOrderDetailEntity::getSourceDetailId, (Object)detailVO.getId());
                int count = this.purchaseOrderDetailService.count((Wrapper)queryWrapper);
                if (count <= 0) continue;
                return CommonResponse.error((String)(detailVO.getMaterialName() + "\u3010\u7f16\u7801\uff1a" + detailVO.getMaterialCode() + "\u3011 \u5df2\u5b58\u5728\u4e0b\u6e38\u6570\u636e\u4e0d\u80fd\u9000\u56de\uff01"));
            }
            UserContext userContext = this.sessionManager.getUserContext();
            List applySubIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(BaseEntity::getId, applySubIds);
            updateWrapper.set(UseApplySubEntity::getTaskState, (Object)TaskState.\u5f85\u5206\u914d.getCode());
            updateWrapper.set(UseApplySubEntity::getReceiverId, null);
            updateWrapper.set(UseApplySubEntity::getReceiverName, null);
            updateWrapper.set(UseApplySubEntity::getReturnerId, (Object)userContext.getEmployeeId());
            updateWrapper.set(UseApplySubEntity::getReturnerName, (Object)userContext.getEmployeeName());
            boolean update = this.useApplySubService.update((Wrapper)updateWrapper);
            if (update) {
                LambdaUpdateWrapper useApplyEntityLambdaUpdateWrapper = Wrappers.lambdaUpdate();
                useApplyEntityLambdaUpdateWrapper.eq(BaseEntity::getId, (Object)applyId);
                useApplyEntityLambdaUpdateWrapper.set(UseApplyEntity::getAssignState, (Object)AssignState.\u5f85\u5206\u914d.getCode());
                this.useApplyService.update((Wrapper)useApplyEntityLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)purchaseOrderVO);
    }

    @RequestMapping(value={"/sporadicPurchase"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> sporadicPurchase(@RequestBody PurchaseOrderVO purchaseOrderVO) {
        List detailList = purchaseOrderVO.getPurchaseOrderDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (PurchaseOrderDetailVO detailVO : detailList) {
                LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(PurchaseOrderDetailEntity::getSourceDetailId, (Object)detailVO.getId());
                int count = this.purchaseOrderDetailService.count((Wrapper)queryWrapper);
                if (count <= 0) continue;
                return CommonResponse.error((String)(detailVO.getMaterialName() + "\u3010\u7f16\u7801\uff1a" + detailVO.getMaterialCode() + "\u3011 \u5df2\u5b58\u5728\u4e0b\u6e38\u6570\u636e\uff01"));
            }
            UserContext userContext = this.sessionManager.getUserContext();
            List applySubIds = detailList.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.in(BaseEntity::getId, applySubIds);
            updateWrapper.set(UseApplySubEntity::getTaskState, (Object)TaskState.\u5df2\u9000\u56de.getCode());
            updateWrapper.set(UseApplySubEntity::getReceiverId, null);
            updateWrapper.set(UseApplySubEntity::getReceiverName, null);
            updateWrapper.set(UseApplySubEntity::getReturnerId, (Object)userContext.getEmployeeId());
            updateWrapper.set(UseApplySubEntity::getReturnerName, (Object)userContext.getEmployeeName());
            this.useApplySubService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)purchaseOrderVO);
    }

    @RequestMapping(value={"/confirmOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> confirmOrder(@RequestBody PurchaseOrderVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        PurchaseOrderEntity purchaseOrderEntity = (PurchaseOrderEntity)((Object)this.service.selectById(id));
        Integer sendToSupplier = purchaseOrderEntity.getSendToSupplier();
        Integer billState = purchaseOrderEntity.getBillState();
        if (sendToSupplier != 1 || !Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()).contains(billState)) {
            throw new BusinessException("\u91c7\u8d2d\u8ba2\u5355\u534f\u540c\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0c\u786e\u8ba4\u5931\u8d25\uff01");
        }
        purchaseOrderEntity.setOrderState(1);
        List purchaseOrderDetailList = saveOrUpdateVO.getPurchaseOrderDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseOrderDetailList)) {
            List purchaseOrderDetailEntities = BeanMapper.mapList((Iterable)purchaseOrderDetailList, PurchaseOrderDetailEntity.class);
            purchaseOrderEntity.setPurchaseOrderDetailList(purchaseOrderDetailEntities);
        }
        this.service.saveOrUpdate((Object)purchaseOrderEntity, false);
        PurchaseOrderVO vo = (PurchaseOrderVO)BeanMapper.map((Object)((Object)purchaseOrderEntity), PurchaseOrderVO.class);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> saveOrUpdate(@RequestBody PurchaseOrderVO saveOrUpdateVO) {
        PurchaseOrderEntity entity = (PurchaseOrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchaseOrderEntity.class));
        List purchaseOrderDetailList = saveOrUpdateVO.getPurchaseOrderDetailList();
        if (CollectionUtils.isNotEmpty((Collection)purchaseOrderDetailList)) {
            List<Long> applySubIds = purchaseOrderDetailList.stream().filter(t2 -> t2.getSourceDetailId() != null).map(PurchaseOrderDetailVO::getSourceDetailId).distinct().collect(Collectors.toList());
            List<Long> ingoreOrderDetailIds = purchaseOrderDetailList.stream().filter(t2 -> t2.getId() != null).map(BaseVO::getId).distinct().collect(Collectors.toList());
            Map<Long, UseApplySubEntity> applySubEntityMap = this.useApplyService.getSumBookNum(applySubIds, ingoreOrderDetailIds);
            for (PurchaseOrderDetailVO purchaseOrderDetailVO : purchaseOrderDetailList) {
                BigDecimal applyNum;
                BigDecimal sumBookNum;
                Long applySubId = purchaseOrderDetailVO.getSourceDetailId();
                UseApplySubEntity applySubEntity = applySubEntityMap.get(applySubId);
                BigDecimal orderNum = purchaseOrderDetailVO.getOrderNum();
                BigDecimal sumBookNumHaveThis = ComputeUtil.safeAdd((BigDecimal)orderNum, (BigDecimal)(sumBookNum = applySubEntity.getSumBookNum()));
                BigDecimal subNum = ComputeUtil.safeSub((BigDecimal)sumBookNumHaveThis, (BigDecimal)(applyNum = applySubEntity.getApplyNum()));
                if (!ComputeUtil.isGreaterThan((BigDecimal)subNum, (BigDecimal)BigDecimal.ZERO)) continue;
                throw new BusinessException(purchaseOrderDetailVO.getMaterialName() + "\u3010\u7f16\u7801\uff1a" + purchaseOrderDetailVO.getMaterialCode() + "\u3011\u672c\u6b21\u8ba2\u5355\u6570\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)orderNum) + "\uff0c\u5df2\u4e0b\u5355\u6570\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.nullToZero((BigDecimal)sumBookNum)) + "\uff0c\u7533\u8bf7\u6570\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)applyNum) + "\uff0c\u8d85\u51fa\u6570\u91cf\uff1a" + ComputeUtil.scaleTwo((BigDecimal)subNum) + "\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            UserContext userContext = this.sessionManager.getUserContext();
            String userName = userContext.getUserName();
            entity.setName(userName + DateUtil.getCurrentDay(null) + "\u91c7\u8d2d\u8ba2\u5355");
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getContractId() != null) {
            MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)this.materialContractService.getById(entity.getContractId()));
            entity.setContractCode(contractEntity != null ? contractEntity.getCode() : null);
        }
        boolean b = this.service.saveOrUpdate((Object)entity, false);
        PurchaseOrderVO vo = (PurchaseOrderVO)BeanMapper.map((Object)((Object)entity), PurchaseOrderVO.class);
        Long applyId = vo.getApplyId();
        if (b && applyId != null) {
            this.useApplyService.updateSumBookNum(Arrays.asList(applyId));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseOrderVO> queryDetail(Long id) {
        PurchaseOrderEntity entity = (PurchaseOrderEntity)((Object)this.service.selectById(id));
        PurchaseOrderVO vo = (PurchaseOrderVO)BeanMapper.map((Object)((Object)entity), PurchaseOrderVO.class);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(MaterialDeliveryEntity::getOrderId, (Object)id);
        List deliveryEntityList = this.deliveryService.list((Wrapper)queryWrapper);
        vo.setDeliveryList(BeanMapper.mapList((Iterable)deliveryEntityList, MaterialDeliveryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseOrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchaseOrderVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote("BT202304000003", vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
            List purchaseOrderIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.in(BaseEntity::getId, purchaseOrderIds);
            queryWrapper.isNotNull(PurchaseOrderEntity::getApplyId);
            List list = this.service.list((Wrapper)queryWrapper);
            boolean b = this.service.removeByIds(purchaseOrderIds, true);
            if (b && CollectionUtils.isNotEmpty((Collection)list)) {
                List<Long> applyIds = list.stream().map(t2 -> t2.getApplyId()).collect(Collectors.toList());
                this.useApplyService.updateSumBookNum(applyIds);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchaseOrderVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("contractCode", "contractName", "projectName", "supplierName", "billCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseOrderVO.class));
        for (PurchaseOrderVO record : pageData.getRecords()) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter("eq", (Object)record.getId()));
            List<PurchaseOrderDetailVO> detailEntityList = this.service.querySubData(null, queryParam);
            if (CollectionUtils.isEmpty(detailEntityList)) {
                record.setInstoreOver(Integer.valueOf(1));
                continue;
            }
            record.setInstoreOver(Integer.valueOf(2));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("contractCode", "contractName", "projectName", "supplierName", "billCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List purchaseOrderVOS = BeanMapper.mapList((Iterable)list, PurchaseOrderVO.class);
        if (CollectionUtils.isNotEmpty((Collection)purchaseOrderVOS)) {
            purchaseOrderVOS.forEach(t2 -> t2.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t2.getBillState()).getDescription()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchaseOrderVOS);
        ExcelExport.getInstance().exportWithTrans("purchaseOrder-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseOrderVO>> refPurchaseOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseOrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/referPurchaseOrderTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referPurchaseOrderTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam String condition) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)condition) || !condition.contains("projectId") || !condition.contains("contractId")) {
            throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        JSONObject conditionJson = JSONObject.parseObject((String)condition);
        Long contractId = conditionJson.getLong("contractId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        if (null != contractId) {
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        }
        queryParam.setOrderMap(orderMap);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("brandName");
        fuzzyFields.add("name");
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List purchaseOrderEntityList = this.service.queryList(queryParam, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (PurchaseOrderEntity entity : purchaseOrderEntityList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter("eq", (Object)entity.getId()));
            List<PurchaseOrderDetailVO> purchaseOrderDetailVOList = this.service.querySubData(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(purchaseOrderDetailVOList)) continue;
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", true);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/refPurchaseOrderDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseOrderDetailVO>> refPurchaseOrderDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, @RequestParam(required=false) String condition, String relyNode, String searchText, @RequestParam(required=false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        fuzzyFields.add("brandName");
        Map param = queryParam.getParams();
        String pid = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            pid = _con.getString("pid");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            pid = relyCondition.split("=")[1];
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty(pid)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u91c7\u8d2d\u8ba2\u5355\uff01");
        }
        param.put("pid", new Parameter("eq", (Object)pid));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        Page pageData = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        List<PurchaseOrderDetailVO> list = this.service.querySubData((IPage<PurchaseOrderDetailEntity>)pageData, queryParam);
        Page voPage = null;
        if (pageData != null) {
            voPage = new Page();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f", voPage);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchaseOrder-import.xlsx", (String)"\u91c7\u8d2d\u8ba2\u5355\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        List<PurchaseOrderDetailVO> successList = new ArrayList();
        ArrayList<PurchaseOrderDetailVO> errorList = new ArrayList<PurchaseOrderDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PurchaseOrderDetailVO purchaseOrderDetailVO = new PurchaseOrderDetailVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    purchaseOrderDetailVO.setMaterialTypeName(((String)datas.get(0)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    purchaseOrderDetailVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    purchaseOrderDetailVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    purchaseOrderDetailVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    purchaseOrderDetailVO.setModel(((String)datas.get(2)).trim());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3)))) {
                    purchaseOrderDetailVO.setUnit(((String)datas.get(3)).trim());
                }
                purchaseOrderDetailVO.setBrandName((String)datas.get(4));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        purchaseOrderDetailVO.setOrderNum(new BigDecimal((String)datas.get(5)));
                        if (purchaseOrderDetailVO.getOrderNum().longValue() < 0L) {
                            purchaseOrderDetailVO.setErrorMessage("\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        purchaseOrderDetailVO.setPrice(new BigDecimal((String)datas.get(6)));
                        if (purchaseOrderDetailVO.getPrice().doubleValue() < 0.0) {
                            purchaseOrderDetailVO.setErrorMessage("\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    purchaseOrderDetailVO.setPrice(new BigDecimal(0));
                }
                purchaseOrderDetailVO.setTaxMny(MathUtil.safeMultiply((BigDecimal)purchaseOrderDetailVO.getOrderNum(), (BigDecimal)purchaseOrderDetailVO.getPrice()));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) && ((String)datas.get(7)).length() > 64) {
                    purchaseOrderDetailVO.setErrorMessage("\u7269\u6599\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    purchaseOrderDetailVO.setMaterialCode((String)datas.get(7));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) && ((String)datas.get(8)).length() > 50) {
                    purchaseOrderDetailVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    purchaseOrderDetailVO.setMemo((String)datas.get(8));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)purchaseOrderDetailVO.getErrorMessage())) {
                    errorList.add(purchaseOrderDetailVO);
                    continue;
                }
                String onlykey = purchaseOrderDetailVO.getMaterialTypeName() + purchaseOrderDetailVO.getMaterialName() + purchaseOrderDetailVO.getUnit() + purchaseOrderDetailVO.getModel();
                purchaseOrderDetailVO.setOnlyKey(onlykey);
                successList.add(purchaseOrderDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            JSONObject match = this.archivesUtil.findMatch(successList, "materialTypeId", "materialId", "materialTypeName", "materialName", "materialCode", "unit", "model", "errorMessage");
            successList = (List)match.get((Object)"sourceList");
            List errorList1 = (List)match.get((Object)"errorList");
            errorList.addAll(errorList1);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PurchaseOrderVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @GetMapping(value={"/getInstoreDataByPurchaseOrder"})
    @ResponseBody
    public CommonResponse<InstoreVO> getInstoreDataByPurchaseOrder(@RequestParam String purchaseOrderIds, @RequestParam Integer instoreType) {
        StoreVO storeVO;
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseOrderIds)) {
            this.logger.info("======com.ejianc.business.material.controller.PurchaseOrderController.getInstoreDataByPurchaseOrder[purchaseOrderIds:{}]", (Object)purchaseOrderIds);
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u91c7\u8d2d\u8ba2\u5355\u6570\u636e!");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        String[] orderIds = purchaseOrderIds.split(",");
        List orderIdList = Arrays.stream(orderIds).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        PurchaseOrderEntity order = (PurchaseOrderEntity)((Object)this.service.getById((Serializable)orderIdList.get(0)));
        InstoreVO vo = new InstoreVO();
        ArrayList<InstoreMaterialVO> instoreMaterialList = new ArrayList<InstoreMaterialVO>();
        Date curDate = new Date();
        Long contractId = order.getContractId();
        Long orgId = order.getOrgId();
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.contractService.getById(contractId));
        if (contract != null) {
            vo.setTaxRate(ComputeUtil.toBigDecimal((Double)contract.getTaxRate()));
            vo.setProjectCode(contract.getProjectCode());
            vo.setContractPurchaseMode(contract.getPurchaseMode());
        }
        if ((storeVO = this.storeService.queryNewestStoreByOrgId(orgId)) != null) {
            vo.setStoreId(storeVO.getId());
            vo.setStoreName(storeVO.getName());
        }
        vo.setOrgId(order.getOrgId());
        vo.setOrgName(order.getOrgName());
        vo.setContractId(contractId);
        vo.setContractName(order.getContractName());
        vo.setProjectId(order.getProjectId());
        vo.setProjectName(order.getProjectName());
        vo.setProjectFlag("1");
        vo.setSupplierId(order.getSupplierId());
        vo.setSupplierName(order.getSupplierName());
        vo.setInstoreDate(curDate);
        vo.setInstoreType(instoreType);
        vo.setContractType("hasContract");
        vo.setEmployeeId(userContext.getEmployeeId());
        vo.setEmployeeName(userContext.getEmployeeName());
        vo.setInstoreMaterialList(instoreMaterialList);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("in", orderIdList));
        List<PurchaseOrderDetailVO> detailEntityList = this.service.querySubData(null, queryParam);
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return CommonResponse.success((String)"\u8fd9\u4e9b\u91c7\u8d2d\u8ba2\u5355\u7684\u7269\u8d44\u5df2\u5168\u90e8\u5165\u5e93!", (Object)vo);
        }
        for (PurchaseOrderDetailVO detail : detailEntityList) {
            InstoreMaterialVO instoreMaterialVO = new InstoreMaterialVO();
            instoreMaterialVO.setMaterialCategoryId(detail.getMaterialTypeId());
            instoreMaterialVO.setMaterialCategoryName(detail.getMaterialTypeName());
            instoreMaterialVO.setMaterialId(detail.getMaterialId());
            instoreMaterialVO.setMaterialName(detail.getMaterialName());
            instoreMaterialVO.setMaterialCode(detail.getMaterialCode());
            instoreMaterialVO.setMaterialSpec(detail.getModel());
            instoreMaterialVO.setMaterialUnit(detail.getUnit());
            instoreMaterialVO.setBrandId(detail.getBrandId());
            instoreMaterialVO.setBrandName(detail.getBrandName());
            instoreMaterialVO.setUnitPrice(detail.getPrice());
            instoreMaterialVO.setInstoreNumber(detail.getSurplusNum());
            instoreMaterialVO.setAmount(ComputeUtil.safeMultiply((BigDecimal)detail.getSurplusNum(), (BigDecimal)detail.getPrice()));
            instoreMaterialVO.setSourceType("purchaseOrder");
            instoreMaterialVO.setSourceId(detail.getId());
            instoreMaterialVO.setSourceMainId(detail.getPid());
            instoreMaterialVO.setRowState("add");
            instoreMaterialVO.setId(detail.getId());
            instoreMaterialList.add(instoreMaterialVO);
        }
        return CommonResponse.success((Object)vo);
    }

    @GetMapping(value={"/getSettleDataByPurchaseOrder"})
    @ResponseBody
    public CommonResponse<PurchaseSettlementVO> getSettleDataByPurchaseOrder(@RequestParam String purchaseOrderIds) {
        PurchaseSettlementVO vo = new PurchaseSettlementVO();
        if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)purchaseOrderIds)) {
            this.logger.info("======com.ejianc.business.material.controller.PurchaseOrderController.getSettleDataByPurchaseOrder[purchaseOrderIds:{}]", (Object)purchaseOrderIds);
            return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u91c7\u8d2d\u8ba2\u5355\u6570\u636e!");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        String[] orderIds = purchaseOrderIds.split(",");
        List<Long> orderIdList = Arrays.stream(orderIds).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        PurchaseOrderEntity order = (PurchaseOrderEntity)((Object)this.service.getById((Serializable)orderIdList.get(0)));
        List<InstoreMaterialVO> instoreMaterialVOList = this.service.getInstoreMaterialByPurchaseOrder(orderIdList);
        ArrayList<PurchaseSettlementMaterialDetailVO> detailVOS = new ArrayList<PurchaseSettlementMaterialDetailVO>();
        for (InstoreMaterialVO s2 : instoreMaterialVOList) {
            PurchaseSettlementMaterialDetailVO d = new PurchaseSettlementMaterialDetailVO();
            d.setId(s2.getId());
            d.setRowState("add");
            d.setSourceType("2");
            d.setSourceTypeName(DateUtil.format((Date)s2.getInstoreDate(), (String)"yyyy-MM-dd") + MaterialStoreType.getStoreTypeNameByCode((Integer)s2.getInstoreType()) + s2.getBillCode());
            d.setMaterialTypeId(s2.getMaterialCategoryId());
            d.setMaterialTypeName(s2.getMaterialCategoryName());
            d.setMaterialId(s2.getMaterialId());
            d.setMaterialName(s2.getMaterialName());
            d.setMaterialCode(s2.getMaterialCode());
            d.setMaterialInfo(Optional.ofNullable(s2.getMaterialInfo()).orElse(s2.getMaterialName()));
            d.setModel(s2.getMaterialSpec());
            d.setUnit(s2.getMaterialUnit());
            d.setBrandName(s2.getBrandName());
            d.setBrandId(s2.getBrandId());
            d.setNum(s2.getInstoreNumber());
            d.setPrice(s2.getUnitPrice());
            d.setMoney(s2.getAmount());
            d.setSourceMainId(s2.getInstoreId());
            d.setSourceSubId(s2.getId());
            detailVOS.add(d);
        }
        Long contractId = order.getContractId();
        Long orgId = order.getOrgId();
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.contractService.getById(contractId));
        if (contract != null) {
            vo.setTaxRate(ComputeUtil.toBigDecimal((Double)contract.getTaxRate()));
            vo.setProjectCode(contract.getProjectCode());
            vo.setPurchaseMethod(contract.getPurchaseModeName());
            vo.setContractAmount(contract.getAmountWithTax());
        }
        vo.setOrgId(order.getOrgId());
        vo.setOrgName(order.getOrgName());
        vo.setContractId(contractId);
        vo.setContractName(order.getContractName());
        vo.setProjectId(order.getProjectId());
        vo.setProjectName(order.getProjectName());
        vo.setSupplierId(order.getSupplierId());
        vo.setSupplierName(order.getSupplierName());
        vo.setBelongToProject("1");
        vo.setSettlementDate(new Date());
        vo.setSettleType("0");
        vo.setEmployeeId(userContext.getEmployeeId());
        vo.setEmployeeName(userContext.getEmployeeName());
        vo.setMaterialDetails(detailVOS);
        return CommonResponse.success((Object)((Object)vo));
    }
}

