/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICtrlSetApi;
import com.ejianc.business.cost.vo.CtrlSetDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.impl.InstoreMaterialService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialApplyCountVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PurchaseOrderDetailVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.material.vo.UseApplyVO;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UseApplyService
extends BaseServiceImpl<UseApplyMapper, UseApplyEntity>
implements IUseApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    public IOutStoreSubService outStoreSubService;
    @Autowired
    public IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;
    @Autowired
    private InstoreMaterialService instoreMaterialService;
    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";
    private static String PARAM_PLAN_PRICE = "P-649dG759";
    private static String PARAM_PROJECT_MNY = "P-w112KG65";
    private static String PARAM_COST_MNY = "P-AQ725A75";
    private static String PARAM_BATCH_PLAN_NUM = "P-q4fR4e66";
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private ICtrlSetApi ctrlSetApi;

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, String billType, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(billType)) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(billType)) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        try {
            Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
            String[] paramsArray = new String[]{"none", "warn", "alert"};
            HashMap paramsCheckVOMap = new HashMap();
            paramsCheckVOMap.put("alert", new ArrayList());
            paramsCheckVOMap.put("warn", new ArrayList());
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            paramsCheckVO.setWarnType(paramsArray[0]);
            List<UseApplySubVO> subVOList = vo.getUseApplySubEntities();
            QueryWrapper appWrapper = new QueryWrapper();
            appWrapper.eq((Object)"project_id", (Object)vo.getProjectId());
            appWrapper.eq((Object)"dr", (Object)0);
            List useApplyEntities = this.useApplyMapper.selectList((Wrapper)appWrapper);
            List pids = useApplyEntities.stream().map(e -> e.getId()).collect(Collectors.toList());
            ArrayList noIds = new ArrayList();
            vo.getUseApplySubEntities().forEach(item -> {
                if (item.getId() != null) {
                    noIds.add(item.getId());
                }
            });
            pids.add(1L);
            QueryWrapper appSubWrapper = new QueryWrapper();
            appSubWrapper.in((Object)"pid", pids);
            appSubWrapper.notIn((Object)"id", noIds);
            appSubWrapper.eq((Object)"dr", (Object)0);
            appSubWrapper.ne((Object)"task_state", (Object)"back");
            List oldEntities = this.useApplySubMapper.selectList((Wrapper)appSubWrapper);
            List<UseApplySubEntity> savedEntities = BeanMapper.mapList(subVOList, UseApplySubEntity.class);
            HashMap<Long, UseApplySubEntity> thisMap = new HashMap<Long, UseApplySubEntity>();
            savedEntities.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    UseApplySubEntity useApplySubEntity = (UseApplySubEntity)((Object)((Object)thisMap.get(item.getMaterialId())));
                    useApplySubEntity.setApplyNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)useApplySubEntity.getApplyNum(), (BigDecimal)item.getApplyNum())));
                } else {
                    thisMap.put(item.getMaterialId(), (UseApplySubEntity)((Object)item));
                }
            });
            HashMap oldAppMap = new HashMap();
            oldEntities.forEach(item -> {
                BigDecimal applyNum = item.getApplyNum();
                if (oldAppMap.containsKey(item.getMaterialId())) {
                    BigDecimal bigDecimal = (BigDecimal)oldAppMap.get(item.getMaterialId());
                    oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)applyNum, (BigDecimal)bigDecimal)));
                } else {
                    oldAppMap.put(item.getMaterialId(), applyNum);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)savedEntities) && (int)savedEntities.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
                BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO;
                Map detailProMap;
                CommonResponse response1;
                savedEntities = savedEntities.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u3010\u603b\u8ba1\u5212\u3011\u63a7\u5236\u3010\u9879\u76ee\u7528\u6599\u7533\u8bf7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                    Long projectId = vo.getProjectId();
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"project_id", (Object)projectId);
                    wrapper.eq((Object)"dr", (Object)0);
                    List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                    QueryWrapper planSubWrapper = new QueryWrapper();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    materialMasterPlanEntities.forEach(item -> ids.add(item.getId()));
                    ids.add(1L);
                    planSubWrapper.in((Object)"material_master_plan_id", ids);
                    planSubWrapper.eq((Object)"dr", (Object)0);
                    List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                    HashMap planMap = new HashMap();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.get(item.getMaterialId()) != null) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)BigDecimal.valueOf(num), (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId()))));
                        } else {
                            planMap.put(item.getMaterialId(), ComputeUtil.toBigDecimal((Double)num));
                        }
                    });
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal manageRate = billParamVO.getRoleValue();
                        thisMap.forEach((k, item) -> {
                            BigDecimal appNumber;
                            Long materialId = item.getMaterialId();
                            BigDecimal applyNum = item.getApplyNum();
                            BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(materialId);
                            BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : (BigDecimal)planMap.get(materialId);
                            BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100L));
                            if (planNumber.compareTo(appNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldApplyNum, (BigDecimal)applyNum))) == -1) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u7533\u8bf7\u6570\u91cf\u8d85\u51fa\u603b\u8ba1\u5212*\u6bd4\u4f8b");
                                paramsCheckDsVO.setContent("\u672c\u6b21\u7533\u8bf7\u6570\u91cf:" + applyNum.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u7d2f\u8ba1\u5df2\u7533\u8bf7\u6570\u91cf" + oldApplyNum.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u603b\u8ba1\u5212\u6570\u91cf" + planNum.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u603b\u8ba1\u5212\u6570\u91cf\u6bd4\u4f8b" + manageRate.setScale(8, 4).stripTrailingZeros().toPlainString() + "%,\u8d85\u989d" + appNumber.subtract(planNumber).setScale(4, 4).stripTrailingZeros().toPlainString());
                                UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, paramsArray[billParamVO.getControlType()], paramsCheckDsVO);
                            }
                        });
                    }
                }
                if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId)).isSuccess()) {
                    throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u5355\u4ef7\u3011\u63a7\u5236\u3010\u7528\u6599\u7533\u8bf7\u5355\u4ef7\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response1.getMsg());
                }
                List billParamVOS1 = (List)response1.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                    Long projectId = vo.getProjectId();
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.eq((Object)"project_id", (Object)projectId);
                    List materialMasterPlanEntities = this.materialMasterPlanMapper.selectList((Wrapper)wrapper);
                    HashMap planMap = new HashMap();
                    if (CollectionUtils.isNotEmpty((Collection)materialMasterPlanEntities)) {
                        List planIds = materialMasterPlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                        QueryWrapper planSubWrapper = new QueryWrapper();
                        planSubWrapper.in((Object)"material_master_plan_id", (Collection)planIds);
                        List materialMasterPlanSubEntities = this.materialMasterPlanSubMapper.selectList((Wrapper)planSubWrapper);
                        materialMasterPlanSubEntities.forEach(item -> {
                            BigDecimal price = item.getPrice();
                            Long materialId = item.getMaterialId();
                            if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan((BigDecimal)price, (BigDecimal)((BigDecimal)planMap.get(item.getMaterialId())))) {
                                planMap.put(materialId, price);
                            }
                        });
                    }
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        savedEntities.forEach(item -> {
                            BigDecimal price;
                            BigDecimal _planPrice;
                            Long materialId = item.getMaterialId();
                            BigDecimal estimatePrice = item.getEstimatePrice();
                            if (ComputeUtil.isGreaterThan((BigDecimal)estimatePrice, (BigDecimal)(_planPrice = (price = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(materialId)))).multiply(divide)))) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7528\u6599\u7533\u8bf7\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                                paramsCheckDsVO.setContent("\u672c\u6b21\u7528\u6599\u7533\u8bf7\u5355\u4ef7\uff1a" + estimatePrice.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u603b\u8ba1\u5212\u5355\u4ef7*" + roleValue.setScale(8, 4).stripTrailingZeros().toPlainString() + "%:" + _planPrice.setScale(4, 4).stripTrailingZeros().toPlainString() + ",\u8d85\u51fa\u5355\u4ef7" + estimatePrice.subtract(_planPrice).setScale(4, 4).stripTrailingZeros().toPlainString());
                                UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, paramsArray[billParamVO.getControlType()], paramsCheckDsVO);
                            }
                        });
                    }
                }
                List subIds = savedEntities.stream().map(UseApplySubEntity::getMaterialId).collect(Collectors.toList());
                BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
                paramControlVO1.setProjectId(vo.getProjectId());
                paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO1.setIds(subIds);
                this.logger.info("\u53c2\u6570\uff1a", (Object)JSONObject.toJSONString((Object)paramControlVO1));
                CommonResponse res1 = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
                if (!res1.isSuccess()) {
                    throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg());
                }
                if (null != res1.getData() && !(detailProMap = (proQuantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res1.getData()).getDetailProMap()).isEmpty()) {
                    List categoryIds = savedEntities.stream().map(e -> e.getMaterialTypeId()).distinct().collect(Collectors.toList());
                    CommonResponse listCommonResponse = this.ctrlSetApi.querySetDetailByCategory(categoryIds);
                    if (!listCommonResponse.isSuccess()) {
                        throw new BusinessException("\u67e5\u8be2\u7269\u6599\u7ba1\u63a7\u8bbe\u7f6e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + listCommonResponse.getMsg());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                        List data = (List)listCommonResponse.getData();
                        Map<Long, List<CtrlSetDetailVO>> controlMap = data.stream().collect(Collectors.groupingBy(e -> e.getSetId()));
                        thisMap.forEach((k, item) -> {
                            if (detailProMap.containsKey(item.getMaterialId()) && controlMap.containsKey(item.getMaterialTypeId())) {
                                BudgetProjectDetailProVO budgetProjectDetailProVO = (BudgetProjectDetailProVO)detailProMap.get(item.getMaterialId());
                                BigDecimal costNum = budgetProjectDetailProVO.getNum();
                                List ctrlSetDetailVO = (List)controlMap.get(item.getMaterialTypeId());
                                BigDecimal applyNum = item.getApplyNum();
                                BigDecimal oldApplyNum = oldAppMap.get(item.getMaterialId()) == null ? BigDecimal.ZERO : (BigDecimal)oldAppMap.get(item.getMaterialId());
                                BigDecimal appNumber = ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)oldApplyNum, (BigDecimal)applyNum));
                                for (CtrlSetDetailVO setDetail : ctrlSetDetailVO) {
                                    if (setDetail.getControlType() != 1) continue;
                                    BigDecimal cost = ComputeUtil.safeMultiply((BigDecimal)costNum, (BigDecimal)setDetail.getControlScale());
                                    if (!ComputeUtil.isGreaterThan((BigDecimal)appNumber, (BigDecimal)(cost = ComputeUtil.safeDiv((BigDecimal)cost, (BigDecimal)new BigDecimal("100"))))) continue;
                                    BigDecimal exceed = ComputeUtil.safeSub((BigDecimal)appNumber, (BigDecimal)cost);
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(item.getMaterialId(), "num");
                                    paramsCheckDsVO.setOrgName("\u534e\u5eb7");
                                    paramsCheckDsVO.setWarnItem(item.getMaterialName() + "-" + item.getModel() + "\u7533\u8bf7\u91cf\u8d85\u989d\u9884\u8b66");
                                    paramsCheckDsVO.setWarnName("\u6750\u6599\u7528\u6599\u7533\u8bf7\u91cf\u8d85\u76ee\u6807\u6210\u672c\u91cf");
                                    String text = "\u8d85\u51fa\u6570\u91cf=" + appNumber.setScale(2, RoundingMode.HALF_UP) + "-" + costNum.setScale(2, RoundingMode.HALF_UP) + "*" + setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP) + "% =" + exceed.setScale(2, RoundingMode.HALF_UP) + item.getUnit() + "\u3002";
                                    String redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("\u7528\u6599\u7533\u8bf7\u603b\u91cf\uff1a").append(appNumber.setScale(2, RoundingMode.HALF_UP)).append(item.getUnit()).append("\uff0c\u76ee\u6807\u6210\u672c\u91cf\uff1a").append(costNum.setScale(2, RoundingMode.HALF_UP)).append(item.getUnit()).append("\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)).append("%\uff1a").append(redText);
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    UseApplyService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod() == 1 ? "warn" : "alert", paramsCheckDsVO);
                                }
                            }
                        });
                    }
                }
            }
            ParamsCheckVO pc = new ParamsCheckVO();
            if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
                pc.setWarnType("alert");
                pc.setDataSource((List)paramsCheckVOMap.get("alert"));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
                pc.setWarnType("warn");
                pc.setDataSource((List)paramsCheckVOMap.get("warn"));
            } else {
                pc.setWarnType("none");
                pc.setDataSource(null);
            }
            return pc;
        }
        catch (NullPointerException e2) {
            System.out.println("\u7a7a\u6307\u9488\u5f02\u5e38\u53d1\u751f\uff1a" + e2.getMessage());
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public void setIsExceed(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null && !"del".equals(s.getRowState())).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
        HashMap numMap = new HashMap();
        listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
        ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
            Map<Long, BigDecimal> applyedMap = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> k.getMaterialId(), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            List<MaterialMasterPlanSubVO> masterPlanSubVOS = this.materialMasterPlanSubMapper.queryMasterPlanSubNum(queryParam);
            Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));
            for (Map.Entry entry : numMap.entrySet()) {
                Long materialId = (Long)entry.getKey();
                BigDecimal applyedHaveThis = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)entry.getValue()), (BigDecimal)applyedMap.get(materialId));
                if (!ComputeUtil.isGreaterThan((BigDecimal)applyedHaveThis, (BigDecimal)ComputeUtil.toBigDecimal((Double)masterPlanMap.get(materialId)))) continue;
                vo.setIsExceed(1);
                break;
            }
        }
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            HashMap numMap = new HashMap();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            ArrayList<Long> materialIds = new ArrayList<Long>(listMap.keySet());
            if (CollectionUtils.isEmpty(materialIds)) {
                return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
            }
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = ((UseApplyMapper)this.baseMapper).countApplyNumCommon(queryParam);
            Long orgId = vo.getOrgId();
            List<InstoreMaterialVO> instoreMaterialVOList = null;
            if (orgId != null) {
                instoreMaterialVOList = this.instoreMaterialService.storeNumCount(orgId, materialIds);
            }
            List<MaterialMasterPlanSubVO> masterPlanSubVOS = this.materialMasterPlanSubMapper.queryMasterPlanSubNum(queryParam);
            Map<String, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> String.valueOf(k.getMaterialId()), k -> k.getNum()));
            Map<Object, Object> storeNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(instoreMaterialVOList)) {
                storeNumMap = instoreMaterialVOList.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, InstoreMaterialVO::getStoreNum, ComputeUtil::safeAdd)));
            }
            Map<String, BigDecimal> level3Map = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            Map<Object, Object> sumAppluNumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                sumAppluNumMap = useApplySubEntities.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            }
            for (UseApplySubVO d : useApplySubEntities) {
                BigDecimal thisAddApplyed;
                String materialId = String.valueOf(d.getMaterialId());
                if (materialId == null) continue;
                BigDecimal applyed = level3Map.get(materialId);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("projectId", vo.getProjectId());
                param.put("materialId", d.getMaterialId());
                List<OutStoreSubVO> outStoreSubVOS = this.outStoreSubService.queryReturnGoodsMaterialNum(param);
                Map<String, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, OutStoreSubVO::getOutStoreNumber, ComputeUtil::safeAdd)));
                BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                BigDecimal storeNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)storeNumMap.get(materialId)));
                storeNum = BigDecimalUtils.safeSub((BigDecimal)storeNum, (BigDecimal)returnGoodsNum);
                if (ComputeUtil.isLessThan((BigDecimal)applyed, (BigDecimal)BigDecimal.ZERO)) {
                    applyed = BigDecimal.ZERO;
                }
                if ((thisAddApplyed = ComputeUtil.safeAdd((BigDecimal)applyed, (BigDecimal)((BigDecimal)sumAppluNumMap.get(materialId)))).compareTo(BigDecimal.ZERO) < 0) {
                    thisAddApplyed = new BigDecimal(0);
                }
                Double masterPlanNum = masterPlanMap.get(materialId);
                d.setOrderNum(ComputeUtil.nullToZero((BigDecimal)thisAddApplyed));
                d.setSumApplyNum(ComputeUtil.nullToZero((BigDecimal)applyed));
                d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                d.setStoreNum(storeNum);
                d.setIsFinish(0);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u7d2f\u8ba1\u91cf,\u8fdb\u5ea6\u91cf,\u603b\u91cf\u6210\u529f!", (Object)((Object)vo));
    }

    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return ((UseApplyMapper)this.baseMapper).materialFinishCount(queryParam);
    }

    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return ((UseApplyMapper)this.baseMapper).queryMaterialApplyCount(projectId, materialIds);
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyData(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubList(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForPurchaseOrder(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForPurchaseOrder(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryApplySubListForInstore(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = UseApplyService.changeToQueryWrapper((QueryParam)queryParam);
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).queryAllApplyDataForInstore(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public void updatePurchaseFlag(Long id, Integer purchaseFlag) {
        if (id != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(UseApplyEntity::getPurchaseFlag, (Object)purchaseFlag);
            super.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void updateSumBookNum(List<Long> applyIds) {
        ((UseApplyMapper)this.baseMapper).updateSumBookNum(applyIds);
    }

    @Override
    public void updateSumCheckNum(Long applyId) {
        ((UseApplyMapper)this.baseMapper).updateSumCheckNum(applyId);
    }

    @Override
    public List<UseApplyVO> queryOrderIssuanceList(IPage<UseApplyVO> pageData, QueryWrapper wrapper, Long employeeId, Long purchaseManagerId) {
        return ((UseApplyMapper)this.baseMapper).queryOrderIssuanceList(pageData, wrapper, employeeId, purchaseManagerId);
    }

    @Override
    public List<PurchaseOrderDetailVO> queryAssignDetail(Long applyDetailId) {
        return this.useApplyMapper.getPurchaseOrderDetail(applyDetailId);
    }

    @Override
    public List<InstoreMaterialVO> queryInstoreMaterial(Long applyDetailId, Long purchaseOrderDetailId) {
        return this.useApplyMapper.getInstoreMaterial(applyDetailId, purchaseOrderDetailId);
    }

    @Override
    public Map<Long, UseApplySubEntity> getSumBookNum(List<Long> applySubIds, List<Long> ingoreOrderDetailIds) {
        Map<Long, UseApplySubEntity> applySubEntityMap = new HashMap<Long, UseApplySubEntity>();
        List<UseApplySubEntity> list = ((UseApplyMapper)this.baseMapper).getSumBookNum(applySubIds, ingoreOrderDetailIds);
        if (CollectionUtils.isNotEmpty(list)) {
            applySubEntityMap = list.stream().collect(Collectors.toMap(BaseEntity::getId, e -> e));
        }
        return applySubEntityMap;
    }
}

