/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.plan.bean.BatchPlanEntity;
import com.ejianc.business.plan.bean.BatchPlanSubEntity;
import com.ejianc.business.plan.service.IBatchPlanService;
import com.ejianc.business.plan.service.IBatchPlanSubService;
import com.ejianc.business.plan.vo.BatchPlanSubVO;
import com.ejianc.business.plan.vo.BatchPlanVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"batchPlan"})
public class BatchPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBatchPlanSubService batchPlanSubService;
    private static final String BILL_CODE = "BATCH_PLAN";
    @Autowired
    private IBatchPlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BatchPlanVO> saveOrUpdate(@RequestBody BatchPlanVO saveOrUpdateVO) {
        List batchPlanSubVOList;
        BatchPlanEntity entity = (BatchPlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BatchPlanEntity.class));
        UserContext userContext = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isNotBlank((CharSequence)saveOrUpdateVO.getBillCode())) {
                BatchPlanVO voByCode = this.service.queryByCode(saveOrUpdateVO.getBillCode());
                if (!(null == voByCode || null != saveOrUpdateVO.getId() && voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
                }
            } else {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity.setCreateUserName(userContext.getUserName());
        } else {
            entity.setModifyUserName(userContext.getUserName());
        }
        long id = IdWorker.getId();
        if (entity.getId() == null) {
            entity.setId(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(batchPlanSubVOList = saveOrUpdateVO.getBatchPlanSubList()))) {
            for (BatchPlanSubVO batchPlanSubVO : batchPlanSubVOList) {
                String onlykey = batchPlanSubVO.getMaterialCategoryName() + batchPlanSubVO.getMaterialName() + batchPlanSubVO.getUnit() + batchPlanSubVO.getSpec() + batchPlanSubVO.getMaterialCode();
                batchPlanSubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, entity.getId(), entity.getBillCode(), entity.getProjectName(), "\u7269\u8d44\u6279\u6b21\u8ba1\u5212");
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(archiveVO, batchPlanSubVOList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSON.parseArray((String)sourceList, BatchPlanSubVO.class);
            List batchPlanSubEntities = BeanMapper.mapList((Iterable)list, BatchPlanSubEntity.class);
            entity.setBatchPlanSubList(batchPlanSubEntities);
        }
        this.service.saveOrUpdate((Object)entity, false);
        BatchPlanVO vo = (BatchPlanVO)BeanMapper.map((Object)((Object)entity), BatchPlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkAllParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody BatchPlanVO vo) {
        ParamsCheckVO paramsCheckVO = this.service.checkAllParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BatchPlanVO> queryDetail(Long id) {
        BatchPlanEntity entity = (BatchPlanEntity)((Object)this.service.selectById(id));
        BatchPlanVO vo = (BatchPlanVO)BeanMapper.map((Object)((Object)entity), BatchPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatchPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BatchPlanVO batchPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BatchPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BatchPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @GetMapping(value={"projectPlanCheck"})
    @ResponseBody
    public CommonResponse<String> projectPlanCheck(@RequestParam(value="projectId") Long projectId, @RequestParam(value="billId", required=false) Long billId) {
        QueryWrapper query = new QueryWrapper();
        if (billId != null) {
            query.notIn((Object)"id", new Object[]{billId});
        }
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityByProjects = this.service.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)entityByProjects)) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u7269\u8d44\u6279\u6b21\u8ba1\u5212\uff01");
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u9002\u7528\u5f53\u524d\u6279\u6b21\u8ba1\u5212\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(item -> {
            BatchPlanVO vo = (BatchPlanVO)BeanMapper.map((Object)item, BatchPlanVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(vo);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("batchPlanExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBatchPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BatchPlanSubVO>> refBatchPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Page resp = new Page();
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getOrderMap().put("id", "asc");
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570\u4e2d\u7f3a\u5c11condition\uff01");
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        if (null == conditionMap.get("projectId")) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u53c2\u6570condition\u4e2d\u7f3a\u5c11\u9879projectId\uff01");
        }
        ArrayList<Integer> approvedBillState = new ArrayList<Integer>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", conditionMap.get("projectId"));
        approvedBillState.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        approvedBillState.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryWrapper.in((Object)"bill_state", approvedBillState);
        List entitys = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)entitys)) {
            resp.setTotal(0L);
            resp.setSize((long)pageSize.intValue());
            resp.setCurrent((long)pageNumber.intValue());
            resp.setRecords(new ArrayList());
            resp.setPages(0L);
        } else {
            Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.eq((Object)"project_id", conditionMap.get("projectId"));
            wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            wrapper.groupBy(new Object[]{"material_id", "part_name"});
            wrapper.having("(count + applyNum) < num ", new Object[0]);
            List<BatchPlanSubVO> list = this.batchPlanSubService.queryPlanSubList((Page<BatchPlanSubVO>)page, wrapper);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(list);
            resp.setPages(pageData.getPages());
            resp.setCurrent(pageData.getCurrent());
            resp.setTotal(pageData.getTotal());
            resp.setSize(pageData.getSize());
            List dataList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
                dataList = BeanMapper.mapList((Iterable)pageData.getRecords(), BatchPlanSubVO.class);
                for (BatchPlanSubVO vo : dataList) {
                    BigDecimal num_temp = ComputeUtil.safeSub((BigDecimal)vo.getNum(), (BigDecimal)vo.getApplyNum());
                    BigDecimal surplusNum = ComputeUtil.safeSub((BigDecimal)num_temp, (BigDecimal)vo.getCount());
                    vo.setSurplusNum(surplusNum);
                }
            }
            resp.setRecords(dataList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"batch-plan-material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        List<BatchPlanSubVO> successList = new ArrayList();
        ArrayList<BatchPlanSubVO> errorList = new ArrayList<BatchPlanSubVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                BatchPlanSubVO batchPlanSubVO = new BatchPlanSubVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    batchPlanSubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String materialCategoryName = ((String)datas.get(0)).toString().trim();
                    batchPlanSubVO.setMaterialCategoryName(materialCategoryName);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    batchPlanSubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 30) {
                    batchPlanSubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~30\u5b57");
                } else {
                    batchPlanSubVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    batchPlanSubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    batchPlanSubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    batchPlanSubVO.setSpec(((String)datas.get(2)).trim());
                }
                if (!Objects.isNull(datas.get(3))) {
                    batchPlanSubVO.setUnit(((String)datas.get(3)).trim());
                }
                batchPlanSubVO.setSupplierName((String)datas.get(4));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) && ((String)datas.get(7)).length() > 64) {
                    batchPlanSubVO.setErrorMessage("\u7269\u6599\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    batchPlanSubVO.setMaterialCode((String)datas.get(7));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) && ((String)datas.get(8)).length() > 50) {
                    batchPlanSubVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    batchPlanSubVO.setMemo((String)datas.get(8));
                }
                batchPlanSubVO.setSourceType("3");
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        batchPlanSubVO.setNum(new BigDecimal((String)datas.get(5)));
                        if (batchPlanSubVO.getNum().longValue() < 0L) {
                            batchPlanSubVO.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        batchPlanSubVO.setErrorMessage("\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    batchPlanSubVO.setErrorMessage("\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        batchPlanSubVO.setPrice(ComputeUtil.scale((BigDecimal)new BigDecimal((String)datas.get(6)), (int)8));
                        if (batchPlanSubVO.getPrice().doubleValue() < 0.0) {
                            batchPlanSubVO.setErrorMessage("\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        batchPlanSubVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    batchPlanSubVO.setPrice(new BigDecimal(0));
                }
                if (batchPlanSubVO.getNum() != null && batchPlanSubVO.getPrice() != null) {
                    BigDecimal amount = batchPlanSubVO.getPrice().multiply(batchPlanSubVO.getNum());
                    batchPlanSubVO.setMny(amount);
                }
                if (StringUtils.isBlank((CharSequence)batchPlanSubVO.getErrorMessage())) {
                    String onlykey = batchPlanSubVO.getMaterialCategoryName() + batchPlanSubVO.getMaterialName() + batchPlanSubVO.getUnit() + batchPlanSubVO.getSpec();
                    batchPlanSubVO.setOnlyKey(onlykey);
                    successList.add(batchPlanSubVO);
                    batchPlanSubVO.setId(Long.valueOf(i));
                    continue;
                }
                errorList.add(batchPlanSubVO);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            JSONObject match = this.archivesUtil.findMatch(successList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            successList = (List)match.get((Object)"sourceList");
            List errorList1 = (List)match.get((Object)"errorList");
            errorList.addAll(errorList1);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

