/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.bean.PlanChangeSubEntity;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IPlanChangeService;
import com.ejianc.business.plan.vo.PlanChangeHisVO;
import com.ejianc.business.plan.vo.PlanChangeSubVO;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/planChange/"})
public class PlanChangeController {
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPlanChangeService planChangeService;
    @Autowired
    private IMaterialMasterPlanService materialMasterPlanService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ArchivesUtil archivesUtil;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<PlanChangeVO> saveOrUpdate(@RequestBody PlanChangeVO planVo) {
        PlanChangeVO vo;
        List materialSubList;
        this.archivesUtil.checkHaveTempMaterial(planVo.getMaterialSubList());
        PlanChangeEntity planChangeEntity = this.planChangeService.getUnFinishedChange(planVo.getSourcePlanId());
        if (!(null == planChangeEntity || null != planVo.getId() && planChangeEntity.getId().equals(planVo.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u8ba1\u5212\uff01");
        }
        MaterialMasterPlanEntity masterPlan = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanService.getById(planVo.getSourcePlanId()));
        UserContext userContext = this.sessionManager.getUserContext();
        PlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = (PlanChangeEntity)((Object)BeanMapper.map((Object)planVo, PlanChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (PlanChangeEntity)((Object)this.planChangeService.getById(planVo.getId()));
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)planVo.getMaterialSubList(), PlanChangeSubEntity.class));
        }
        saveEntity.setChangeReason(planVo.getChangeReason());
        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }
        long id = IdWorker.getId();
        if (saveEntity.getId() == null) {
            saveEntity.setId(id);
        }
        if (CollectionUtils.isNotEmpty((Collection)(materialSubList = planVo.getMaterialSubList()))) {
            for (PlanChangeSubVO planChangeSubVO : materialSubList) {
                String onlykey = planChangeSubVO.getMaterialCategoryName() + planChangeSubVO.getMaterialName() + planChangeSubVO.getUnit() + planChangeSubVO.getSpec() + planChangeSubVO.getMaterialCode();
                planChangeSubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, saveEntity.getId(), saveEntity.getPlanCode(), saveEntity.getProjectName(), "\u7269\u8d44\u603b\u8ba1\u5212\u53d8\u66f4");
            JSONObject jsonObject = this.archivesUtil.batchSaveArchive(archiveVO, materialSubList, "materialCategoryId", "materialId", "materialCategoryName", "materialName", "materialCode", "unit", "spec", "errorMessage");
            String sourceList = JSON.toJSONString((Object)jsonObject.get((Object)"sourceList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat});
            List list = JSONObject.parseArray((String)sourceList, PlanChangeSubVO.class);
            List materialMasterPlanSubEntities = BeanMapper.mapList((Iterable)list, PlanChangeSubEntity.class);
            saveEntity.setMaterialSubList(materialMasterPlanSubEntities);
        }
        if (CollectionUtils.isNotEmpty((Collection)(vo = (PlanChangeVO)BeanMapper.map((Object)((Object)(saveEntity = this.planChangeService.saveOrUpdatePlanChange(saveEntity))), PlanChangeVO.class)).getMaterialSubList())) {
            this.planChangeService.querySumApplyNum(vo);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<PlanChangeVO> queryDetail(@RequestParam(value="id") Long id) {
        PlanChangeVO vo = null;
        PlanChangeEntity dbEntity = (PlanChangeEntity)((Object)this.planChangeService.selectById(id));
        if (null != dbEntity && CollectionUtils.isNotEmpty((Collection)(vo = (PlanChangeVO)BeanMapper.map((Object)((Object)dbEntity), PlanChangeVO.class)).getMaterialSubList())) {
            this.planChangeService.querySumApplyNum(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<PlanChangeHisVO> vos) {
        this.planChangeService.deleteChangePlan(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

