/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storeCheck.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.bean.StoreCheckSubEntity;
import com.ejianc.business.storeCheck.service.IStoreCheckService;
import com.ejianc.business.storeCheck.vo.StoreCheckExportVO;
import com.ejianc.business.storeCheck.vo.StoreCheckSubExportVO;
import com.ejianc.business.storeCheck.vo.StoreCheckSubVO;
import com.ejianc.business.storeCheck.vo.StoreCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/storeCheck/"})
public class StoreCheckController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreCheckService storeCheckService;
    private final String BILL_CODE = "STORE_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<StoreCheckVO> saveOrUpdate(@RequestBody StoreCheckVO storeCheckVO) {
        if (StringUtils.isNotBlank((CharSequence)storeCheckVO.getBillCode())) {
            StoreCheckVO voByCode = this.storeCheckService.queryByCode(storeCheckVO.getBillCode());
            if (!(null == voByCode || null != storeCheckVO.getId() && voByCode.getId().equals(storeCheckVO.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("STORE_CHECK", InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            storeCheckVO.setBillCode((String)codeResp.getData());
        }
        StoreCheckVO voByStoreId = this.storeCheckService.queryInvalidBillByStoreId(storeCheckVO.getStoreId());
        if (!(null == voByStoreId || null != storeCheckVO.getId() && voByStoreId.getId().equals(storeCheckVO.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u4ed3\u5e93\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u76d8\u70b9\u5355\u636e\uff01");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StoreCheckVO latestStoreCheck = this.storeCheckService.getLatestStoreCheck(storeCheckVO.getStoreId());
        if (null != latestStoreCheck) {
            try {
                if (!sdf.parse(sdf.format(storeCheckVO.getCheckDate())).after(sdf.parse(sdf.format(latestStoreCheck.getCheckDate())))) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u4ed3\u5e93\u4e0b\u5df2\u5b58\u5728\u5df2\u751f\u6548\u7684\u4e14\u665a\u4e8e\u5f53\u524d\u76d8\u70b9\u65e5\u671f\u7684\u76d8\u70b9\u5355\u636e\uff01");
                }
            }
            catch (Exception e) {
                this.logger.error("\u6821\u9a8c\u76d8\u70b9\u5355\u636e[{}]\u76d8\u70b9\u65e5\u671f\u5f02\u5e38\uff0c", (Object)JSONObject.toJSONString((Object)storeCheckVO), (Object)e);
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6821\u9a8c\u76d8\u70b9\u5355\u636e\u76d8\u70b9\u65e5\u671f\u5931\u8d25\uff01");
            }
        }
        StoreCheckEntity saveEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)storeCheckVO.getMaterialSubList())) {
            for (StoreCheckSubVO subVo : storeCheckVO.getMaterialSubList()) {
                subVo.setInventory(Double.valueOf(subVo.getCheckNum() - subVo.getAccNum()));
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (null == storeCheckVO.getId()) {
            saveEntity = (StoreCheckEntity)((Object)BeanMapper.map((Object)storeCheckVO, StoreCheckEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (StoreCheckEntity)((Object)this.storeCheckService.getById(storeCheckVO.getId()));
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setCheckDate(storeCheckVO.getCheckDate());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)storeCheckVO.getMaterialSubList(), StoreCheckSubEntity.class));
        }
        storeCheckVO = this.storeCheckService.saveCheckStore(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f!", (Object)storeCheckVO);
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<StoreCheckVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("storeName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("createUserName");
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.storeCheckService.queryPage(queryParam);
        Page resp = new Page();
        resp.setSize(pageData.getSize());
        resp.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), StoreCheckVO.class));
        resp.setCurrent(pageData.getCurrent());
        resp.setTotal(pageData.getTotal());
        resp.setPages(pageData.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u76d8\u70b9\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = null;
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        childOrgResp = StringUtils.isNotEmpty((CharSequence)authOrgIds) ? this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())) : this.orgApi.findChildrenByParentId(orgId);
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        return c1;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<StoreCheckVO> queryDetail(@RequestParam(value="id") Long id) {
        StoreCheckVO vo = null;
        StoreCheckEntity dbEntity = (StoreCheckEntity)((Object)this.storeCheckService.selectById(id));
        if (null != dbEntity) {
            vo = (StoreCheckVO)BeanMapper.map((Object)((Object)dbEntity), StoreCheckVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<StoreCheckVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.storeCheckService.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("storeName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.storeCheckService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List data = pageData.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            data.forEach(storeCheck -> {
                StoreCheckExportVO vo = (StoreCheckExportVO)BeanMapper.map((Object)storeCheck, StoreCheckExportVO.class);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)storeCheck.getBillState()).getDescription());
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("storeCheck-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody StoreCheckVO storeCheckVO, HttpServletResponse response) {
        ArrayList list = new ArrayList();
        HashMap beans = new HashMap();
        Long storeCheckVOId = storeCheckVO.getId();
        if (storeCheckVOId != null) {
            StoreCheckEntity entity = (StoreCheckEntity)((Object)this.storeCheckService.selectById(storeCheckVOId));
            DecimalFormat df = new DecimalFormat("#,##0.00");
            List<StoreCheckSubEntity> data = entity.getMaterialSubList();
            if (CollectionUtils.isNotEmpty(data)) {
                data.forEach(storeCheckSub -> {
                    StoreCheckSubExportVO vo = (StoreCheckSubExportVO)BeanMapper.map((Object)storeCheckSub, StoreCheckSubExportVO.class);
                    vo.setAccAmountStr(df.format(vo.getAccAmount()));
                    list.add(vo);
                });
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("storeCheckMaterialList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"storeCheckMaterialList-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<StoreCheckSubVO> successList = new ArrayList<StoreCheckSubVO>();
        ArrayList<StoreCheckSubVO> errorList = new ArrayList<StoreCheckSubVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 10) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StoreCheckSubVO storeCheckSubVO = new StoreCheckSubVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    storeCheckSubVO.setErrorMessage("\u7269\u6599\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else {
                    String materialCategoryName = ((String)datas.get(0)).toString().trim();
                    storeCheckSubVO.setMaterialCategoryName(materialCategoryName);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    storeCheckSubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 30) {
                    storeCheckSubVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~30\u5b57");
                } else {
                    storeCheckSubVO.setMaterialName(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    storeCheckSubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 200) {
                    storeCheckSubVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~200\u5b57");
                } else {
                    storeCheckSubVO.setSpec(((String)datas.get(2)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    storeCheckSubVO.setErrorMessage("\u54c1\u724c\u4e3a\u5fc5\u586b\u9879");
                } else {
                    storeCheckSubVO.setBrandName(((String)datas.get(3)).trim());
                }
                if (!Objects.isNull(datas.get(4))) {
                    storeCheckSubVO.setUnit(((String)datas.get(4)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) && ((String)datas.get(5)).length() > 64) {
                    storeCheckSubVO.setErrorMessage("\u7269\u6599\u7f16\u7801\u586b\u5199\u957f\u5ea6\u4e3a0~64\u5b57");
                } else {
                    storeCheckSubVO.setMaterialCode((String)datas.get(5));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        storeCheckSubVO.setAccNum(Double.valueOf(Double.parseDouble((String)datas.get(6))));
                    }
                    catch (Exception e) {
                        storeCheckSubVO.setErrorMessage("\u8d26\u9762\u6570\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    storeCheckSubVO.setAccNum(Double.valueOf(Double.parseDouble("0")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        storeCheckSubVO.setCheckNum(Double.valueOf(Double.parseDouble((String)datas.get(7))));
                    }
                    catch (Exception e) {
                        storeCheckSubVO.setErrorMessage("\u76d8\u70b9\u6570\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    storeCheckSubVO.setCheckNum(Double.valueOf(Double.parseDouble("0")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    try {
                        storeCheckSubVO.setInventory(Double.valueOf(Double.parseDouble((String)datas.get(8))));
                    }
                    catch (Exception e) {
                        storeCheckSubVO.setErrorMessage("\u76d8\u70b9\u4e8f\u76c8\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    storeCheckSubVO.setInventory(Double.valueOf(Double.parseDouble("0")));
                }
                if (storeCheckSubVO.getAccNum() != null && storeCheckSubVO.getCheckNum() != null) {
                    double inventory = BigDecimal.valueOf(storeCheckSubVO.getCheckNum()).subtract(BigDecimal.valueOf(storeCheckSubVO.getAccNum())).doubleValue();
                    storeCheckSubVO.setInventory(Double.valueOf(inventory));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) && ((String)datas.get(8)).length() > 50) {
                    storeCheckSubVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    storeCheckSubVO.setRemark((String)datas.get(9));
                }
                if (StringUtils.isBlank((CharSequence)storeCheckSubVO.getErrorMessage())) {
                    successList.add(storeCheckSubVO);
                    storeCheckSubVO.setId(Long.valueOf(i));
                    continue;
                }
                errorList.add(storeCheckSubVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

