/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.material.mapper.StoreTopMapper;
import com.ejianc.business.material.service.IStoreTopService;
import com.ejianc.business.material.vo.ConstructionStoreVo;
import com.ejianc.business.material.vo.StoreDataVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreTopServiceImpl
implements IStoreTopService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private StoreTopMapper storeTopMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<JSONObject> storeTop(ConstructionStoreVo constructionStoreVo) {
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
        filterOrgIdVo.setOrgId(constructionStoreVo.getOrgId());
        filterOrgIdVo.setDateIn(constructionStoreVo.getDateIn() == null ? null : constructionStoreVo.getDateIn());
        filterOrgIdVo.setProjectStatus(constructionStoreVo.getProjectStatus() == null ? null : constructionStoreVo.getProjectStatus());
        CommonResponse listCommonResponse = this.projectApi.queryFilterOrgIds(filterOrgIdVo);
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            jsonObject.put("materialTop10", null);
            jsonObject.put("projectTop5", null);
            jsonObject.put("storeTopCompany", null);
            return CommonResponse.success((Object)jsonObject);
        }
        String orgIdS = "(" + String.join((CharSequence)",", ((List)listCommonResponse.getData()).stream().map(Object::toString).collect(Collectors.toList())) + ")";
        if (constructionStoreVo.getMaterialId() == null) {
            List<JSONObject> storeMaterialTop = this.storeTopMapper.constructionStoreTop(orgIdS);
            if (CollectionUtils.isEmpty(storeMaterialTop)) {
                jsonObject.put("materialTop10", null);
            } else {
                jsonObject.put("materialTop10", storeMaterialTop);
                this.queryProjectTop(orgIdS, (Long)storeMaterialTop.get(0).get((Object)"materialId"), jsonObject);
            }
        } else {
            this.logger.info("\u67e5\u8be2\u7edf\u8ba1\u7269\u8d44id---\uff1a{}", (Object)JSONObject.toJSONString((Object)constructionStoreVo.getMaterialId()));
            this.queryProjectTop(orgIdS, constructionStoreVo.getMaterialId(), jsonObject);
        }
        return CommonResponse.success((Object)jsonObject);
    }

    private JSONObject queryProjectTop(String orgIds, Long materialId, JSONObject json) {
        List<JSONObject> projectTop = this.storeTopMapper.constructionStoreTopProject(orgIds, materialId);
        if (CollectionUtils.isNotEmpty(projectTop)) {
            List projectId = projectTop.stream().map(e -> e.get((Object)"projectId")).collect(Collectors.toList());
            String projectIds = "(" + String.join((CharSequence)",", projectId.stream().map(Object::toString).collect(Collectors.toList())) + ")";
            List<JSONObject> contractTop = this.storeTopMapper.constructionStoreTopContract(projectIds, materialId, orgIds);
            Map<Object, Object> contractTopData = new HashMap();
            if (CollectionUtils.isNotEmpty(contractTop)) {
                contractTopData = contractTop.stream().collect(Collectors.toMap(e -> e.get((Object)"projectId"), e -> e));
            }
            for (JSONObject js : projectTop) {
                js.put("contractTop", contractTopData.get(js.get((Object)"projectId")) == null ? JSONObject.parseObject((String)"{\"avgPrice\":0,\"minPrice\":0,\"maxPrice\":0}") : contractTopData.get(js.get((Object)"projectId")));
            }
            json.put("projectTop5", projectTop);
        } else {
            json.put("projectTop5", null);
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        BigDecimal companyTop = this.storeTopMapper.constructionStoreTopContractCompany(tenantId, materialId);
        json.put("storeTopCompany", (Object)(companyTop == null ? Integer.valueOf(0) : companyTop));
        return json;
    }

    @Override
    public CommonResponse<JSONObject> storeData(ConstructionStoreVo constructionStoreVo) {
        String orgIdS;
        BigDecimal planMny;
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
        filterOrgIdVo.setOrgId(constructionStoreVo.getOrgId());
        filterOrgIdVo.setDateIn(constructionStoreVo.getDateIn() == null ? null : constructionStoreVo.getDateIn());
        filterOrgIdVo.setProjectStatus(constructionStoreVo.getProjectStatus() == null ? null : constructionStoreVo.getProjectStatus());
        CommonResponse listCommonResponse = this.projectApi.queryFilterOrgIds(filterOrgIdVo);
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            jsonObject.put("planMny", null);
            jsonObject.put("inStoreAmount", null);
            jsonObject.put("storeTotalAmount", null);
            jsonObject.put("storeData", null);
            return CommonResponse.success((Object)jsonObject);
        }
        if (null == constructionStoreVo.getPlanSort()) {
            constructionStoreVo.setPlanSort("desc");
        }
        if (null == constructionStoreVo.getInStoreSort()) {
            constructionStoreVo.setInStoreSort("desc");
        }
        if (null == constructionStoreVo.getInStoreSort()) {
            constructionStoreVo.setInStoreSort("desc");
        }
        jsonObject.put("planMny", (Object)((planMny = this.storeTopMapper.planTotalMny(orgIdS = "(" + String.join((CharSequence)",", ((List)listCommonResponse.getData()).stream().map(Object::toString).collect(Collectors.toList())) + ")")) == null ? BigDecimal.ZERO : planMny));
        BigDecimal inStoreTotalMny = this.storeTopMapper.inStoreTotalMny(orgIdS);
        jsonObject.put("inStoreAmount", (Object)(inStoreTotalMny == null ? BigDecimal.ZERO : inStoreTotalMny));
        BigDecimal storeTotalMny = this.storeTopMapper.storeTotalMny(orgIdS);
        jsonObject.put("storeTotalAmount", (Object)(storeTotalMny == null ? BigDecimal.ZERO : storeTotalMny));
        List<StoreDataVo> jsonObjects = this.storeTopMapper.storeData(orgIdS, constructionStoreVo.getPlanSort(), constructionStoreVo.getInStoreSort(), constructionStoreVo.getStoreSort());
        this.logger.info("\u9879\u76ee\u67f1\u72b6\u56fe--{}", (Object)jsonObjects.toString());
        List collect = jsonObjects.stream().filter(e -> e.getProjectId() != null).collect(Collectors.toList());
        jsonObject.put("storeData", collect);
        return CommonResponse.success((Object)jsonObject);
    }
}

