/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICtrlSetApi;
import com.ejianc.business.cost.vo.CtrlSetDetailVO;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.UseApplySubVO;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.plan.vo.MaterialMasterPlanVO;
import com.ejianc.business.plan.vo.PlanControlSubVO;
import com.ejianc.business.plan.vo.PlanControlVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialMasterPlanService")
public class MaterialMasterPlanServiceImpl
extends BaseServiceImpl<MaterialMasterPlanMapper, MaterialMasterPlanEntity>
implements IMaterialMasterPlanService {
    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    private static final String PARAM_TOTAL_MNY = "P-ne9e9741";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    @Autowired
    private IMaterialMasterPlanSubService materialMasterPlanSubService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private ICtrlSetApi ctrlSetApi;
    @Autowired
    private UseApplyMapper useApplyMapper;

    @Override
    public MaterialMasterPlanVO queryByCode(String planCode) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"plan_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    public MaterialMasterPlanVO queryByProjectId(Long projectId) {
        MaterialMasterPlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        MaterialMasterPlanEntity entity = (MaterialMasterPlanEntity)((Object)this.materialMasterPlanMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (MaterialMasterPlanVO)BeanMapper.map((Object)((Object)entity), MaterialMasterPlanVO.class);
        }
        return resp;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MaterialMasterPlanEntity saveOrUpdateMasterPlan(MaterialMasterPlanEntity saveEntity) {
        if (null != saveEntity.getId()) {
            this.materialMasterPlanSubMapper.delByPlanId(saveEntity.getId());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return saveEntity;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, String billType, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(billType)) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(billType)) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(PlanControlVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        List materialSubList = vo.getPlanControlSubVOList();
        if (CollectionUtils.isNotEmpty((Collection)materialSubList)) {
            BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO;
            Map detailProMap;
            List subIds = materialSubList.stream().map(PlanControlSubVO::getMaterialId).collect(Collectors.toList());
            BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
            paramControlVO1.setProjectId(vo.getProjectId());
            paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
            paramControlVO1.setIds(subIds);
            this.logger.info("\u53c2\u6570\uff1a", (Object)JSONObject.toJSONString((Object)paramControlVO1));
            CommonResponse res1 = this.budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
            if (!res1.isSuccess()) {
                throw new BusinessException("\u9884\u7b97\u6750\u6599\u6e05\u5355\u91cf\uff0c\u67e5\u8be2\u9879\u76ee\u9884\u7b97\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg());
            }
            if (null != res1.getData() && !(detailProMap = (proQuantityAndMnyVO = (BudgetProjectProQuantityAndMnyVO)res1.getData()).getDetailProMap()).isEmpty()) {
                List categoryIds = materialSubList.stream().map(e -> e.getMaterialCategoryId()).distinct().collect(Collectors.toList());
                CommonResponse listCommonResponse = this.ctrlSetApi.querySetDetailByCategory(categoryIds);
                if (!listCommonResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u7269\u6599\u7ba1\u63a7\u8bbe\u7f6e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + listCommonResponse.getMsg());
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
                    List data = (List)listCommonResponse.getData();
                    Map<Long, List<CtrlSetDetailVO>> controlMap = data.stream().collect(Collectors.groupingBy(e -> e.getSetId()));
                    for (PlanControlSubVO planControlSubVO : materialSubList) {
                        if (!detailProMap.containsKey(planControlSubVO.getMaterialId()) || !controlMap.containsKey(planControlSubVO.getMaterialCategoryId())) continue;
                        BudgetProjectDetailProVO budgetProjectDetailProVO = (BudgetProjectDetailProVO)detailProMap.get(planControlSubVO.getMaterialId());
                        BigDecimal costNum = budgetProjectDetailProVO.getNum();
                        BigDecimal costMny = budgetProjectDetailProVO.getMaterialTaxMnyCost();
                        List<CtrlSetDetailVO> ctrlSetDetailVO = controlMap.get(planControlSubVO.getMaterialCategoryId());
                        BigDecimal planNum = new BigDecimal(planControlSubVO.getNum().toString());
                        BigDecimal planMny = planControlSubVO.getAmount();
                        for (CtrlSetDetailVO setDetail : ctrlSetDetailVO) {
                            String redText;
                            String text;
                            StringBuffer stringBuffer;
                            ParamsCheckDsVO paramsCheckDsVO;
                            BigDecimal exceed;
                            BigDecimal cost;
                            if (setDetail.getControlType() == 1) {
                                cost = ComputeUtil.safeMultiply((BigDecimal)costNum, (BigDecimal)setDetail.getControlScale());
                                if (!ComputeUtil.isGreaterThan((BigDecimal)planNum, (BigDecimal)(cost = ComputeUtil.safeDiv((BigDecimal)cost, (BigDecimal)new BigDecimal("100"))))) continue;
                                exceed = ComputeUtil.safeSub((BigDecimal)planNum, (BigDecimal)cost);
                                paramsCheckDsVO = new ParamsCheckDsVO(planControlSubVO.getMaterialId(), "num");
                                paramsCheckDsVO.setOrgName("\u534e\u5eb7");
                                paramsCheckDsVO.setWarnItem(planControlSubVO.getMaterialName() + "-" + planControlSubVO.getSpec() + "\u8ba1\u5212\u91cf\u8d85\u989d\u9884\u8b66");
                                paramsCheckDsVO.setWarnName("\u6750\u6599\u603b\u8ba1\u5212\u91cf\u8d85\u76ee\u6807\u6210\u672c\u91cf");
                                stringBuffer = new StringBuffer();
                                text = "\u8d85\u51fa\u6570\u91cf=" + planNum.setScale(2, RoundingMode.HALF_UP) + "-" + costNum.setScale(2, RoundingMode.HALF_UP) + "*" + setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP) + "% =" + exceed.setScale(2, RoundingMode.HALF_UP) + planControlSubVO.getUnit() + "\u3002";
                                redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                                stringBuffer.append("\u603b\u8ba1\u5212\u91cf\uff1a").append(planNum.setScale(2, RoundingMode.HALF_UP)).append(planControlSubVO.getUnit()).append("\uff0c\u76ee\u6807\u6210\u672c\u91cf\uff1a").append(costNum.setScale(2, RoundingMode.HALF_UP)).append(planControlSubVO.getUnit()).append("\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)).append("%\uff1a").append(redText);
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                MaterialMasterPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod() == 1 ? "warn" : "alert", paramsCheckDsVO);
                                continue;
                            }
                            cost = ComputeUtil.safeMultiply((BigDecimal)costMny, (BigDecimal)setDetail.getControlScale());
                            if (!ComputeUtil.isGreaterThan((BigDecimal)planMny, (BigDecimal)(cost = ComputeUtil.safeDiv((BigDecimal)cost, (BigDecimal)new BigDecimal("100"))))) continue;
                            exceed = ComputeUtil.safeSub((BigDecimal)planMny, (BigDecimal)cost);
                            paramsCheckDsVO = new ParamsCheckDsVO(planControlSubVO.getMaterialId(), "mny");
                            paramsCheckDsVO.setOrgName("\u534e\u5eb7");
                            paramsCheckDsVO.setWarnItem(planControlSubVO.getMaterialName() + "-" + planControlSubVO.getSpec() + "\u8ba1\u5212\u91d1\u989d\u8d85\u989d\u9884\u8b66");
                            paramsCheckDsVO.setWarnName("\u6750\u6599\u603b\u8ba1\u5212\u91d1\u989d\u8d85\u76ee\u6807\u6210\u672c\u91d1\u989d");
                            stringBuffer = new StringBuffer();
                            text = "\u8d85\u51fa\u91d1\u989d=" + planMny.setScale(2, RoundingMode.HALF_UP) + "-" + costMny.setScale(2, RoundingMode.HALF_UP) + "*" + setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP) + "% =" + exceed.setScale(2, RoundingMode.HALF_UP) + "\u5143\u3002";
                            redText = Jsoup.parse((String)("<font color=\"red\">" + text + "</font>")).body().html();
                            stringBuffer.append("\u603b\u8ba1\u5212\u91d1\u989d\uff1a").append(planMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u76ee\u6807\u6210\u672c\u91d1\u989d\uff1a").append(costMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u7ba1\u63a7\u6bd4\u4f8b\uff1a").append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)).append("%\uff1a").append(redText);
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialMasterPlanServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod() == 1 ? "warn" : "alert", paramsCheckDsVO);
                        }
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public void querySumApplyNum(List<MaterialMasterPlanSubVO> materialSubList) {
        if (CollectionUtils.isNotEmpty(materialSubList)) {
            HashMap<String, Object> queryParam = new HashMap<String, Object>();
            queryParam.put("sourceIds", materialSubList.stream().map(BaseVO::getId).collect(Collectors.toList()));
            List<UseApplySubVO> applylist = this.useApplyMapper.countSumApplyBySource(queryParam);
            Map<Long, BigDecimal> map = applylist.stream().collect(Collectors.groupingBy(UseApplySubVO::getSourceId, Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            for (MaterialMasterPlanSubVO materialMasterPlanSubVO : materialSubList) {
                materialMasterPlanSubVO.setSumApplyNum(map.get(materialMasterPlanSubVO.getId()));
                materialMasterPlanSubVO.setSurplusApplyNum(ComputeUtil.safeSub((BigDecimal)ComputeUtil.toBigDecimal((Double)materialMasterPlanSubVO.getNum()), (BigDecimal)materialMasterPlanSubVO.getSumApplyNum()));
            }
        }
    }
}

