/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bidprice.material.api.ImaterialPicketageApi;
import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.bean.MaterialContractDetailSubEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialContractOtherCostSubEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.MaterialContractDetailSubVO;
import com.ejianc.business.material.vo.MaterialContractItemVO;
import com.ejianc.business.material.vo.MaterialContractPriceQueryVO;
import com.ejianc.business.material.vo.MaterialContractPriceResultVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.business.utils.ListSplitUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="materialService")
public class MaterialContractServiceImpl
extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity>
implements IMaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "materialContract";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private ImaterialPicketageApi materialPicketageApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String PARAM_TOTAL_MNY = "P-t58ih142";
    private static final String PARAM_NUM = "P-uFOcn644";
    private static final String PARAM_TAX_MNY = "P-14dTg745";
    @Autowired
    private IUseApplyService useApplyService;
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";
    private static String PARAM_PRICE_AREA = "P-126hYD10";
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList) {
        ArrayList<MaterialContractVO> result = new ArrayList<MaterialContractVO>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.materialContractMapper.queryContractTaxWarnContract(list));
        }
        return result;
    }

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        boolean b;
        MaterialContractEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, 4);
        MaterialContractEntity dbEntity = null;
        if (null != materialContractVO.getId()) {
            dbEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)materialContractVO.getId()));
        }
        if (dbEntity != null) {
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());
        } else {
            materialContractVO.setCreateUserName(userContext.getUserName());
            materialContractVO.setChangeVersion(Integer.valueOf(1));
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getMaterialDetailList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getMaterialDetailList().stream().filter(detail -> !"del".equals(detail.getRowState()) && null != detail.getTotalAmount()).map(MaterialContractDetailSubEntity::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty(saveEntity.getOtherCostList())) {
            totalAmountWith = totalAmountWith.add(saveEntity.getOtherCostList().stream().filter(cost -> !"del".equals(cost.getRowState()) && null != cost.getCostAmount()).map(MaterialContractOtherCostSubEntity::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            saveEntity.getOtherCostList().stream().filter(cost -> null == cost.getCostAmount()).forEach(cost -> cost.setCostAmount(new BigDecimal(0)));
        }
        if (b = super.saveOrUpdate((Object)saveEntity, false)) {
            this.countContractNumAndMnyByEnquiry(saveEntity.getEnquiryPriceBillId());
        }
        return (MaterialContractVO)BeanMapper.map((Object)((Object)saveEntity), MaterialContractVO.class);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }
        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter("ne", (Object)id));
        }
        check.getParams().put("code", new Parameter("eq", (Object)code));
        check.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter("ne", (Object)id));
        check.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        List changeList = this.contractChangeService.queryList(check, false);
        return !CollectionUtils.isNotEmpty((Collection)changeList);
    }

    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (contractEntity == null) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        if (contractEntity.getBillState() != 1 && contractEntity.getBillState() != 3) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u672a\u751f\u6548\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List lists = ListSplitUtil.splistList(sqlParamList, (int)10);
        for (List list : lists) {
            result.addAll(this.materialContractMapper.queryAllWarnContracts(list));
        }
        return result;
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return ((MaterialContractMapper)this.baseMapper).materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return ((MaterialContractMapper)this.baseMapper).getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax() == null ? BigDecimal.ZERO : ce.getAmountWithTax());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax() == null ? BigDecimal.ZERO : ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(quoteEntities.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            List<MaterialPriceVO> materialPrices;
            MaterialPriceVO p;
            Long materialId;
            List<MaterialPriceVO> materialPriceVOS;
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc && CollectionUtils.isNotEmpty(materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds))) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVOMap.get(materialId);
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                }
            }
            if (CollectionUtils.isNotEmpty(materialPrices = this.materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds))) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVO.get(materialId);
                    if (null == p) continue;
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                    v.setBuyPrice(p.getBuyPrice());
                }
            }
        }
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        List<MaterialPriceVO> detailList = vo.getDetail();
        HashMap numMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            detailList.forEach(detail -> {
                MaterialPriceVO numVO = (MaterialPriceVO)numMap.get(detail.getMaterialId());
                if (numVO != null) {
                    numVO.setNum(ComputeUtil.safeAdd((BigDecimal)numVO.getNum(), (BigDecimal)detail.getNum()));
                    numVO.setPrice(ComputeUtil.isLessThan((BigDecimal)detail.getPrice(), (BigDecimal)numVO.getPrice()) ? detail.getPrice() : numVO.getPrice());
                    numVO.setTotalAmount(ComputeUtil.safeAdd((BigDecimal)numVO.getTotalAmount(), (BigDecimal)detail.getTotalAmount()));
                } else {
                    numMap.put(detail.getMaterialId(), detail);
                }
            });
            vo.setDetail(new ArrayList(numMap.values()));
            List detail2 = vo.getDetail();
            if (isJc == 0) {
                List subIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u3010\u7269\u8d44\u603b\u8ba1\u5212\u91cf\u3011\u63a7\u5236\u3010\u7269\u8d44\u5408\u540c\u91cf\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 == billParamVO.getControlType()) continue;
                        List<Long> materialIds = detail2.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        List<Object> vos = new ArrayList();
                        vos = this.materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        for (MaterialPriceVO d : detail2) {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(planNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u5408\u540c\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5408\u540c\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u7b7e\u8ba2\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(planNum).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            MaterialContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse;
        BigDecimal wz = BigDecimal.ZERO;
        if (contractId != null) {
            wz = ((MaterialContractMapper)this.baseMapper).fetchSjzcje(projectId, contractId);
        }
        if (!(fbCommonResponse = this.subContractApi.fetchSjzcje(projectId)).isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    @Override
    public BigDecimal fetchAmountWithTax(Long projectId) {
        return this.materialContractMapper.sumLastTotalAmountWithTax(projectId, null);
    }

    @Override
    public MaterialPicketageVO countContractNumAndMnyByEnquiry(Long ... enquiryPriceBillIds) {
        if (enquiryPriceBillIds != null) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"count(1) as num, IFNULL(sum(amount_with_tax),0) as money"}).eq((Object)"enquiry_price_bill_id", (Object)enquiryPriceBillId);
                Map map = this.getMap((Wrapper)queryWrapper);
                MaterialPicketageVO materialPicketageVO = new MaterialPicketageVO();
                if (MapUtils.isNotEmpty((Map)map)) {
                    Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(num);
                    materialPicketageVO.setContractSignMny(money);
                } else {
                    materialPicketageVO.setId(enquiryPriceBillId);
                    materialPicketageVO.setContractSign(Integer.valueOf(0));
                    materialPicketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                this.materialPicketageApi.updateContractSignMny(materialPicketageVO);
            }
        }
        return null;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((MaterialContractMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }

    @Override
    public CommonResponse<String> onFile(OtherContractVO contractVO) {
        MaterialContractEntity entity = (MaterialContractEntity)((Object)this.selectById(contractVO.getId()));
        if ("1".equals(entity.getFileState())) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5f52\u6863");
        }
        entity.setFileState("1");
        this.saveOrUpdate((Object)entity, false);
        CommonResponse back = this.attachmentApi.updateAttachRef(contractVO.getId(), contractVO.getAttachIds());
        if (!back.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }

    @Override
    public Map<Long, List<MaterialContractPriceResultVO>> queryMaterialContractPrice(MaterialContractPriceQueryVO queryVO) {
        List<MaterialContractPriceResultVO> resultVOS = this.materialContractMapper.queryMaterialContractPrice(queryVO.getProjectId(), queryVO.getMaterialIds());
        Map<Long, List<MaterialContractPriceResultVO>> map = null;
        map = CollectionUtils.isNotEmpty(resultVOS) ? resultVOS.stream().collect(Collectors.groupingBy(MaterialContractPriceResultVO::getMaterialId)) : new HashMap<Long, List<MaterialContractPriceResultVO>>();
        return map;
    }

    @Override
    public Map<String, BigDecimal> purchaseInfo() {
        return ((MaterialContractMapper)this.baseMapper).purchaseInfo(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> supplierTop() {
        return ((MaterialContractMapper)this.baseMapper).supplierTop(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> financeData() {
        return ((MaterialContractMapper)this.baseMapper).financeData(InvocationInfoProxy.getTenantid());
    }

    @Override
    public List<Map<String, Object>> efficiencyManagement() {
        return ((MaterialContractMapper)this.baseMapper).efficiencyManagement(InvocationInfoProxy.getTenantid());
    }

    @Override
    public Map<String, BigDecimal> storeMny() {
        return ((MaterialContractMapper)this.baseMapper).storeMny(InvocationInfoProxy.getTenantid());
    }

    @Override
    public Map<String, BigDecimal> performanceStatus(String startDate, String endDate) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.between((Object)"apply_date", (Object)startDate, (Object)endDate);
        int applyNum = this.useApplyService.count((Wrapper)wrapper);
        map.put("applyNum", ComputeUtil.toBigDecimal((Integer)applyNum));
        BigDecimal refNum = ((MaterialContractMapper)this.baseMapper).getRefCount(InvocationInfoProxy.getTenantid(), startDate, endDate);
        map.put("refNum", ComputeUtil.nullToZero((BigDecimal)refNum));
        BigDecimal unRefFiveDaysNum = ((MaterialContractMapper)this.baseMapper).getUnRefFiveCount(InvocationInfoProxy.getTenantid(), startDate, endDate);
        map.put("unRefFiveDaysNum", ComputeUtil.nullToZero((BigDecimal)unRefFiveDaysNum));
        QueryWrapper contractWrapper = new QueryWrapper();
        contractWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        contractWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        contractWrapper.between((Object)"sign_date", (Object)startDate, (Object)endDate);
        contractWrapper.isNotNull((Object)"project_id");
        int contractSignNum = this.count((Wrapper)contractWrapper);
        map.put("contractSignNum", ComputeUtil.toBigDecimal((Integer)contractSignNum));
        QueryWrapper threeWrapper = new QueryWrapper();
        threeWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        threeWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        threeWrapper.between((Object)"sign_date", (Object)startDate, (Object)endDate);
        threeWrapper.isNotNull((Object)"project_id");
        threeWrapper.apply("DATEDIFF( NOW(), commit_date ) > 3", new Object[0]);
        int unPassThreeNum = this.count((Wrapper)threeWrapper);
        map.put("unPassThreeNum", ComputeUtil.toBigDecimal((Integer)unPassThreeNum));
        return map;
    }

    public PSRMResponse saveOrUpdatePsrmObj(MaterialContractVO vo) {
        PSRMResponse resp;
        String signDate = DateUtil.format((Date)vo.getSignDate(), (String)"yyyy-MM-dd");
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", (Object)vo.getCode());
        obj.put("f_code", (Object)vo.getCode());
        obj.put("f_status", (Object)"Y");
        obj.put("f_date", (Object)signDate);
        obj.put("f_potype", (Object)vo.getPurchaseTypeName());
        List contractItemList = vo.getContractItemList();
        if (CollectionUtils.isNotEmpty((Collection)contractItemList)) {
            for (MaterialContractItemVO materialContractItemVO : contractItemList) {
                if (!"\u4ed8\u6b3e\u65b9\u5f0f".equals(materialContractItemVO.getItemName())) continue;
                obj.put("f_paymenttypetext", (Object)materialContractItemVO.getItemContent());
            }
        }
        try {
            JSONArray jArray;
            if (vo.getSupplierId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getSupplierId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                obj.put("f_supplycode", (Object)json.getString("code"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        obj.put("f_engineeringcode", (Object)vo.getProjectCode());
        obj.put("f_name", (Object)vo.getName());
        obj.put("f_explanation", (Object)"\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
        obj.put("f_empname", (Object)vo.getEmployeeName());
        obj.put("f_synccreator", (Object)vo.getCreateUserName());
        UserContext userContext = this.sessionManager.getUserContext();
        obj.put("f_syncauditor", (Object)userContext.getUserName());
        ArrayList<JSONObject> detail = new ArrayList<JSONObject>();
        List materialDetailList = vo.getMaterialDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialDetailList)) {
            int i = 0;
            for (MaterialContractDetailSubVO materialSubVO : materialDetailList) {
                if ("del".equals(materialSubVO.getRowState())) continue;
                JSONObject subObj = new JSONObject();
                subObj.put("f_seq", (Object)(++i));
                subObj.put("f_materialcode", (Object)materialSubVO.getMaterialCode());
                subObj.put("f_qty", (Object)materialSubVO.getCount());
                subObj.put("f_auxtaxprice", (Object)materialSubVO.getUnitPrice());
                subObj.put("f_amount", (Object)materialSubVO.getTotalAmount());
                subObj.put("f_allamount", (Object)materialSubVO.getTotalAmount());
                subObj.put("f_confetchdate", (Object)signDate);
                subObj.put("f_note", (Object)materialSubVO.getMaterialRemark());
                detail.add(subObj);
            }
            obj.put("detail", detail);
        }
        if (!(resp = this.psrmRestUtil.postReq((Object)obj, this.getSaveMethodName())).isSuccess()) {
            throw new BusinessException("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25\uff1a" + (String)resp.getWarnmsg().get(0));
        }
        return resp;
    }

    public String getSaveMethodName() {
        return "dmp.purchaseorder.add";
    }

    public String getUpdateMethodName() {
        return null;
    }
}

