package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/12 出库主表
 * @Description OutStoreEntity
 */

@TableName("ejc_material_out_store")
public class OutStoreEntity extends BaseEntity {


    /**
     * 直入直出对应入库表主表id
     */
    @TableField(value = "straight_in_id")
    private Long straightInId;

    /**
     * 单据状态
     */
    @TableField(value = "bill_state")
    private Integer billState;

    /**
     * 是否属于项目 1是 0否
     */
    @TableField(value = "project_flag")
    private String projectFlag;

    /**
     * 出库类型
     */
    @TableField(value = "store_type")
    private Integer storeType;

    /**
     * 出库编号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 出库日期
     */
    @TableField(value = "out_date")
    private Date outDate;

    /**
     * 出库仓库id
     */
    @TableField(value = "store_id")
    private Long storeId;

    /**
     * 出库仓库名称
     */
    @TableField(value = "store_name")
    private String storeName;

    /**
     * 出库组织id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 出库组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 出库物资名称集合
     */
    @TableField(value = "material_names")
    private String materialNames;

    /**
     * 出库数量
     */
    @TableField(value = "out_num")
    private BigDecimal outNum;

    /**
     * 出库金额 含税
     */
    @TableField(value = "out_money")
    private BigDecimal outMoney;

    /**
     * 出库金额 不含税
     */
    @TableField(value = "out_money_no_tax")
    private BigDecimal outMoneyNoTax;

    /**
     * 用处
     */
    @TableField(value = "use_for")
    private String useFor;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 编制人
     */
    @TableField(value = "creator_name")
    private String creatorName;

    /**
     * 出库项目名称
     */
    @TableField(value = "project_name")
    private String projectName;

    /**
     * 所属项目编码
     */
    @TableField(value = "project_code")
    private String projectCode;

    /**
     * 出库项目id
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 供应商 直入直出
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 劳务队伍
     */
    @TableField(value = "supplier_id")
    private Long supplierId;

    /**
     * 劳务队伍
     */
    @TableField(value = "contract_id")
    private Long contractId;

    /**
     * 合同名称 直入直出
     */
    @TableField(value = "contract_name")
    private String contractName;


    /**
     * 调入项目名称
     */
    @TableField(value = "in_project_name")
    private String inProjectName;

    /**
     * 调入项目id
     */
    @TableField(value = "in_project_id")
    private Long inProjectId;

    /**
     * 调入仓库名称
     */
    @TableField(value = "in_store_name")
    private String inStoreName;

    /**
     * 调入组织id
     */
    @TableField(value = "in_org_id")
    private Long inOrgId;

    /**
     * 调入组织名称
     */
    @TableField(value = "in_org_name")
    private String inOrgName;

    /**
     * 调入单位是否属于项目
     */
    @TableField(value = "in_belong_to_project")
    private String inBelongToProject;

    /**
     * 调入组织收料状态
     */
    @TableField(value = "receive_state")
    private String receiveState;

    /**
     * 调入组织收料状人
     */
    @TableField(value = "receive_person")
    private String receivePerson;

    /**
     * 调入组织退回原因
     */
    @TableField(value = "return_reason")
    private String returnReason;

    /**
     * 通知收料（调入组织收料人）
     */
    @TableField(value = "notice_to_receive")
    private Long noticeToReceive;

    /**
     * 退货金额差
     */
    @TableField(value = "money_disparity")
    private BigDecimal moneyDisparity;

    /**
     * 退货是否结算（1已结算,0未结算） 退货使用
     */
    @TableField(value = "settlement_flag")
    private Integer settlementFlag;

    /**
     * 成本关联科目状态(1:是，0：否)
     */
    @TableField(value = "relation_flag")
    private String relationFlag = "0";

    /**
     * 成本分摊状态(1:是，0：否)
     */
    @TableField(value = "proportion_flag")
    private String proportionFlag = "0";
    //车牌号
    @TableField(value = "car_number")
    private String carNumber;

    /**
     * 税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

    @TableField(exist = false)
    @SubEntity(serviceName = "outStoreSubService")
    List<OutStoreSubEntity> outStoreSubEntities = new ArrayList<>();


    //是否自动入库 是否自动入库(1:是，0：否)
    @TableField(value = "auto_store_flag")
    private Boolean autoStoreFlag;
    /**
     * 调入仓库id
     */
    @TableField(value = "in_store_id")
    private Long inStoreId;

    @TableField(value = "psrm_returncode")
    private String psrmReturncode; // 数据中台状态

    @TableField(value = "psrm_code")
    private String psrmCode; // 数据中台编码

    @TableField(value = "psrm_returndata")
    private String psrmReturndata; // 数据中台返回数据

    public String getPsrmReturncode() {
        return psrmReturncode;
    }

    public void setPsrmReturncode(String psrmReturncode) {
        this.psrmReturncode = psrmReturncode;
    }

    public String getPsrmCode() {
        return psrmCode;
    }

    public void setPsrmCode(String psrmCode) {
        this.psrmCode = psrmCode;
    }

    public String getPsrmReturndata() {
        return psrmReturndata;
    }

    public void setPsrmReturndata(String psrmReturndata) {
        this.psrmReturndata = psrmReturndata;
    }

    public Long getInStoreId() {
        return inStoreId;
    }

    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }

    public Boolean getAutoStoreFlag() {
        return autoStoreFlag;
    }

    public void setAutoStoreFlag(Boolean autoStoreFlag) {
        this.autoStoreFlag = autoStoreFlag;
    }

    public Long getStraightInId() {
        return straightInId;
    }

    public void setStraightInId(Long straightInId) {
        this.straightInId = straightInId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectFlag() {
        return projectFlag;
    }

    public void setProjectFlag(String projectFlag) {
        this.projectFlag = projectFlag;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }

    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutMoney() {
        return outMoney;
    }

    public void setOutMoney(BigDecimal outMoney) {
        this.outMoney = outMoney;
    }

    public BigDecimal getOutMoneyNoTax() {
        return outMoneyNoTax;
    }

    public void setOutMoneyNoTax(BigDecimal outMoneyNoTax) {
        this.outMoneyNoTax = outMoneyNoTax;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    public Long getInProjectId() {
        return inProjectId;
    }

    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    public Long getInOrgId() {
        return inOrgId;
    }

    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }

    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }

    public String getInBelongToProject() {
        return inBelongToProject;
    }

    public void setInBelongToProject(String inBelongToProject) {
        this.inBelongToProject = inBelongToProject;
    }

    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }

    public String getReceivePerson() {
        return receivePerson;
    }

    public void setReceivePerson(String receivePerson) {
        this.receivePerson = receivePerson;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Long getNoticeToReceive() {
        return noticeToReceive;
    }

    public void setNoticeToReceive(Long noticeToReceive) {
        this.noticeToReceive = noticeToReceive;
    }

    public BigDecimal getMoneyDisparity() {
        return moneyDisparity;
    }

    public void setMoneyDisparity(BigDecimal moneyDisparity) {
        this.moneyDisparity = moneyDisparity;
    }

    public List<OutStoreSubEntity> getOutStoreSubEntities() {
        return outStoreSubEntities;
    }

    public void setOutStoreSubEntities(List<OutStoreSubEntity> outStoreSubEntities) {
        this.outStoreSubEntities = outStoreSubEntities;
    }

    public Integer getSettlementFlag() {
        return settlementFlag;
    }

    public void setSettlementFlag(Integer settlementFlag) {
        this.settlementFlag = settlementFlag;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getCarNumber() {
        return carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }
}
