package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.pub.AssignState;
import com.ejianc.business.material.pub.TaskState;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.service.IUseApplySubService;
import com.ejianc.business.material.utlis.ArchivesUtil;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IBrandApi;
import com.ejianc.foundation.share.vo.BrandVO;
import com.ejianc.foundation.share.vo.MaterialInsertArchiveVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/6 用料申请控制器
 * @Description UseApplyController
 */

@Controller
@RequestMapping("/apply/")
public class UseApplyController implements Serializable {


    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final long serialVersionUID = 2779265683203439571L;
    private static final String BILL_CODE = "materialUseApply";

    @Autowired
    IUseApplyService iUseApplyService;
    @Autowired
    IUseApplySubService iUseApplySubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBrandApi brandApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ArchivesUtil archivesUtil;
    //用料申请单表体为空是否可保存 1是2否
    private static final String PARAM_USE_APPLY = "P-J2u0z870";
    @Autowired
    private IParamConfigApi paramConfigApi;

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/queryLastApply", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> queryLastApply(Long projectId) {
        LambdaQueryWrapper<UseApplyEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(UseApplyEntity::getProjectId, projectId);
        wrapper.orderByDesc(UseApplyEntity::getCreateTime);
        wrapper.last("limit 1");
        List<UseApplyEntity> list = iUseApplyService.list(wrapper);
        UseApplyVO vo = null;
        if(CollectionUtils.isNotEmpty(list)){
            vo = BeanMapper.map(list.get(0), UseApplyVO.class);
        }
        return CommonResponse.success("查询详情数据成功！",  vo);
    }

    /**
     * @description: 根据用料申请明细联查采购订单明细
     *
     * @param applyDetailId 用料申请明细id
     * @return {@link List< PurchaseOrderDetailVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    @RequestMapping(value = "/queryPurchaseOrderDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PurchaseOrderDetailVO>> queryAssignDetail(@RequestParam Long applyDetailId) {
        List<PurchaseOrderDetailVO> list = iUseApplyService.queryAssignDetail(applyDetailId);
        return CommonResponse.success("查询数据成功！", list);
    }

    /**
     * @description: 根据用料申请明细or采购订单明细联查收料入库明细
     *
     * @param applyDetailId 用料申请明细id
     * @param purchaseOrderDetailId 采购订单明细id
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    @RequestMapping(value = "/queryInstoreMaterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<InstoreMaterialVO>> queryInstoreMaterial(@RequestParam(required = false) Long applyDetailId, @RequestParam(required = false) Long purchaseOrderDetailId) {
        List<InstoreMaterialVO> list = iUseApplyService.queryInstoreMaterial(applyDetailId, purchaseOrderDetailId);
        return CommonResponse.success("查询数据成功！", list);
    }


    /**
     * @description: 查询任务分配详情
     *
     * @param id
     * @return {@link CommonResponse< UseApplyVO>}
     * @author songlx
     * @date: 2024/6/14
     */
    @RequestMapping(value = "/queryAssignDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> queryAssignDetail(@RequestParam Long id,
                                                        @RequestParam(required = false) String taskState) {
        UseApplyEntity entity = iUseApplyService.getById(id);
        // 查询待分配
        LambdaQueryWrapper<UseApplySubEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(UseApplySubEntity::getPid, id);
        queryWrapper.eq(taskState != null, UseApplySubEntity::getTaskState, taskState);
        List<UseApplySubEntity> useApplySubEntities = iUseApplySubService.list(queryWrapper);
        entity.setUseApplySubEntities(useApplySubEntities);
        UseApplyVO vo = BeanMapper.map(entity, UseApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @description: 采购订单下达详情
     *
     * @param id
     * @param receiverId
     * @return {@link CommonResponse< UseApplyVO>}
     * @author songlx
     * @date: 2024/6/14
     */
    @RequestMapping(value = "/queryBookOrderDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> queryBookOrderDetail(@RequestParam Long id, @RequestParam Long receiverId, @RequestParam(required = false) String taskState) {
        UseApplyEntity entity = iUseApplyService.getById(id);
        LambdaQueryWrapper<UseApplySubEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(UseApplySubEntity::getPid, id);
        queryWrapper.eq(UseApplySubEntity::getReceiverId, receiverId);
        boolean isUnOrderFlag = taskState != null && TaskState.已分配.getCode().equals(taskState);
        // 查询已分配、待下单
        if (isUnOrderFlag) {
            queryWrapper.apply("apply_num > IFNULL(sum_book_num,0)");
        }
        List<UseApplySubEntity> useApplySubEntities = iUseApplySubService.list(queryWrapper);
        List<UseApplySubVO> useApplySubVOList = BeanMapper.mapList(useApplySubEntities, UseApplySubVO.class);
        for (UseApplySubVO useApplySub : useApplySubVOList) {
            useApplySub.setSurplusApplyNum(ComputeUtil.safeSub(useApplySub.getApplyNum(), useApplySub.getSumBookNum()));
            // 待下单，订单数量默认剩余申请数量
            if (isUnOrderFlag) {
                useApplySub.setOrderNum(useApplySub.getSurplusApplyNum());
            } else {
                useApplySub.setOrderNum(useApplySub.getSumBookNum());
            }
        }
        UseApplyVO vo = BeanMapper.map(entity, UseApplyVO.class);
        vo.setUseApplySubEntities(useApplySubVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    /**
     * @description: 采购任务分配列表-非零星采购
     * @return {@link CommonResponse< IPage< UseApplyVO>>}
     * @author songlx
     * @date: 2024/6/14
     */
    @RequestMapping(value = "/queryAssignList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UseApplyVO>> queryAssignList(@RequestBody QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        params.put("purchaseManagerId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        params.put("sporadicMaterialFlag", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
      /*  Parameter assignStatePara = params.get("assignState");
        params.remove("assignState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if (assignStatePara != null && "1".equals(assignStatePara.getValue().toString())) {
            wrapper.apply("unassignNum = 0");
        } else {
            // 默认查询待分配：下单明细数小于任务数
            wrapper.apply("unassignNum > 0");
        }
*/
        IPage<UseApplyVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        List<UseApplyVO> list = iUseApplyService.queryOrderIssuanceList(pageData, wrapper, null, Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @description: 采购任务下达列表 orderFlag : 待下单标识 0 待下单 1已下单
     * @return {@link CommonResponse< IPage< UseApplyVO>>}
     * @author songlx
     * @date: 2024/6/14
     */
    @RequestMapping(value = "/queryOrderIssuanceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UseApplyVO>> queryOrderIssuanceList(@RequestBody QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        params.put("sporadicMaterialFlag", new Parameter(QueryParam.EQ, 0));
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            params.put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            params.put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Parameter orderFlagPara = params.get("orderFlag");
        params.remove("orderFlag");
        QueryWrapper wrapper = changeToQueryWrapper(param);

        if (orderFlagPara != null && "1".equals(orderFlagPara.getValue().toString())) {
            wrapper.apply("taskNum = taskBookNum");
        } else {
            // 默认查询待下单：下单明细数小于任务数
            wrapper.apply("taskNum > taskBookNum");
        }

        IPage<UseApplyVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
        List<UseApplyVO> list = iUseApplyService.queryOrderIssuanceList(pageData, wrapper, Long.valueOf(InvocationInfoProxy.getEmployeeId()), null);
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);

    }


    /**
     * @Author 分配采购人员
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/saveOrUpdateAssign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UseApplyVO> saveOrUpdateAssign(@RequestBody UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            List<UseApplySubEntity> useApplySubEntityList = BeanMapper.mapList(useApplySubEntities, UseApplySubEntity.class);
            for (UseApplySubEntity useApplySubEntity : useApplySubEntityList) {
                if (useApplySubEntity.getReceiverId() != null) {
                    useApplySubEntity.setTaskState(TaskState.已分配.getCode());
                    // 如果是二次分配
                    useApplySubEntity.setExpectArriveDate(null);
                }
            }
            boolean b = iUseApplySubService.saveOrUpdateBatch(useApplySubEntityList);
            if (b) {
                List<UseApplySubVO> useApplySubVOList = BeanMapper.mapList(useApplySubEntities, UseApplySubVO.class);
                vo.setUseApplySubEntities(useApplySubVOList);

                Long applyId = vo.getId();
                UseApplyEntity entity = iUseApplyService.selectById(applyId);
                String receiverIds = null;
                List<UseApplySubEntity> subEntities = entity.getUseApplySubEntities();
                if (CollectionUtils.isNotEmpty(subEntities)) {
                    List<String> receIds = subEntities.stream().filter(t -> t.getReceiverId() != null).map(t -> String.valueOf(t.getReceiverId())).distinct().collect(Collectors.toList());
                    receiverIds = CollectionUtils.isNotEmpty(receIds) ? String.join(",", receIds) : null;
                }

                LambdaQueryWrapper<UseApplySubEntity> queryWrapper = Wrappers.lambdaQuery();
                queryWrapper.eq(UseApplySubEntity::getPid, applyId);
                queryWrapper.eq(UseApplySubEntity::getTaskState, TaskState.待分配.getCode());
                int unAssignCount = iUseApplySubService.count(queryWrapper);
                // 更新是否已分配标识，unAssignCount未分配为0就是已分配
                LambdaUpdateWrapper<UseApplyEntity> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.eq(UseApplyEntity::getId, applyId);
                updateWrapper.set(UseApplyEntity::getAssignState, unAssignCount == 0 ? AssignState.已分配.getCode() : AssignState.待分配.getCode());
                updateWrapper.set(UseApplyEntity::getReceiverIds, receiverIds);
                iUseApplyService.update(updateWrapper);

            }
        }
        return CommonResponse.success("操作成功！", vo);
    }


    /**
     * @param vo
     * @description: 获取物资的累计需用量\计划量
     */
    @RequestMapping(value = "/getSumNumCommon", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UseApplyVO> getSumNumCommon(@RequestBody UseApplyVO vo) {
        return iUseApplyService.getSumNumCommon(vo);
    }

    /***
     * @description: 参数校验
     * @param vo
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.ParamsCheckVO>
     * @author xuannl
     * @date: 2022/1/14
     */
    @RequestMapping(value = "/checkAllParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkAllParams(@RequestBody UseApplyVO vo) {
        ParamsCheckVO paramsCheckVO = iUseApplyService.checkAllParams(vo);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/1  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UseApplyVO> saveOrUpdate(@RequestBody UseApplyVO vo) {
        archivesUtil.checkHaveTempMaterial(vo.getUseApplySubEntities());
        vo.setIsExceed(0);
        if (CollectionUtils.isNotEmpty(vo.getUseApplySubEntities())) {
            iUseApplyService.setIsExceed(vo);
        }
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_USE_APPLY);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            List<UseApplySubVO> collect = vo.getUseApplySubEntities().stream().filter(d -> !"del".equals(d.getRowState())).collect(Collectors.toList());
            if ("2".equals(valueData) && collect.size() == 0) {
                throw new BusinessException("请录入材料清单!");
            }
        }
        UseApplyEntity entity = BeanMapper.map(vo, UseApplyEntity.class);

        String billCode = entity.getBillCode();
        //用料申请编号可以自动录入。录入则需要校验编号重复
        if (StringUtils.isNotBlank(billCode)) {
            Long id = entity.getId();
            LambdaQueryWrapper<UseApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(UseApplyEntity::getTenantId, InvocationInfoProxy.getTenantid());
            queryWrapper.eq(UseApplyEntity::getBillCode, billCode);
            queryWrapper.ne(id != null, UseApplyEntity::getId, id);
            int count = iUseApplyService.count(queryWrapper);
            if (count > 0) {
                throw new BusinessException("保存失败，单据编码重复");
            }

        } else {
            CommonResponse<String> billCodeRes = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCodeRes.isSuccess()) {
                entity.setBillCode(billCodeRes.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //申请单名称为空时，默认格式为申请人+申请时间+“需求申请”
        if (StringUtils.isBlank(entity.getName())) {
            SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd");
            String name = entity.getApplyPerson() + format.format(entity.getApplyDate()) + "需求申请";
            entity.setName(name);
        }
        if (entity.getPurchaseTypeId() != null) {
            CommonResponse<DefdocDetailVO> defDocById = defdocApi.getDefDocById(entity.getPurchaseTypeId());
            if (defDocById.isSuccess() && defDocById.getData() != null) {
                DefdocDetailVO data = defDocById.getData();
                entity.setPurchaseTypeCode(data.getCode());
                entity.setPurchaseTypeName(data.getName());
            }
        }
        long id = IdWorker.getId();
        if (entity.getId() == null) {
            entity.setId(id);
        }
        if (CollectionUtils.isNotEmpty(vo.getUseApplySubEntities())) {

            List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
            for (UseApplySubVO useApplySubVO : useApplySubEntities) {
                String onlykey = useApplySubVO.getMaterialTypeName() + useApplySubVO.getMaterialName() + useApplySubVO.getUnit() + useApplySubVO.getModel() + useApplySubVO.getMaterialCode();
                useApplySubVO.setOnlyKey(onlykey);
            }
            MaterialInsertArchiveVO archiveVO = new MaterialInsertArchiveVO(null, entity.getId(), entity.getBillCode(), entity.getProjectName(),"用料申请");
            JSONObject jsonObject = archivesUtil.batchSaveArchive(archiveVO, useApplySubEntities, "materialTypeId", "materialId",
                    "materialTypeName", "materialName", "materialCode", "unit", "model", "errorMessage");
            String sourceList = JSON.toJSONString(jsonObject.get("sourceList"), SerializerFeature.WriteMapNullValue, SerializerFeature.PrettyFormat);
            List<UseApplySubVO> list = JSONObject.parseArray(sourceList, UseApplySubVO.class);
            List<UseApplySubEntity> useApplySubEntities1 = BeanMapper.mapList(list, UseApplySubEntity.class);
            entity.setUseApplySubEntities(useApplySubEntities1);
        }
        entity.setPurchaseFlag(0);
        entity.setAssignState(Optional.ofNullable(entity.getAssignState()).orElse(AssignState.待分配.getCode()));
        iUseApplyService.saveOrUpdate(entity, false);
        UseApplyVO backVo = BeanMapper.map(entity, UseApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", backVo);
    }

    @RequestMapping(value = "/updatePurchaseFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> updatePurchaseFlag(Long id, Integer purchaseFlag) {
        iUseApplyService.updatePurchaseFlag(id, purchaseFlag);
        return CommonResponse.success("修改成功！");
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.UseApplyVO>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UseApplyVO> queryDetail(Long id) {
        UseApplyEntity entity = iUseApplyService.selectById(id);
        UseApplyVO vo = BeanMapper.map(entity, UseApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UseApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        return CommonResponse.success("查询列表数据成功！", iUseApplyService.queryForList(param, false));
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("UseApply", iUseApplyService.selectById(id));
        return CommonResponse.success("查询打印数据成功！", json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UseApplyVO> vos) {
        iUseApplyService.removeByIds(vos.stream().map(UseApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<UseApplyVO> voPage = iUseApplyService.queryForList(queryParam, false);
        List<UseApplyVO> list = voPage.getRecords();
        List<UseApplyExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            UseApplyExportVO exportVO = BeanMapper.map(vo, UseApplyExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", vo.getCreateTime()));
            if (vo.getPlanEnterDate() != null) {
                exportVO.setPlanEnterDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getPlanEnterDate()));
            }
            //自由态
            if (vo.getBillState() == (BillStateEnum.UNCOMMITED_STATE.getBillStateCode())) {
                exportVO.setBillState("自由态");
            }
            //已提交

            if (vo.getBillState() == (BillStateEnum.COMMITED_STATE.getBillStateCode())) {
                exportVO.setBillState("已提交");
            }
            //审核中 审核中（有人审核）
            if (vo.getBillState() == (BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())) {
                exportVO.setBillState("审批中");
            }
            //已通过
            if (vo.getBillState() == (BillStateEnum.PASSED_STATE.getBillStateCode())) {
                exportVO.setBillState("审批通过");
            }
            //审批驳回
            if (vo.getBillState() == (BillStateEnum.UNAPPROVED.getBillStateCode())) {
                exportVO.setBillState("审批驳回");
            }
            //审核中(有审批流的提交态)
            if (vo.getBillState() == (BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())) {
                exportVO.setBillState("审批中");
            }
            if (vo.getEstimateMoney() != null) {
                exportVO.setEstimateMoney(vo.getEstimateMoney().setScale(2, BigDecimal.ROUND_HALF_UP));
            } else {
                exportVO.setEstimateMoney(new BigDecimal("0"));
            }
            if (vo.getSporadicMaterialFlag() == 0) {
                exportVO.setSporadicMaterialFlagName("否");
            } else {
                exportVO.setSporadicMaterialFlagName("是");
            }
            exportVOS.add(exportVO);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("useApplyListExport.xlsx", beans, response);
    }

    /**
     * 用料申请物资导出
     *
     * @param useApplyVO
     * @param response
     */
    @PostMapping("excelExportMaterialList")
    public void excelExportMaterialList(@RequestBody UseApplyVO useApplyVO, HttpServletResponse response) {
        UseApplyEntity entity = iUseApplyService.selectById(useApplyVO.getId());
        Map<String, Object> beans = new HashMap();
        List<UseApplySubVO> list = new ArrayList<>();
        List<UseApplySubEntity> data = entity.getUseApplySubEntities();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(item -> {
                UseApplySubVO vo = BeanMapper.map(item, UseApplySubVO.class);
                if (vo.getSubPlanEnterDate() != null) {
                    vo.setSubPlanEnterDateStr(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getSubPlanEnterDate()));
                }
                list.add(vo);
            });
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DateFormatUtil.PATTERN_ISO_ON_DATE);
        String planEnterDate = "";
        String applyDate = "";
        if (null != entity.getPlanEnterDate()) {
            planEnterDate = sdf.format(entity.getPlanEnterDate());
        }
        if (null != entity.getApplyDate()) {
            applyDate = sdf.format(entity.getApplyDate());
        }

        Long projectId = entity.getProjectId();
        if (projectId != null) {
            CommonResponse<ProjectRegisterVO> projectDetail = projectApi.queryProjectDetail(projectId);
            if (projectDetail.isSuccess() && projectDetail.getData() != null) {
                beans.put("projectCode", projectDetail.getData().getCode());
            }
        }

        beans.put("records", list);
        beans.put("entity", entity);
        beans.put("planEnterDate", planEnterDate);
        beans.put("applyDate", applyDate);
        ExcelExport.getInstance().export("useApplySubExport.xlsx", beans, response);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/12  用料申请参照树
     * @Description referTree
     * @Param [pageNumber, pageSize]
     * @Return java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     */
    @RequestMapping(value = "/referTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                               @RequestParam String condition
    ) {
        if (StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<UseApplyEntity> dataList = iUseApplyService.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (UseApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
            List<UseApplySubEntity> useApplySubEntities = iUseApplyService.queryApplySubList(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(useApplySubEntities)) {
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName() + "-" + entity.getBillCode());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/12 用料申请子表参照数据
     * @Description refdata
     * @Param [pageNumber, pageSize, relyCondition, relyNode, searchText]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.material.vo.UseApplySubVO>>
     */
    @RequestMapping(value = "/refSubData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refdata(@RequestParam Integer pageNumber,
                                                        @RequestParam Integer pageSize,
                                                        String relyCondition,
                                                        @RequestParam(required = false) String condition,
                                                        String relyNode,
                                                        String searchText,
                                                        @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map<String, Parameter> param = queryParam.getParams();
        //是否查询全部申请合计
        boolean queryAllFlag = false;
        if (!StringUtils.isEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }

        } else {
            throw new BusinessException("请选择申请单！");
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
    		/*if(search.get("materialTypeName")!=null){
    			queryParam.getParams().put("materialTypeName",new Parameter(QueryParam.LIKE,search.get("materialTypeName").toString()));
    		}
    		if(search.get("materialName")!=null){
    			queryParam.getParams().put("materialName",new Parameter(QueryParam.LIKE,search.get("materialName").toString()));
    		}
    		if(search.get("model")!=null){
    			queryParam.getParams().put("model",new Parameter(QueryParam.LIKE,search.get("model").toString()));
    		}
    		if(search.get("unit")!=null){
    			queryParam.getParams().put("unit",new Parameter(QueryParam.LIKE,search.get("unit").toString()));
    		}*/
        }

        IPage<UseApplySubEntity> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            JSONObject conditionJson = JSONObject.parseObject(condition);
            Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
            Long projectId = conditionJson.getLong("projectId");
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter(QueryParam.GT, 0));
            list = iUseApplyService.queryAllApplyData(pageData, queryParam, projectId);
        } else {
            list = iUseApplyService.queryApplySubList(pageData, queryParam);
        }

        IPage<UseApplySubVO> voPage = null;
        if (pageData != null) {
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }


    /**
     * @description: 用料申请参照-采购订单使用
     *
     * @return {@link CommonResponse< IPage< UseApplySubVO>>}
     * @author songlx
     * @date: 2023/4/19
     */
    @RequestMapping(value = "/referTreeForPurchaseOrder", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTreeForPurchaseOrder(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               @RequestParam String condition
    ) {
        if (StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<UseApplyEntity> dataList = iUseApplyService.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (UseApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
            List<UseApplySubEntity> useApplySubEntities = iUseApplyService.queryApplySubListForPurchaseOrder(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(useApplySubEntities)) {
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", "000001");
            resultMapList.add(map);
        }
        if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }

        return ResultAsTree.createTreeData(resultMapList);
    }


    /**
     * @description: 用料申请明细参照-采购订单使用
     *
     * @param pageNumber
     * @param pageSize
     * @param relyCondition
     * @param condition
     * @param relyNode
     * @param searchText
     * @param searchObject
     * @return {@link CommonResponse< IPage< UseApplySubVO>>}
     * @author songlx
     * @date: 2023/4/19
     */
    @RequestMapping(value = "/refSubDataForPurchaseOrder", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refSubDataForPurchaseOrder(@RequestParam Integer pageNumber,
                                                                           @RequestParam Integer pageSize,
                                                                           @RequestParam(required = false) String relyCondition,
                                                                           @RequestParam(required = false) String condition,
                                                                           @RequestParam(required = false) String relyNode,
                                                                           @RequestParam(required = false) String searchText,
                                                                           @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map<String, Parameter> param = queryParam.getParams();

        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
        Long projectId = conditionJson.getLong("projectId");

        //是否查询全部申请合计
        boolean queryAllFlag = false;
        if (StringUtils.isNotEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            //移动端用料申请子表列表查询时没有pid则根据项目过滤
            param.put("projectId", new Parameter(QueryParam.EQ, projectId));
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        IPage<UseApplySubEntity> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter(QueryParam.GT, 0));
            list = iUseApplyService.queryAllApplyDataForPurchaseOrder(pageData, queryParam, projectId);
        } else {
            list = iUseApplyService.queryApplySubListForPurchaseOrder(pageData, queryParam);
        }

        IPage<UseApplySubVO> voPage = null;
        if (pageData != null) {
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }

    /**
     * @description: 用料申请参照-入库单使用
     *
     */
    @RequestMapping(value = "/referTreeForInstore", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> referTreeForInstore(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         @RequestParam String condition
    ) {
        if (StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }

        // 是否零星材料
        if(conditionJson.containsKey("sporadicMaterialFlag")){
            queryParam.getParams().put("sporadicMaterialFlag", new Parameter(QueryParam.EQ, conditionJson.getInteger("sporadicMaterialFlag")));
        }

        queryParam.setOrderMap(orderMap);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 参数组织orgId本下 */
        queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<UseApplyEntity> dataList = iUseApplyService.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<>();
        Map map = null;
        for (UseApplyEntity entity : dataList) {
            QueryParam queryApplySubParam = new QueryParam();
            queryApplySubParam.getParams().put("pid", new Parameter(QueryParam.EQ, entity.getId()));
            List<UseApplySubEntity> useApplySubEntities = iUseApplyService.queryApplySubListForInstore(null, queryApplySubParam);
            if (CollectionUtils.isEmpty(useApplySubEntities)) {
                continue;
            }
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getBillCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
      /*  if (CollectionUtils.isNotEmpty(resultMapList)) {
            map = new HashMap<>();
            map.put("id", "000001");
            map.put("extdata", null);
            map.put("isLeaf", false);
            map.put("selectable", true);
            map.put("key", "000001");
            map.put("name", "全部");
            map.put("code", "000001");
            map.put("parentId", null);
            resultMapList.add(map);
        }*/

        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @description: 用料申请明细参照-入库单使用
     *
     */
    @RequestMapping(value = "/refSubDataForInstore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> refSubDataForInstore(@RequestParam Integer pageNumber,
                                                                     @RequestParam Integer pageSize,
                                                                     @RequestParam(required = false) String relyCondition,
                                                                     @RequestParam(required = false) String condition,
                                                                     @RequestParam(required = false) String relyNode,
                                                                     @RequestParam(required = false) String searchText,
                                                                     @RequestParam(required = false) String searchObject) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("model");
        fuzzyFields.add("unit");
        Map<String, Parameter> param = queryParam.getParams();

        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId") != null ? conditionJson.getLong("orgId") : InvocationInfoProxy.getOrgId();
        Long projectId = conditionJson.getLong("projectId");

        //是否查询全部申请合计
        boolean queryAllFlag = false;
        if (StringUtils.isNotEmpty(relyCondition)) {
            String pid = relyCondition.split("=")[1];
            if (!"000001".equals(pid)) {
                param.put("pid", new Parameter(QueryParam.EQ, pid));
            } else {
                queryAllFlag = true;
            }
        } else {
            //移动端用料申请子表列表查询时没有pid则根据项目过滤
            param.put("projectId", new Parameter(QueryParam.EQ, projectId));
        }

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                queryParam.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        IPage<UseApplySubEntity> pageData = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
        List<UseApplySubEntity> list = null;
        if (queryAllFlag) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            queryParam.getParams().put("applyNum", new Parameter(QueryParam.GT, 0));
            list = iUseApplyService.queryAllApplyDataForInstore(pageData, queryParam, projectId);
        } else {
            list = iUseApplyService.queryApplySubListForInstore(pageData, queryParam);
        }

        IPage<UseApplySubVO> voPage = null;
        if (pageData != null) {
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(list, UseApplySubVO.class));
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }

    //申请子表参照数据 查询全部的数据
    @RequestMapping(value = "/referTable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UseApplySubVO>> referTable(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                           String condition, String searchText
    ) {
        if (StringUtils.isEmpty(condition) || !condition.contains("orgId")) {
            throw new BusinessException("查询参数不正确！");
        }
        JSONObject conditionJson = JSONObject.parseObject(condition);
        Long orgId = conditionJson.getLong("orgId");
        Long projectId = conditionJson.getLong("projectId");
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("createTime", "desc");
        if (null != projectId) {
            queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        }
        // 是否零星材料
        if(conditionJson.containsKey("sporadicMaterialFlag")){
            queryParam.getParams().put("sporadicMaterialFlag", new Parameter(QueryParam.EQ, conditionJson.getInteger("sporadicMaterialFlag")));
        }
        queryParam.setOrderMap(orderMap);
        queryParam.setSearchText(searchText);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("applyPerson");
        /** 数据隔离 参数组织orgId本下 */
        CommonResponse<List<OrgVO>> childrenByParentId = iOrgApi.findChildrenByParentId(orgId);
        if (CollectionUtils.isNotEmpty(childrenByParentId.getData())) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, childrenByParentId.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 已提交的数据 或者 审批通过的数据 */
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<UseApplyEntity> dataList = iUseApplyService.queryList(queryParam, false);
        IPage<UseApplySubVO> voPage = null;
        if (CollectionUtils.isNotEmpty(dataList)) {
            //子表查询参数
            QueryParam SubParam = new QueryParam();
            List<Long> Ids = dataList.stream().map(UseApplyEntity::getId).collect(Collectors.toList());
            Map<Long, String> collect = dataList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getBillCode()));
            SubParam.getParams().put("pid", new Parameter(QueryParam.IN, Ids));
            SubParam.setPageIndex(pageNumber);
            SubParam.setPageSize(pageSize);
            IPage<UseApplySubEntity> pageData = iUseApplySubService.queryPage(SubParam, false);
            if (pageData != null) {
                voPage = new Page<>();
                voPage.setCurrent(pageData.getCurrent());
                voPage.setPages(pageData.getPages());
                voPage.setTotal(pageData.getTotal());
                voPage.setSize(queryParam.getPageSize());
                List<UseApplySubVO> useApplySubVOS = BeanMapper.mapList(pageData.getRecords(), UseApplySubVO.class);
                for (UseApplySubVO vo : useApplySubVOS) {
                    vo.setBillCode(collect.get(vo.getPid()));
                }
                voPage.setRecords(useApplySubVOS);
            }
        }
        return CommonResponse.success("查询数表参照成功", voPage);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "apply-material-import-no-price.xlsx", "物料导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportUseApplySubVO> successList = new ArrayList<>();
            List<ImportUseApplySubVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ImportUseApplySubVO useApplySubVO = new ImportUseApplySubVO();
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(0))) {
                        useApplySubVO.setErrorMessage("物资分类名称为必填项");
                    } else {
                        useApplySubVO.setMaterialTypeName(datas.get(0).trim());
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(1))) {
                        useApplySubVO.setErrorMessage("物资名称为必填项");
                    } else if (datas.get(1).length() > 20) {
                        useApplySubVO.setErrorMessage("物资名称填写长度为0~20字");
                    } else {
                        useApplySubVO.setMaterialName(datas.get(1).trim());
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(2))) {
                        useApplySubVO.setErrorMessage("规格型号为必填项");
                    } else if (datas.get(2).length() > 200) {
                        useApplySubVO.setErrorMessage("规格型号填写长度为0~200字");
                    } else {
                        useApplySubVO.setModel(datas.get(2).trim());
                    }
                    if (StringUtils.isNotEmpty(datas.get(3))) {
                        useApplySubVO.setUnit(datas.get(3).trim());
                    }

                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(4)) && datas.get(4).length() > 64) {
                        useApplySubVO.setErrorMessage("物料编码填写长度为0~64字");
                    } else {
                        useApplySubVO.setMaterialCode(datas.get(4));
                    }

                    //品牌
                    String brandName = datas.get(5);
                    if (StringUtils.isBlank(brandName)) {
                        useApplySubVO.setBrandId(null);
                        useApplySubVO.setBrandName(null);
                    } else {
                        brandName = brandName.trim();
                        useApplySubVO.setBrandName(brandName);
                        if (brandName.length() > 64) {
                            useApplySubVO.setErrorMessage("品牌填写长度为0~64字");
                        } else {
                            CommonResponse<BrandVO> brandVOCommonResponse = brandApi.queryBrandByName(brandName);
                            if (brandVOCommonResponse.isSuccess() && brandVOCommonResponse.getData() != null) {
                                BrandVO brandVO = brandVOCommonResponse.getData();
                                useApplySubVO.setBrandId(brandVO.getId());
                            } else {
                                useApplySubVO.setErrorMessage("品牌不存在！");
                            }
                        }
                    }

                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            useApplySubVO.setApplyNum(new BigDecimal(datas.get(6)));
                            if (useApplySubVO.getApplyNum().longValue() < 0) {
                                useApplySubVO.setErrorMessage("申请数量必须大于0");
                            }
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("申请数量必须为数字");
                        }
                    }
                    String subPlanEnterDate = datas.get(7);
                    if (StringUtils.isNotBlank(subPlanEnterDate)) {
                        try {
                            SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                            ft.parse(subPlanEnterDate);
                            useApplySubVO.setSubPlanEnterDate(subPlanEnterDate);
                        } catch (Exception e) {
                            useApplySubVO.setErrorMessage("计划进场日期格式有误，例如2022-01-01");
                        }
                    }
                    String memo = datas.get(8);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(memo) && memo.length() > 200) {
                        useApplySubVO.setErrorMessage("备注填写长度为0~200字");
                    } else {
                        useApplySubVO.setMemo(memo);
                    }

                    if (StringUtils.isNotEmpty(useApplySubVO.getErrorMessage())) {
                        errorList.add(useApplySubVO);
                    } else {
                        String onlykey = useApplySubVO.getMaterialTypeName() + useApplySubVO.getMaterialName() + useApplySubVO.getUnit() + useApplySubVO.getModel();
                        useApplySubVO.setOnlyKey(onlykey);
                        successList.add(useApplySubVO);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(successList)) {
                JSONObject match = archivesUtil.findMatch(successList, "materialTypeId", "materialId",
                        "materialTypeName", "materialName", "materialCode", "unit", "model", "errorMessage");
                successList = (List<ImportUseApplySubVO>) match.get("sourceList");
                List<ImportUseApplySubVO> errorList1 = (List<ImportUseApplySubVO>) match.get("errorList");
                errorList.addAll(errorList1);
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
