package com.ejianc.business.material.service;

import com.ejianc.business.bidprice.material.vo.MaterialPicketageVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.foundation.share.service.IPSRMDataService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 *
 * 物资合同数据处理服务接口
 *
 * @author CJ
 */
public interface IMaterialContractService extends IBaseService<MaterialContractEntity>, IPSRMDataService<MaterialContractVO> {

    List<MaterialContractVO> queryContractTaxWarnContract(List<SqlParam> sqlParamList);
    /**
    　* @Description: 物资合同保存更新
    　* @param [materialContractVO]
    　* @return com.ejianc.business.material.vo.MaterialContractVO
    　* @throws
    　* @author CJ
    　* @date 2020/6/8 11:08
    　*/
    MaterialContractVO save(MaterialContractVO materialContractVO);

    /**
    　* @Description: 统计页面原合同总金额，现合同总金额
    　* @param [queryParam]
    　* @return java.util.Map<java.lang.String,java.math.BigDecimal>
    　* @throws
    　* @author CJ
    　* @date 2020/6/8 11:28
    　*/
    Map<String, Object> countContractAmount(QueryParam queryParam);

    /**
    　* @Description: 合同编码重复校验
    　* @param [id, code]
    　* @return boolean
    　* @throws
    　* @author CJ
    　* @date 2020/6/16 16:13
    　*/
    boolean codeCheck(Long id, String code);

    void checkContract(Long id);

    /**
     * 查询所有满足预警条件的项目合同
     *
     * @param sqlParamList
     * @return
     */
    List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList);

    List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds);

    List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay);

    MaterialReportVo getMaterialContract(Long projectId);

    List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds);

    List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds);


    /***
     * @description: 根据项目id查询该项目物资总计划明细价格\物资结算价格区间
     *
     * @param vo
     * @return: com.ejianc.business.material.vo.MaterialPriceVO
     * @author songlx
     * @date: 2021-05-26
     */
    MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo);

    ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo);

    /**
     * 按项目维度，获取合同金额(含税)
     *
     * @param projectId 项目id
     *
     * @return {@link BigDecimal}
     */
    BigDecimal fetchAmountWithTax(Long projectId);

    /**
     * @param enquiryPriceBillId
     *
     * @return {@link MaterialPicketageVO}
     *
     * @description: 根据定标单溶剂已签合同数量和金额
     * @author songlx
     * @date: 2023/2/10
     */
    MaterialPicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillId);

    BigDecimal fetchSjzcje(Long projectId);

    CommonResponse<String> onFile(OtherContractVO contractVO);

    Map<Long, List<MaterialContractPriceResultVO>> queryMaterialContractPrice(MaterialContractPriceQueryVO queryVO);

    Map<String, BigDecimal> purchaseInfo();

    List<Map<String, Object>> supplierTop();

    List<Map<String, Object>> financeData();

    List<Map<String, Object>> efficiencyManagement();

    Map<String, BigDecimal> storeMny();

    Map<String, BigDecimal> performanceStatus(String startDate, String endDate);
}
