package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.mapper.InstoreMapper;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class InstoreService  extends BaseServiceImpl<InstoreMapper, InstoreEntity> implements IInstoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInstoreMaterialService materialService;

    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;

    @Autowired
    private IMaterialContractService contractService;

    @Autowired
    private PSRMRestUtil psrmRestUtil;

    @Autowired
    private IStoreService storeService;


    @Override
    public IPage<InstoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<InstoreVO> voPage = null;
        IPage<InstoreEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),InstoreVO.class));
        }
        return voPage;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReceive(InstoreEntity entity) {
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }

        entity.getInstoreMaterialList().forEach(e->{
            e.setStoreId(entity.getStoreId());
            e.setStoreState(MaterialStoreState.STORED.getCode());
        });
        if (psrmRestUtil.isRunMode()) {
            // 调拨入库 如果是公司仓库与项目仓库的调拨的数据
            Long outStoreId = entity.getOutStoreId();
            StoreEntity outStore = storeService.getById(outStoreId);

            Long inStoreId = entity.getStoreId();
            StoreEntity inStore = storeService.getById(inStoreId);
            if ("2".equals(outStore.getProjectType()) && "1".equals(inStore.getProjectType())) {
                PSRMResponse resp = this.saveOrUpdateAllotPsrmObj(BeanMapper.map(entity, InstoreVO.class), null, null);
                LambdaUpdateWrapper<InstoreEntity> updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.eq(InstoreEntity::getId, entity.getId());
                updateWrapper.set(InstoreEntity::getPsrmCode, resp.getPsrmCode());
                updateWrapper.set(InstoreEntity::getPsrmReturncode, resp.getReturncode());
                updateWrapper.set(InstoreEntity::getPsrmReturndata, JSONObject.toJSONString(resp));
                this.update(updateWrapper);
                if (!resp.isSuccess()) {
                    throw new BusinessException("数据中台操作失败" + JSONObject.toJSONString(resp));
                }
            }
        }

        super.saveOrUpdate(entity,false);

        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.USED.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void sureToReturn(InstoreEntity entity) {
        super.saveOrUpdate(entity,false);
        OutStoreEntity outStoreEntity = iOutStoreService.selectById(entity.getOutId());
        if(outStoreEntity == null ){
            throw new BusinessException("没有找到对应调拨出库单，确认收料失败！");
        }
        outStoreEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        outStoreEntity.setReceiveState(entity.getReceiveState());
        outStoreEntity.setReceivePerson(entity.getReceivePerson());
        outStoreEntity.setReturnReason(entity.getPickReturnReason());
        outStoreEntity.getOutStoreSubEntities().forEach(o-> o.setStoreState(MaterialStoreState.OCCUPY.getCode()));
        iOutStoreService.saveOrUpdate(outStoreEntity,false);
    }

    @Override
    public void processCost(InstoreEntity entity) {
        String factor = "1";
        if(MaterialStoreType.RETURN_IN_STORE.getCode().equals(entity.getInstoreType())){
            factor = "-1";
        }
        if(ListUtil.isNotEmpty(entity.getInstoreMaterialList())){
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0;i<entity.getInstoreMaterialList().size();i++){
                InstoreMaterialEntity sub = entity.getInstoreMaterialList().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = new BigDecimal("1.00");
                    if ("-1".equals(factor)) {//物资退库
                        rate = rate.add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    } else {
                        rate = rate.add(entity.getTaxRate() == null ? new BigDecimal("0.00") : entity.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    }
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getInstoreDate());
                c.setMemo(entity.getNote());
                c.setCreateUserName(sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode(entity.getInstoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode(entity.getInstoreType()) + "_DETAIL");

                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate instoreDate = entity.getInstoreDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                c.setPeriod(instoreDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                c.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                c.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                if (Objects.equals(MaterialStoreType.RETURN_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.RETURN_IN_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickReturn/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                if (Objects.equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode(), sub.getInstoreType())) {
                    c.setSourceBillName(MaterialStoreType.STRAIGHT_IN_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/straightInout/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                c.setNum(sub.getInstoreNumber() == null ? BigDecimal.ZERO : sub.getInstoreNumber()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                c.setMaterialId(sub.getMaterialId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                c.setMaterialName(sub.getMaterialName()); // 物资名称
                c.setMaterialTypeId(sub.getMaterialCategoryId()); // 物资类别
                c.setMaterialTypeName(sub.getMaterialCategoryName()); // 物资类别名称
                c.setUnit(sub.getMaterialUnit()); // 单位名称
                // c.setUnitId(); // 单位主键
                c.setSpec(sub.getMaterialSpec()); // 规格型号

                list.add(c);
            }
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本" + MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType()) + "结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
            // if(canPush){
            //     CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            //     logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("1");
            // }else {
            //     CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            //     logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getInstoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("0");
            // }
        }else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public List<InstoreMaterialVO> instoreNumCount(Map<String, Object> queryParam) {
        return instoreMaterialMapper.instoreNumCount(queryParam);
    }

    @Override
    public List<InstoreAccountSumVO> amountSum(List<Long> projectIds) {
        return instoreMaterialMapper.amountSum(projectIds);
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper<InstoreEntity> query = changeToQueryWrapper(queryParam);
        query.select("sum(total_amount) as totalAmount");
        Map<String, Object> amount = super.getMap(query);
        return null != amount ? new BigDecimal(amount.get("totalAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public List<MaterialContractDetailSubEntity> totalResidualQuantity(List<MaterialContractDetailSubEntity> records ){
        Map<Long, MaterialContractDetailSubEntity> detailMap = records.stream().collect(Collectors.toMap(MaterialContractDetailSubEntity::getId, e -> e));
        List<Long> ids=new ArrayList(detailMap.keySet());
        //查询对应清单的入库数量
        QueryWrapper<InstoreMaterialEntity> query = new QueryWrapper<>();
        query.select("source_id as sourceId,sum(instore_number) as instoreNumber");
        query.eq("source_type","contractMaterial");
        query.in("source_id",ids);
        query.groupBy("source_id");
        List<InstoreMaterialEntity> list = materialService.list(query);
        if (CollectionUtils.isEmpty(list)){
            for (MaterialContractDetailSubEntity entity:records){
                entity.setResidualQuantity(entity.getCount());
            }
            return records;
        }
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(InstoreMaterialEntity::getSourceId, InstoreMaterialEntity::getInstoreNumber));
        for (Long id:ids){
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if (collect.containsKey(id)){
                bigDecimal= collect.get(id).compareTo(new BigDecimal(0E-8))==0?new BigDecimal(0):collect.get(id);;
            }
            MaterialContractDetailSubEntity detailSub = detailMap.get(id);
            if (bigDecimal.compareTo(detailSub.getCount())>-1){
                detailMap.remove(id);
            }else {
                detailSub.setResidualQuantity(detailSub.getCount().subtract(bigDecimal));
                detailMap.put(id,detailSub);
            }
        }
        Collection<MaterialContractDetailSubEntity> values = detailMap.values();
        return new ArrayList<>(values);
    }


    @Override
    public CommonResponse<String> updateInStoreSettleFlag(List<InstoreMaterialVO> vos){
        Map<String, List<InstoreMaterialVO>> groupList = vos.stream().collect(Collectors.groupingBy(InstoreMaterialVO::getSettleFlag));
        if (groupList.containsKey("1")){
            List<InstoreMaterialVO> settleTrueList = groupList.get("1");
            List<Long> settleTrueIds = settleTrueList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleTrueIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"1");
            materialService.update(wrapper);
        }
        if (groupList.containsKey("0")){
            List<InstoreMaterialVO> settleFalseList = groupList.get("0");
            List<Long> settleFalseIds = settleFalseList.stream().map(e -> e.getId()).collect(Collectors.toList());
            LambdaUpdateWrapper<InstoreMaterialEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.in(InstoreMaterialEntity::getId,settleFalseIds);
            wrapper.set(InstoreMaterialEntity::getSettleFlag,"0");
            materialService.update(wrapper);
        }
        return CommonResponse.success("保存或修改单据成功！","");
    }

    @Override
    public PSRMResponse saveOrUpdatePsrmObj(InstoreVO vo) {
        /*     请求参数
字段	类型	说明
f_synccode	string	单据编码（必录）
f_synccreator	string	创建人 （必录）
f_syncauditor	string	审核人 （必录）
f_status	string	单据状态 创建 S 审核 Y （必录）
f_date	datetime	业务日期（必录）
f_potype	string	采购类别（必录）
f_engineeringcode	string	工程项目编码
f_supplycode	string	供应商编码（必录）
f_postyle	string	采购方式 默认赊购：P002
f_contractcode	string	采购合同编号
f_explanation	string	摘要
f_smanagername	string	保管人名称（必录）
f_fmanagername	string	验收人名称（必录）
f_empname	string	业务员名称（必录）

*/
        String signDate = DateUtil.format(vo.getInstoreDate(), DateUtil.DATE);
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", vo.getBillCode());
        obj.put("f_status", "Y");
        obj.put("f_date", signDate);
        obj.put("f_potype", MaterialStoreType.getStoreTypeNameByCode(vo.getInstoreType()));

        if (vo.getProjectId() != null) {
            JSONArray jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getProjectId()), "market-project");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                obj.put("f_engineeringcode", json.getString("code"));
            }
        }

        try {
            if (vo.getSupplierId() != null) {
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getSupplierId()), "support-supplier");
                if (jArray != null && jArray.size() > 0) {
                    JSONObject json = (JSONObject) jArray.get(0);
                    obj.put("f_supplycode", json.getString("code"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getContractId() != null) {
            MaterialContractEntity contractEntity = contractService.getById(vo.getContractId());
            if (contractEntity != null) {
                obj.put("f_contractcode", contractEntity.getCode());
            }
        }
        obj.put("f_empname", vo.getEmployeeName());
        obj.put("f_synccreator", vo.getCreateUserName());
        UserContext userContext = sessionManager.getUserContext();
        obj.put("f_syncauditor", userContext.getUserName());
 /*
detail	array	明细
f_seq	int	行号（必录）
f_materialcode	string	物料编号（必录）
f_auxpropcode	string	辅助属性编码
f_batchno	string	批号
f_unit	string	单位
f_auxqtymust	decimal	应收数量
f_qty	decimal	实收数量（必录）
f_auxprice	decimal	单价
f_auxtaxprice	decimal	含税单价（必录）
f_amount	decimal	金额
f_cess	decimal	税率（%）
f_taxamount	decimal	税额
f_allamount	decimal	价税合计
f_note	string	备注
f_stockcode	string	收料仓库编码
f_chkpassitem	string	检验是否良品
f_projectnote	string	项目部备注
f_sourcebillno	string	K3WISE源单编号（采购订单单号）（必录）
f_sourceentryid	int	K3WISE源单行号（采购订单行号）（必录）
f_sourcetrantype	string	K3WISE源单类型 默认 采购订单（必录）
f_contractbillno	string	合同单号
f_contractentryid	string	合同分录

*/
        List<JSONObject> detail = new ArrayList<>();
        // 子表
        List<InstoreMaterialVO> instoreMaterialList = vo.getInstoreMaterialList();
        if (CollectionUtils.isNotEmpty(instoreMaterialList)) {
            int i = 0;
            for (InstoreMaterialVO materialSubVO : instoreMaterialList) {
                if(!"del".equals(materialSubVO.getRowState())){
                    i++;
                    JSONObject subObj = new JSONObject();
                    subObj.put("f_seq", i);
                    subObj.put("f_materialcode", materialSubVO.getMaterialCode());
                    subObj.put("f_qty", materialSubVO.getInstoreNumber());
                    subObj.put("f_auxtaxprice", materialSubVO.getUnitPrice());
                    subObj.put("f_amount", materialSubVO.getAmount());
                    subObj.put("f_allamount", materialSubVO.getAmount());
                    subObj.put("f_note", materialSubVO.getRemark());
                    subObj.put("f_stockcode", obj.getString("f_engineeringcode"));
                    detail.add(subObj);
                }
            }
            obj.put("detail", detail);
        }
        return psrmRestUtil.postReq(obj, getSaveMethodName());
    }

    @Override
    public String getSaveMethodName() {
        return "crm.purchaseinstock.add";
    }

    @Override
    public String getUpdateMethodName() {
        return null;
    }


    public PSRMResponse saveOrUpdateAllotPsrmObj(InstoreVO vo, String outStoreCode, String inStoreCode) {
        /*     请求参数
字段	类型	说明
f_status	string	单据状态 创建 S 审核 Y （必录）
f_date	datetime	业务日期 （必录）
f_source	string	单据来源
f_synccode	string	益企联编码（必录）
f_explanation	string	摘要
f_smanagercode	string	保管人编码（必录）
f_fmanagercode	string	验收人编码（必录）
f_empcode	string	业务员编码（必录）
f_synccreator	string	益企联创建人
f_syncauditor	string	益企联审核人


*/
        String signDate = DateUtil.format(vo.getInstoreDate(), DateUtil.DATE);
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", vo.getBillCode());
        obj.put("f_status", "Y");
        obj.put("f_date", signDate);
        obj.put("f_source", MaterialStoreType.getStoreTypeNameByCode(vo.getInstoreType()));
        obj.put("f_empname", vo.getEmployeeName());
        obj.put("f_synccreator", vo.getCreateUserName());
        UserContext userContext = sessionManager.getUserContext();
        obj.put("f_syncauditor", userContext.getUserName());
 /*
detail	array	明细
f_seq	int	行号
f_materialcode	string	物料编号（必录）
f_spec	string	规格型号
f_auxpropcode	string	辅助属性编码
f_batchno	string	批号
f_unit	string	单位
f_qty	decimal	数量
f_auxprice	decimal	单位成本
f_amount	decimal	成本
f_note	string	备注
f_dcstockcode	string	调出仓库编码
f_stockcode	string	调入仓库编码
f_dcengineeringcode	string	调出工程项目编码
f_engineeringcode	string	调入工程项目编码
f_chkpassitem	string	检验是否良品 否 0 是 1


*/

        if (vo.getProjectId() != null) {
            JSONArray jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getProjectId()), "market-project");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                obj.put("f_engineeringcode", json.getString("code"));
            }
        }

        List<JSONObject> detail = new ArrayList<>();
        // 子表
        List<InstoreMaterialVO> instoreMaterialList = vo.getInstoreMaterialList();
        if (CollectionUtils.isNotEmpty(instoreMaterialList)) {
            int i = 0;
            for (InstoreMaterialVO materialSubVO : instoreMaterialList) {
                if(!"del".equals(materialSubVO.getRowState())){
                    i++;
                    JSONObject subObj = new JSONObject();
                    subObj.put("f_seq", i);
                    subObj.put("f_materialcode", materialSubVO.getMaterialCode());
                    subObj.put("f_spec", materialSubVO.getMaterialSpec());
                    subObj.put("f_unit", materialSubVO.getMaterialUnit());
                    subObj.put("f_qty", materialSubVO.getInstoreNumber());
                    subObj.put("f_auxprice", materialSubVO.getUnitPrice());
                    subObj.put("f_amount", materialSubVO.getAmount());
                    subObj.put("f_note", materialSubVO.getRemark());
                    // 调出仓库编码
                    subObj.put("f_dcstockcode", outStoreCode);
                    // 调入仓库编码
                    subObj.put("f_stockcode", obj.getString("f_engineeringcode"));
                    detail.add(subObj);
                }
            }
            obj.put("detail", detail);
        }
        return psrmRestUtil.postReq(obj, "dmp.transapplication.add");
    }
}
