package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class OutStoreService extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-72Q53Y26";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private PSRMRestUtil psrmRestUtil;

    // 劳务队伍领料限额量控制材料出库量
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";

    @Autowired
    private IPickRegisterService pickRegisterService;


    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<OutStoreVO> voPage = null;
        IPage<OutStoreEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0; i < entity.getOutStoreSubEntities().size(); i++) {
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = sub.getTaxRate() == null ? (new BigDecimal("1.00")) : new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"), 8, BigDecimal.ROUND_HALF_UP));
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getOutDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode(entity.getStoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode(entity.getStoreType()) + "_DETAIL");

                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate outDate = entity.getOutDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                c.setPeriod(outDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                c.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                // c.setShareId(); // 归集单据id 说明：不用传
                c.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                if (Objects.equals(MaterialStoreType.PICKING_OUT_STORE.getCode(), sub.getStoreType())) {
                    c.setSourceBillName(MaterialStoreType.PICKING_OUT_STORE.getDescription()); // 来源单据名称 说明：材料验收单
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickingOut/card?id=" + entity.getId()); // 来源单据url 说明：/ejc-promaterial-frontend/#/check/contractCard?id=585483774737809479
                }
                c.setNum(sub.getOutStoreNumber() == null ? BigDecimal.ZERO : sub.getOutStoreNumber()); // 发生数量 说明：子表有数量的都传，包含分包清单工程量

                // 以下信息物资、设备、周转材档案类传
                c.setMaterialId(sub.getMaterialId()); // 物资主键
                // c.setMaterialCode(sub.getMaterialCode()); // 物料编码
                c.setMaterialName(sub.getMaterialName()); // 物资名称
                c.setMaterialTypeId(sub.getMaterialCategoryId()); // 物资类别
                c.setMaterialTypeName(sub.getMaterialCategoryName()); // 物资类别名称
                c.setUnit(sub.getMaterialUnit()); // 单位名称
                // c.setUnitId(); // 单位主键
                c.setSpec(sub.getMaterialSpec()); // 规格型号

                list.add(c);
            }
            CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            logger.info("推送成本" + MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType()) + "结果:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
            // if(canPush){
            //     CommonResponse<String> response = iCostDetailApi.saveSubject(list);
            //     logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("1");
            // }else {
            //     CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
            //     logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
            //     entity.setRelationFlag("0");
            // }
        } else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    /**
     * @param topN
     * @param type
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.beginOfYear(new Date()));
        startDate = "'" + startDate + "'";
//        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCostTopN(topN,type,startDate,orgIds);
        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        List<JSONObject> result = new ArrayList<>();
        logger.info("查询物资开累年累消耗top n outStoreSubEntities 数量：" + (ListUtil.isNotEmpty(outStoreSubEntities) ? outStoreSubEntities.size() : "空") + " 当前orgId：" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
//                object.put("materialName",en.getMaterialName());
//                object.put("materialSpec",en.getMaterialSpec());
//                object.put("materialUnit",en.getMaterialUnit());
                object.put("materialCategoryName", en.getMaterialCategoryName());
                object.put("outStoreNumber", en.getOutStoreNumber());
                object.put("amount", en.getAmount());
                object.put("weight", ComputeUtil.safeMultiply(en.getUnitPrice(), new BigDecimal("100")).setScale(0, BigDecimal.ROUND_HALF_UP) + "%");
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        // 存放预警结果
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);

        List<MaterialPriceVO> detailList = vo.getDetail();
        Integer instoreType = vo.getInstoreType();
        if (CollectionUtils.isNotEmpty(detailList) && (int) detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

            //当前表单同类物资合计
            Map<Long, MaterialPriceVO> thisMap = new HashMap<>();
            detailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    MaterialPriceVO materialPriceVO = thisMap.get(item.getMaterialId());
                    materialPriceVO.setNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(materialPriceVO.getNum(), item.getNum())));
                } else {
                    thisMap.put(item.getMaterialId(), item);
                }
            });

            List<Long> materialIds = new ArrayList<>(thisMap.keySet());
            Long projectId = vo.getProjectId();
            Long supplierId = vo.getLabourArmyId();
            // 领料出库
            if (instoreType != null && instoreType.intValue() == 5 && supplierId != null) {
                // 劳务队伍领料限额量控制材料出库量
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("劳务队伍领料限额量控制材料出库量，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    // 根据项目和劳务队获取限量登记
                    Map<Long, BigDecimal> planMap = pickRegisterService.queryLaborLimitMaterialCount(projectId, supplierId, materialIds);

                    //获取已生效的量
                    List<MaterialPriceVO> vos = baseMapper.queryLaborMaterialCount(vo.getId(), projectId, supplierId, materialIds);
                    Map<Long, BigDecimal> numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap<>() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));

                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            thisMap.forEach((k, d) -> {
                                BigDecimal num = d.getNum();
                                BigDecimal applyNum = ComputeUtil.nullToZero(planMap.get(d.getMaterialId()));
                                BigDecimal hasNum = ComputeUtil.nullToZero(numVOMap.get(d.getMaterialId()));
                                BigDecimal allNum = ComputeUtil.safeAdd(hasNum, num);
                                //百分比数量
                                BigDecimal _applyNum = applyNum.multiply(divide);
                                if (allNum.compareTo(_applyNum) > 0) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "outStoreNumber");
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty(d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("劳务队伍领料出库量大于领料限额量");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("该材料本次出库数量：").append(num.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，含本次累计出库数量：").append(allNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("，领料限额数量*").append(roleValue).append("%: ").append(_applyNum.setScale(2, BigDecimal.ROUND_HALF_UP))
                                            .append("。超出数量：").append(ComputeUtil.safeSub(allNum, _applyNum).setScale(2, BigDecimal.ROUND_HALF_UP));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                                }
                            });
                        }
                    }
                }
            }

        }

        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            pc.setWarnType("alert");
            pc.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            pc.setWarnType("warn");
            pc.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper,
                                                          Long projectId, Long supplierId) {
        return baseMapper.queryPickDeductList(page, wrapper, projectId, supplierId);
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        check.getParams().put("bill_code", new Parameter(QueryParam.EQ, code));
        check.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<OutStoreEntity> entityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty(entityList)) {
            return false;
        }
        return true;
    }

    @Override
    public List<MaterialPriceVO> queryLaborMaterialCount(Long id, Long projectId, Long supplierId, List<Long> materialIds) {
        return baseMapper.queryLaborMaterialCount(id, projectId, supplierId, materialIds);
    }

    @Override
    public PSRMResponse saveOrUpdatePsrmObj(OutStoreVO vo) {
        // 物资退货 负数入库
       /*     请求参数
字段	类型	说明
f_synccode	string	单据编码（必录）
f_synccreator	string	创建人 （必录）
f_syncauditor	string	审核人 （必录）
f_status	string	单据状态 创建 S 审核 Y （必录）
f_date	datetime	业务日期（必录）
f_potype	string	采购类别（必录）
f_engineeringcode	string	工程项目编码
f_supplycode	string	供应商编码（必录）
f_postyle	string	采购方式 默认赊购：P002
f_contractcode	string	采购合同编号
f_explanation	string	摘要
f_smanagername	string	保管人名称（必录）
f_fmanagername	string	验收人名称（必录）
f_empname	string	业务员名称（必录）

*/
        String signDate = com.ejianc.business.utils.DateUtil.format(vo.getOutDate(), com.ejianc.business.utils.DateUtil.DATE);
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", vo.getBillCode());
        obj.put("f_status", "Y");
        obj.put("f_date", signDate);
        obj.put("f_potype", "物资退货");

        if (vo.getProjectId() != null) {
            JSONArray jArray = null;
            try {
                jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getProjectId()), "market-project");
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (jArray != null && jArray.size() > 0) {
                JSONObject json = (JSONObject) jArray.get(0);
                obj.put("f_engineeringcode", json.getString("code"));
            }
        }

        try {
            if (vo.getSupplierId() != null) {
                JSONArray jArray = ReferObjectUtil.getReferEntityValue(String.valueOf(vo.getSupplierId()), "support-supplier");
                if (jArray != null && jArray.size() > 0) {
                    JSONObject json = (JSONObject) jArray.get(0);
                    obj.put("f_supplycode", json.getString("code"));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (vo.getContractId() != null) {
            MaterialContractEntity contractEntity = materialContractMapper.selectById(vo.getContractId());
            if (contractEntity != null) {
                obj.put("f_contractcode", contractEntity.getCode());
            }
        }
        obj.put("f_empname", vo.getCreatorName());
        obj.put("f_synccreator", vo.getCreateUserName());
        UserContext userContext = sessionManager.getUserContext();
        obj.put("f_syncauditor", userContext.getUserName());
 /*
detail	array	明细
f_seq	int	行号（必录）
f_materialcode	string	物料编号（必录）
f_auxpropcode	string	辅助属性编码
f_batchno	string	批号
f_unit	string	单位
f_auxqtymust	decimal	应收数量
f_qty	decimal	实收数量（必录）
f_auxprice	decimal	单价
f_auxtaxprice	decimal	含税单价（必录）
f_amount	decimal	金额
f_cess	decimal	税率（%）
f_taxamount	decimal	税额
f_allamount	decimal	价税合计
f_note	string	备注
f_stockcode	string	收料仓库编码
f_chkpassitem	string	检验是否良品
f_projectnote	string	项目部备注
f_sourcebillno	string	K3WISE源单编号（采购订单单号）（必录）
f_sourceentryid	int	K3WISE源单行号（采购订单行号）（必录）
f_sourcetrantype	string	K3WISE源单类型 默认 采购订单（必录）
f_contractbillno	string	合同单号
f_contractentryid	string	合同分录

*/
        List<JSONObject> detail = new ArrayList<>();
        // 子表
        List<OutStoreSubVO> outStoreSubEntities = vo.getOutStoreSubEntities();
        if (CollectionUtils.isNotEmpty(outStoreSubEntities)) {
            int i = 0;
            for (OutStoreSubVO materialSubVO : outStoreSubEntities) {
                if(!"del".equals(materialSubVO.getRowState())){
                    i++;
                    JSONObject subObj = new JSONObject();
                    subObj.put("f_seq", i);
                    subObj.put("f_materialcode", materialSubVO.getMaterialCode());
                    subObj.put("f_qty", materialSubVO.getOutStoreNumber().negate());
                    subObj.put("f_auxtaxprice", materialSubVO.getUnitPrice());
                    subObj.put("f_amount", materialSubVO.getAmount());
                    subObj.put("f_allamount", materialSubVO.getAmount().negate());
                    subObj.put("f_note", materialSubVO.getRemark());
                    subObj.put("f_stockcode", obj.getString("f_engineeringcode"));
                    detail.add(subObj);
                }
            }
            obj.put("detail", detail);
        }
        return psrmRestUtil.postReq(obj, getSaveMethodName());
    }

    @Override
    public String getSaveMethodName() {
        return "crm.purchaseinstock.add";
    }

    @Override
    public String getUpdateMethodName() {
        return null;
    }

}
