package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICtrlSetApi;
import com.ejianc.business.cost.vo.CtrlSetDetailVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.material.bean.UseApplyEntity;
import com.ejianc.business.material.bean.UseApplySubEntity;
import com.ejianc.business.material.mapper.UseApplyMapper;
import com.ejianc.business.material.mapper.UseApplySubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.plan.bean.MaterialMasterPlanEntity;
import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanMapper;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.vo.MaterialMasterPlanSubVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class UseApplyService extends BaseServiceImpl<UseApplyMapper, UseApplyEntity> implements IUseApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    public IOutStoreSubService outStoreSubService;

    @Autowired
    public IPayContractApi payContractApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MaterialMasterPlanMapper materialMasterPlanMapper;
    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;
    @Autowired
    private UseApplyMapper useApplyMapper;
    @Autowired
    private UseApplySubMapper useApplySubMapper;

    @Autowired
    private InstoreMaterialService instoreMaterialService;

    private static String PARAM_PLAN_ALL_COUNT = "P-F8k54925";
    private static String PARAM_PLAN_PRICE = "P-649dG759";//物资总计划单价控制用料申请单价
    private static String PARAM_PROJECT_MNY = "P-w112KG65";//【项目可用资金】控制【用料申请】
    private static String PARAM_COST_MNY = "P-AQ725A75";//【预算零星材料金额】控制【用料申请零星材料金额】
    private static String PARAM_BATCH_PLAN_NUM = "P-q4fR4e66";//【材料批次计划量】控制【用料申请量】

    @Override
    public IPage<UseApplyVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<UseApplyVO> voPage = null;
        IPage<UseApplyEntity> entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), UseApplyVO.class));
        }
        return voPage;
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param paramsCheckDsVO  预警信息
     */
    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, String billType, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(billType)) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(billType)) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private ICtrlSetApi ctrlSetApi;

    @Override
    public ParamsCheckVO checkAllParams(UseApplyVO vo) {
        try {
            Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
            String[] paramsArray = {"none", "warn", "alert"};
            // 存放预警结果
            Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
            paramsCheckVOMap.put("alert", new ArrayList<>());
            paramsCheckVOMap.put("warn", new ArrayList<>());
            ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
            paramsCheckVO.setWarnType(paramsArray[0]);
            List<UseApplySubVO> subVOList = vo.getUseApplySubEntities();
            // 用料申请可以做历史单据 根据项目id取得原申请过的数据 当前申请明细和对应的申请。
            QueryWrapper<UseApplyEntity> appWrapper = new QueryWrapper<>();
            appWrapper.eq("project_id", vo.getProjectId());
            appWrapper.eq("dr", 0);
            List<UseApplyEntity> useApplyEntities = useApplyMapper.selectList(appWrapper);
            List<Long> pids = useApplyEntities.stream().map(e -> e.getId()).collect(Collectors.toList());

            // 查询旧数据时，剔除掉本次申请的物资
            List<Long> noIds = new ArrayList<>();
            vo.getUseApplySubEntities().forEach(item -> {
                if (item.getId() != null) {
                    noIds.add(item.getId());
                }
            });
            // list添加一个数据，防止数据为空时，in查询sql拼接错误。
            pids.add(000001L);
            QueryWrapper<UseApplySubEntity> appSubWrapper = new QueryWrapper<>();
            appSubWrapper.in("pid", pids);
            appSubWrapper.notIn("id", noIds);
            appSubWrapper.eq("dr", 0);
            appSubWrapper.ne("task_state", "back");
            List<UseApplySubEntity> oldEntities = useApplySubMapper.selectList(appSubWrapper);
            List<UseApplySubEntity> savedEntities = BeanMapper.mapList(subVOList, UseApplySubEntity.class);
            Map<Long, UseApplySubEntity> thisMap = new HashMap<>();
            savedEntities.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    UseApplySubEntity useApplySubEntity = thisMap.get(item.getMaterialId());
                    useApplySubEntity.setApplyNum(ComputeUtil.nullToZero(ComputeUtil.safeAdd(useApplySubEntity.getApplyNum(), item.getApplyNum())));
                } else {
                    thisMap.put(item.getMaterialId(), item);
                }
            });

            Map<Long, BigDecimal> oldAppMap = new HashMap<>();
            oldEntities.forEach(item -> {
                BigDecimal applyNum = item.getApplyNum();
                if (oldAppMap.containsKey(item.getMaterialId())) {
                    BigDecimal bigDecimal = oldAppMap.get(item.getMaterialId());
                    oldAppMap.put(item.getMaterialId(), ComputeUtil.nullToZero(ComputeUtil.safeAdd(applyNum, bigDecimal)));
                } else {
                    oldAppMap.put(item.getMaterialId(), applyNum);
                }
            });


            if (CollectionUtils.isNotEmpty(savedEntities) && (int) savedEntities.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
                savedEntities = savedEntities.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());

                // 【总计划】控制【项目用料申请】
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_ALL_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("【总计划】控制【项目用料申请】，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();

                if (CollectionUtils.isNotEmpty(billParamVOS)) {

                    // 根据项目取得总计划数据
                    Long projectId = vo.getProjectId();
                    QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("project_id", projectId);
                    wrapper.eq("dr", 0);
                    List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                    QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                    List<Long> ids = new ArrayList<>();
                    materialMasterPlanEntities.forEach(item -> {
                        ids.add(item.getId());
                    });
                    // list添加一个数据，防止数据为空时，in查询sql拼接错误。
                    ids.add(000001L);
                    planSubWrapper.in("material_master_plan_id", ids);
                    planSubWrapper.eq("dr", 0);
                    List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                    Map<Long, BigDecimal> planMap = new HashMap<>();
                    materialMasterPlanSubEntities.forEach(item -> {
                        Double num = item.getNum();
                        if (planMap.get(item.getMaterialId()) != null) {
                            planMap.put(item.getMaterialId(), ComputeUtil.safeAdd(BigDecimal.valueOf(num), planMap.get(item.getMaterialId())));
                        } else {
                            planMap.put(item.getMaterialId(), ComputeUtil.toBigDecimal(num));
                        }
                    });

                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            // 管理费率
                            BigDecimal manageRate = billParamVO.getRoleValue();
                            // 根据项目id取得原申请过的数据。
                            thisMap.forEach((k, item) -> {
                                Long materialId = item.getMaterialId();
                                //本次申请数量
                                BigDecimal applyNum = item.getApplyNum();
                                //原有的数量 如果为空取0
                                BigDecimal oldApplyNum = oldAppMap.get(materialId) == null ? BigDecimal.ZERO : oldAppMap.get(materialId);
                                //总计划数量 如果为空 则表示未做计划，取0
                                BigDecimal planNum = planMap.get(materialId) == null ? BigDecimal.ZERO : planMap.get(materialId);

                                BigDecimal planNumber = planNum.multiply(manageRate).divide(BigDecimal.valueOf(100));
                                BigDecimal appNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldApplyNum, applyNum));

                                if (planNumber.compareTo(appNumber) == -1) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("累计申请数量超出总计划*比例");
                                    paramsCheckDsVO.setContent("本次申请数量:" + applyNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + ",累计已申请数量" + oldApplyNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + ",总计划数量" + planNum.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + ",总计划数量比例" + manageRate.setScale(8, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + "%,超额" + appNumber.subtract(planNumber).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    );
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, paramsArray[billParamVO.getControlType()], paramsCheckDsVO);
                                }
                            });
                        }
                    }
                }

                // 【物资总计划单价】控制【用料申请单价】
                CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_PLAN_PRICE, curOrgId);
                if (!response1.isSuccess()) {
                    throw new BusinessException("【物资总计划单价】控制【用料申请单价】，获取控制参数失败，失败原因：" + response1.getMsg());
                }
                List<BillParamVO> billParamVOS1 = response1.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                    // 根据项目取得总计划数据
                    Long projectId = vo.getProjectId();
                    QueryWrapper<MaterialMasterPlanEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("project_id", projectId);
                    List<MaterialMasterPlanEntity> materialMasterPlanEntities = materialMasterPlanMapper.selectList(wrapper);

                    Map<Long, BigDecimal> planMap = new HashMap<>();
                    if (CollectionUtils.isNotEmpty(materialMasterPlanEntities)) {
                        List<Long> planIds = materialMasterPlanEntities.stream().map(MaterialMasterPlanEntity::getId).collect(Collectors.toList());
                        QueryWrapper<MaterialMasterPlanSubEntity> planSubWrapper = new QueryWrapper<>();
                        planSubWrapper.in("material_master_plan_id", planIds);
                        List<MaterialMasterPlanSubEntity> materialMasterPlanSubEntities = materialMasterPlanSubMapper.selectList(planSubWrapper);
                        materialMasterPlanSubEntities.forEach(item -> {
                            BigDecimal price = item.getPrice();
                            Long materialId = item.getMaterialId();
                            //根据物资id取出总计划物资单价，若物资id相同则取单价最小值
                            if (!planMap.containsKey(materialId) || ComputeUtil.isLessThan(price, planMap.get(item.getMaterialId()))) {
                                planMap.put(materialId, price);
                            }
                        });
                    }
                    for (BillParamVO billParamVO : billParamVOS1) {
                        if (0 != billParamVO.getControlType()) {
                            // 比例
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100));
                            savedEntities.forEach((item) -> {
                                Long materialId = item.getMaterialId();
                                //本次材料申请单价
                                BigDecimal estimatePrice = item.getEstimatePrice();
                                //总计划单价 如果为空 则表示未做计划，取0
                                BigDecimal price = ComputeUtil.nullToZero(planMap.get(materialId));
                                //预警价
                                BigDecimal _planPrice = price.multiply(divide);

                                if (ComputeUtil.isGreaterThan(estimatePrice, _planPrice)) {
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                    paramsCheckDsVO.setWarnItem(item.getMaterialName() + (StringUtils.isNotEmpty(item.getModel()) ? " [" + item.getModel() + "]" : ""));
                                    paramsCheckDsVO.setWarnName("用料申请单价大于总计划单价");
                                    paramsCheckDsVO.setContent("本次用料申请单价：" + estimatePrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + ",总计划单价*" + roleValue.setScale(8, 4).stripTrailingZeros().toPlainString() + "%:" + _planPrice.setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                            + ",超出单价" + estimatePrice.subtract(_planPrice).setScale(4, BigDecimal.ROUND_HALF_UP).stripTrailingZeros().toPlainString()
                                    );
                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, paramsArray[billParamVO.getControlType()], paramsCheckDsVO);
                                }
                            });
                        }
                    }
                }

                // 没有预算清单不控制
                List<Long> subIds = savedEntities.stream().map(UseApplySubEntity::getMaterialId).collect(Collectors.toList());
                // 预算材料清单量
                BudgetProjectProParamControlVO paramControlVO1 = new BudgetProjectProParamControlVO();
                paramControlVO1.setProjectId(vo.getProjectId());
                paramControlVO1.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                paramControlVO1.setIds(subIds);
                logger.info("参数：", JSONObject.toJSONString(paramControlVO1));
                CommonResponse<BudgetProjectProQuantityAndMnyVO> res1 = budgetProjectProApi.fetchQuantityAndMny(paramControlVO1);
                if (!res1.isSuccess()) {
                    throw new BusinessException("预算材料清单量，查询项目预算信息失败，失败原因：" + res1.getMsg());
                }
                if (null != res1.getData()) {
                    BudgetProjectProQuantityAndMnyVO proQuantityAndMnyVO = res1.getData();
                    Map<Long, BudgetProjectDetailProVO> detailProMap = proQuantityAndMnyVO.getDetailProMap();
                    if (!detailProMap.isEmpty()) {
                        //查询控制参数
                        List<Long> categoryIds = savedEntities.stream().map(e -> e.getMaterialTypeId()).distinct().collect(Collectors.toList());
                        CommonResponse<List<CtrlSetDetailVO>> listCommonResponse = ctrlSetApi.querySetDetailByCategory(categoryIds);
                        if (!listCommonResponse.isSuccess()) {
                            throw new BusinessException("查询物料管控设置失败，失败原因：" + listCommonResponse.getMsg());
                        }
                        if (CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
                            List<CtrlSetDetailVO> data = listCommonResponse.getData();
                            Map<Long, List<CtrlSetDetailVO>> controlMap = data.stream().collect(Collectors.groupingBy(e -> e.getSetId()));
                            thisMap.forEach((k, item) -> {
                                //判断是否有成本
                                if (detailProMap.containsKey(item.getMaterialId())) {
                                    //判断是否有规则
                                    if (controlMap.containsKey(item.getMaterialTypeId())) {
                                        //获取成本
                                        BudgetProjectDetailProVO budgetProjectDetailProVO = detailProMap.get(item.getMaterialId());
                                        BigDecimal costNum = budgetProjectDetailProVO.getNum();
                                        //获取规则
                                        List<CtrlSetDetailVO> ctrlSetDetailVO = controlMap.get(item.getMaterialTypeId());
                                        //获取申请量
                                        BigDecimal applyNum = item.getApplyNum();
                                        BigDecimal oldApplyNum = oldAppMap.get(item.getMaterialId()) == null ? BigDecimal.ZERO : oldAppMap.get(item.getMaterialId());
                                        BigDecimal appNumber = ComputeUtil.nullToZero(ComputeUtil.safeAdd(oldApplyNum, applyNum));
                                        for (CtrlSetDetailVO setDetail : ctrlSetDetailVO) {
                                            if (setDetail.getControlType() == 1) {
                                                BigDecimal cost = ComputeUtil.safeMultiply(costNum, setDetail.getControlScale());
                                                cost = ComputeUtil.safeDiv(cost, new BigDecimal("100"));
                                                if (ComputeUtil.isGreaterThan(appNumber, cost)) {
                                                    BigDecimal exceed = ComputeUtil.safeSub(appNumber, cost);
                                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(item.getMaterialId(), "num");
                                                    paramsCheckDsVO.setOrgName("华康");
                                                    paramsCheckDsVO.setWarnItem(item.getMaterialName() + "-" + item.getModel() + "申请量超额预警");
                                                    paramsCheckDsVO.setWarnName("材料用料申请量超目标成本量");
                                                    String text = "超出数量=" + appNumber.setScale(2, RoundingMode.HALF_UP)
                                                            + "-" + costNum.setScale(2, RoundingMode.HALF_UP)
                                                            + "*" + setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP)
                                                            + "% =" + exceed.setScale(2, RoundingMode.HALF_UP) + item.getUnit() + "。";
                                                    String redText = Jsoup.parse("<font color=\"red\">" + text + "</font>").body().html();
                                                    StringBuffer stringBuffer = new StringBuffer();
                                                    stringBuffer.append("用料申请总量：")
                                                            .append(appNumber.setScale(2, RoundingMode.HALF_UP))
                                                            .append(item.getUnit())
                                                            .append("，目标成本量：")
                                                            .append(costNum.setScale(2, RoundingMode.HALF_UP))
                                                            .append(item.getUnit())
                                                            .append("，管控比例：")
                                                            .append(setDetail.getControlScale().setScale(2, RoundingMode.HALF_UP))
                                                            .append("%：")
                                                            .append(redText);
                                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, setDetail.getControlMethod() == 1 ? "warn" : "alert", paramsCheckDsVO);
                                                }
                                            }
                                        }

                                    }

                                }
                            });

                        }
                    }
                }
            }
            ParamsCheckVO pc = new ParamsCheckVO();
            if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
                pc.setWarnType("alert");
                pc.setDataSource(paramsCheckVOMap.get("alert"));
            } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
                pc.setWarnType("warn");
                pc.setDataSource(paramsCheckVOMap.get("warn"));
            } else {
                pc.setWarnType("none");
                pc.setDataSource(null);
            }
            return pc;
        } catch (NullPointerException e) {
            System.out.println("空指针异常发生：" + e.getMessage());
            e.printStackTrace();
        }

        return null;
    }


    @Override
    public void setIsExceed(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null && !"del".equals(s.getRowState())).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
        //当前单子累计物资量
        Map<Long, BigDecimal> numMap = new HashMap<>();
        listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
        List<Long> materialIds = new ArrayList<>(listMap.keySet());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            Map<String, Object> queryParam = new HashMap<>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNumCommon(queryParam);
            Map<Long, BigDecimal> applyedMap = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> k.getMaterialId(), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));

            /** 获取该项目下物资总计划数量 **/
            List<MaterialMasterPlanSubVO> masterPlanSubVOS = materialMasterPlanSubMapper.queryMasterPlanSubNum(queryParam);
            Map<Long, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> k.getMaterialId(), k -> k.getNum()));

            for (Map.Entry<Long, BigDecimal> entry : numMap.entrySet()) {
                Long materialId = entry.getKey();
                BigDecimal applyedHaveThis = ComputeUtil.safeAdd(entry.getValue(), applyedMap.get(materialId));
                if (ComputeUtil.isGreaterThan(applyedHaveThis, ComputeUtil.toBigDecimal(masterPlanMap.get(materialId)))) {
                    vo.setIsExceed(1);
                    break;
                }
            }
        }
    }

    @Override
    public CommonResponse<UseApplyVO> getSumNumCommon(UseApplyVO vo) {
        List<UseApplySubVO> useApplySubEntities = vo.getUseApplySubEntities();
        if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
            Map<Long, List<UseApplySubVO>> listMap = useApplySubEntities.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(UseApplySubVO::getMaterialId));
            //当前单子累计物资量
            Map<Long, BigDecimal> numMap = new HashMap<>();
            listMap.forEach((k, v) -> numMap.put(k, v.stream().filter(s -> s.getApplyNum() != null).map(UseApplySubVO::getApplyNum).reduce(BigDecimal.ZERO, BigDecimal::add)));
            List<Long> materialIds = new ArrayList<>(listMap.keySet());
            if (CollectionUtils.isEmpty(materialIds)) {
                return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
            }
            Map<String, Object> queryParam = new HashMap<>();
            queryParam.put("projectId", vo.getProjectId());
            queryParam.put("pId", vo.getId());
            queryParam.put("materialIds", materialIds);
            List<UseApplySubVO> useApplySubVOS = baseMapper.countApplyNumCommon(queryParam);

            Long orgId = vo.getOrgId();
            List<InstoreMaterialVO> instoreMaterialVOList = null;
            if (orgId != null) {
                instoreMaterialVOList = instoreMaterialService.storeNumCount(orgId, materialIds);
            }

            /** 获取该项目下物资总计划数量 **/
            List<MaterialMasterPlanSubVO> masterPlanSubVOS = materialMasterPlanSubMapper.queryMasterPlanSubNum(queryParam);
            //Map<String, Double> masterPlanMap = masterPlanSubVOS.stream().filter(s -> s.getMaterialId() != null && s.getNum() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(Double.valueOf(0), MaterialMasterPlanSubVO::getNum, Double::sum)));
            Map<String, Double> masterPlanMap = masterPlanSubVOS.stream().collect(Collectors.toMap(k -> String.valueOf(k.getMaterialId()), k -> k.getNum()));

            Map<String, BigDecimal> storeNumMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(instoreMaterialVOList)) {
                storeNumMap = instoreMaterialVOList.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, InstoreMaterialVO::getStoreNum, ComputeUtil::safeAdd)));
                //storeNumMap = instoreMaterialVOList.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, InstoreMaterialVO::getStoreNum, ComputeUtil::safeAdd)));
            }
            //Map<String, BigDecimal> level3Map = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            Map<String, BigDecimal> level3Map = useApplySubVOS.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));

            Map<String, BigDecimal> sumAppluNumMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(useApplySubEntities)) {
                sumAppluNumMap = useApplySubEntities.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
                //sumAppluNumMap = useApplySubEntities.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, UseApplySubVO::getApplyNum, ComputeUtil::safeAdd)));
            }

            for (UseApplySubVO d : useApplySubEntities) {
                // String materialId = String.valueOf(d.getMaterialId()) + (d.getBrandId() != null ? d.getBrandId() : "");
                String materialId = String.valueOf(d.getMaterialId());
                if (materialId == null) {
                    continue;
                }
                BigDecimal applyed = level3Map.get(materialId);
                /** 获取该项目下物资退货数量 **/
                Map<String, Object> param = new HashMap<>();
                param.put("projectId", vo.getProjectId());
                param.put("materialId", d.getMaterialId());
                List<OutStoreSubVO> outStoreSubVOS = outStoreSubService.queryReturnGoodsMaterialNum(param);
                Map<String, BigDecimal> outStoreMap = outStoreSubVOS.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.getMaterialId()) + (k.getBrandId() != null ? k.getBrandId() : ""), Collectors.reducing(BigDecimal.ZERO, OutStoreSubVO::getOutStoreNumber, ComputeUtil::safeAdd)));
                BigDecimal returnGoodsNum = outStoreMap.get(materialId);
                BigDecimal storeNum = ComputeUtil.nullToZero(storeNumMap.get(materialId));
                storeNum = BigDecimalUtils.safeSub(storeNum, returnGoodsNum);
                if (ComputeUtil.isLessThan(applyed, BigDecimal.ZERO)) {
                    applyed = BigDecimal.ZERO;
                }
                BigDecimal thisAddApplyed = ComputeUtil.safeAdd(applyed, sumAppluNumMap.get(materialId));
                if (thisAddApplyed.compareTo(BigDecimal.ZERO) < 0) {
                    thisAddApplyed = new BigDecimal(0);
                }

                Double masterPlanNum = masterPlanMap.get(materialId);
                d.setOrderNum(ComputeUtil.nullToZero(thisAddApplyed));
                d.setSumApplyNum(ComputeUtil.nullToZero(applyed));
                d.setMasterPlanNum(masterPlanNum != null ? new BigDecimal(masterPlanNum) : BigDecimal.ZERO.setScale(8));
                d.setStoreNum(storeNum);
                d.setIsFinish(0);
            }
        }

        return CommonResponse.success("查询物资累计量,进度量,总量成功!", vo);
    }

    /**
     * @param queryParam
     * @description: 查询项目用料, 物资已完成状态, 施工计划 使用
     * 世纪阳光专业分包模式使用
     * @return: java.util.List<com.ejianc.business.material.vo.UseApplySubVO>
     * @author songlx
     * @date: 2021/9/28
     */
    @Override
    public List<UseApplyFinishVO> materialFinishCount(Map<String, Object> queryParam) {
        return baseMapper.materialFinishCount(queryParam);
    }

    /**
     *
     * @param projectId
     * @param materialIds
     * @return
     */
    @Override
    public List<MaterialApplyCountVO> queryMaterialApplyCount(Long projectId, List<Long> materialIds) {
        return baseMapper.queryMaterialApplyCount(projectId, materialIds);
    }

    /**
     * @description: 查询用料申请参照合计版
     *
     * @param pageData
     * @param queryParam
     * @param projectId
     * @return {@link List< UseApplySubEntity>}
     * @author songlx
     * @date: 2022/11/29
     */
    @Override
    public List<UseApplySubEntity> queryAllApplyData(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyData(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubList(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubList(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyDataForPurchaseOrder(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForPurchaseOrder(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubListForPurchaseOrder(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryApplySubListForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryApplySubListForInstore(pageData, wrapper);
        return list;
    }

    @Override
    public List<UseApplySubEntity> queryAllApplyDataForInstore(IPage<UseApplySubEntity> pageData, QueryParam queryParam, Long projectId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<UseApplySubEntity> list = baseMapper.queryAllApplyDataForInstore(pageData, wrapper, projectId);
        return list;
    }

    @Override
    public void updatePurchaseFlag(Long id, Integer purchaseFlag) {
        if (id != null) {
            LambdaUpdateWrapper<UseApplyEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(UseApplyEntity::getId, id);
            updateWrapper.set(UseApplyEntity::getPurchaseFlag, purchaseFlag);
            super.update(updateWrapper);
        }
    }

    @Override
    public void updateSumBookNum(List<Long> applyIds) {
        baseMapper.updateSumBookNum(applyIds);
    }

    @Override
    public void updateSumCheckNum(Long applyId) {
        baseMapper.updateSumCheckNum(applyId);
    }

    @Override
    public List<UseApplyVO> queryOrderIssuanceList(IPage<UseApplyVO> pageData, QueryWrapper wrapper, Long employeeId, Long purchaseManagerId) {
        return baseMapper.queryOrderIssuanceList(pageData, wrapper, employeeId, purchaseManagerId);
    }

    /**
     * @description: 根据用料申请明细联查采购订单明细
     *
     * @param applyDetailId 用料申请明细id
     * @return {@link List< PurchaseOrderDetailVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    @Override
    public List<PurchaseOrderDetailVO> queryAssignDetail(Long applyDetailId) {
        return useApplyMapper.getPurchaseOrderDetail(applyDetailId);
    }

    /**
     * @description: 根据用料申请明细or采购订单明细联查收料入库明细
     *
     * @param applyDetailId 用料申请明细id
     * @param purchaseOrderDetailId 采购订单明细id
     * @return {@link List< InstoreMaterialVO>}
     * @author songlx
     * @date: 2024/6/24
     */
    @Override
    public List<InstoreMaterialVO> queryInstoreMaterial(Long applyDetailId, Long purchaseOrderDetailId) {
        return useApplyMapper.getInstoreMaterial(applyDetailId, purchaseOrderDetailId);
    }

    @Override
    public Map<Long, UseApplySubEntity> getSumBookNum(List<Long> applySubIds, List<Long> ingoreOrderDetailIds) {
        Map<Long, UseApplySubEntity> applySubEntityMap = new HashMap<>();
        List<UseApplySubEntity> list = baseMapper.getSumBookNum(applySubIds, ingoreOrderDetailIds);
        if (CollectionUtils.isNotEmpty(list)) {
            applySubEntityMap = list.stream().collect(Collectors.toMap(UseApplySubEntity::getId, e -> e));
        }
        return applySubEntityMap;
    }


}