package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/12 出库主表
 * @Description OutStoreVO
 */

public class OutStoreVO extends BaseVO {

    /**
     * 直入直出对应入库表主表id
     */
    private Long straightInId;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 是否属于项目 1是 0否
     */
    private String projectFlag;

    /**
     * 出库类型
     */
    private Integer storeType;

    /**
     * 出库类型名称 参照翻译
     */
    private String storeTypeName;

    /**
     * 出库编号
     */
    private String billCode;

    /**
     * 出库日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;

    /**
     * 出库仓库id
     */
    private Long storeId;

    /**
     * 出库仓库名称
     */
    private String storeName;

    /**
     * 出库组织id
     */
    private Long orgId;

    /**
     * 出库组织名称
     */
    private String orgName;

    /**
     * 出库物资名称集合
     */
    private String materialNames;

    /**
     * 出库数量
     */
    private BigDecimal outNum;

    /**
     * 出库金额
     */
    private BigDecimal outMoney;

    /**
     * 出库金额
     */
    private BigDecimal outMoneyNoTax;

    /**
     * 用处
     */
    private String useFor;

    /**
     * 备注
     */
    private String memo;

    /**
     * 编制人
     */
    private String creatorName;

    /**
     * 出库项目名称
     */
    private String projectName;
    
    /**
     * 所属项目编码
     */
    private String projectCode;

    /**
     * 出库项目id
     */
    private Long projectId;

    /**
     * 劳务队伍
     */
    private String supplierName;

    /**
     * 劳务队伍
     */
    private Long supplierId;

    /**
     * 合同id 直入直出
     */
    private Long contractId;

    /**
     * 合同名称 直入直出
     */
    private String contractName;


    /**
     * 调入项目名称
     */
    private String inProjectName;

    /**
     * 调入项目id
     */
    private Long inProjectId;

    /**
     * 调入仓库名称
     */
    private String inStoreName;

    /**
     * 调入组织id
     */
    private Long inOrgId;

    /**
     * 调入组织名称
     */
    private String inOrgName;

    /**
     * 调入单位是否属于项目
     */
    private String inBelongToProject;

    /**
     * 调入组织收料状态
     */
    private String receiveState;

    /**
     * 调入组织收料状人
     */
    private String receivePerson;

    /**
     * 调入组织退回原因
     */
    private String returnReason;

    /**
     * 通知收料（调入组织收料人）
     */
    private Long noticeToReceive;
    /**
     * 退货金额差
     */
    private BigDecimal moneyDisparity;

    /**
     * 退货是否结算（1已结算,0未结算） 退货使用
     */
    private Integer settlementFlag = 0;

    /**
     * 成本关联科目状态(1:是，0：否)
     */
    private String relationFlag;

    /**
     * 成本分摊状态(1:是，0：否)
     */
    private String proportionFlag;

    /**
     * 税率
     */
    private BigDecimal taxRate;
    //车牌号
    private String carNumber;

    List<OutStoreSubVO>  outStoreSubEntities = new ArrayList<>();
    //是否自动入库 是否自动入库(1:是，0：否)
    private Boolean autoStoreFlag;
    /**
     * 调入仓库id
     */
    private Long inStoreId;


    private String psrmReturncode; // 数据中台状态

    private String psrmCode; // 数据中台编码

    private String psrmReturndata; // 数据中台返回数据

    public String getPsrmReturncode() {
        return psrmReturncode;
    }

    public void setPsrmReturncode(String psrmReturncode) {
        this.psrmReturncode = psrmReturncode;
    }

    public String getPsrmCode() {
        return psrmCode;
    }

    public void setPsrmCode(String psrmCode) {
        this.psrmCode = psrmCode;
    }

    public String getPsrmReturndata() {
        return psrmReturndata;
    }

    public void setPsrmReturndata(String psrmReturndata) {
        this.psrmReturndata = psrmReturndata;
    }

    @ReferSerialTransfer(referCode="material-store")
    public Long getInStoreId() {
        return inStoreId;
    }
    @ReferDeserialTransfer
    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }
    public Boolean getAutoStoreFlag() {
        return autoStoreFlag;
    }

    public void setAutoStoreFlag(Boolean autoStoreFlag) {
        this.autoStoreFlag = autoStoreFlag;
    }
    public Long getStraightInId() {
        return straightInId;
    }

    public void setStraightInId(Long straightInId) {
        this.straightInId = straightInId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getProjectFlag() {
        return projectFlag;
    }

    public void setProjectFlag(String projectFlag) {
        this.projectFlag = projectFlag;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    @ReferSerialTransfer(referCode="material-store")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }

    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutMoney() {
        return outMoney;
    }

    public void setOutMoney(BigDecimal outMoney) {
        this.outMoney = outMoney;
    }

    public BigDecimal getOutMoneyNoTax() {
        return outMoneyNoTax;
    }

    public void setOutMoneyNoTax(BigDecimal outMoneyNoTax) {
        this.outMoneyNoTax = outMoneyNoTax;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getCreatorName() {
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    @ReferSerialTransfer(referCode="materialContract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getInProjectName() {
        return inProjectName;
    }

    public void setInProjectName(String inProjectName) {
        this.inProjectName = inProjectName;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getInProjectId() {
        return inProjectId;
    }

    @ReferDeserialTransfer
    public void setInProjectId(Long inProjectId) {
        this.inProjectId = inProjectId;
    }

    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getInOrgId() {
        return inOrgId;
    }

    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }

    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }

    public String getInBelongToProject() {
        return inBelongToProject;
    }

    public void setInBelongToProject(String inBelongToProject) {
        this.inBelongToProject = inBelongToProject;
    }

    public String getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(String receiveState) {
        this.receiveState = receiveState;
    }

    public String getReceivePerson() {
        return receivePerson;
    }

    public void setReceivePerson(String receivePerson) {
        this.receivePerson = receivePerson;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getNoticeToReceive() {
        return noticeToReceive;
    }

    @ReferDeserialTransfer
    public void setNoticeToReceive(Long noticeToReceive) {
        this.noticeToReceive = noticeToReceive;
    }

    public BigDecimal getMoneyDisparity() {
        return moneyDisparity;
    }

    public void setMoneyDisparity(BigDecimal moneyDisparity) {
        this.moneyDisparity = moneyDisparity;
    }

    public List<OutStoreSubVO> getOutStoreSubEntities() {
        return outStoreSubEntities;
    }

    public void setOutStoreSubEntities(List<OutStoreSubVO> outStoreSubEntities) {
        this.outStoreSubEntities = outStoreSubEntities;
    }

    public Integer getSettlementFlag() {
        return settlementFlag;
    }

    public void setSettlementFlag(Integer settlementFlag) {
        this.settlementFlag = settlementFlag;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getCarNumber() {
        return carNumber;
    }

    public void setCarNumber(String carNumber) {
        this.carNumber = carNumber;
    }
}
