package com.ejianc.business.plan.service;

import com.ejianc.business.plan.bean.PlanChangeEntity;
import com.ejianc.business.plan.vo.PlanChangeVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/5 9:55
 */
public interface IPlanChangeService extends IBaseService<PlanChangeEntity> {

    /**
     * 保存更新总计划变更
     *
     * @param saveEntity
     * @return
     */
    PlanChangeEntity saveOrUpdatePlanChange(PlanChangeEntity saveEntity);

    /**
     * 根据Id删除对应的变更单据，并恢复计划单据的变更信息
     *
     * @param changeIds
     */
    void deleteChangePlan(List<Long> changeIds);

    /**
     * 查询指定计划对应的未完成的变更
     *
     * @param sourcePlanId
     * @return
     */
    PlanChangeEntity getUnFinishedChange(Long sourcePlanId);

    void querySumApplyNum(PlanChangeVO vo);
}
