/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.ComparePriceEntity;
import com.ejianc.business.material.bean.ComparePriceSelectedSupplierEntity;
import com.ejianc.business.material.service.IComparePriceSelectedSupplierService;
import com.ejianc.business.material.service.IComparePriceService;
import com.ejianc.business.material.service.IComparePriceSubService;
import com.ejianc.business.material.vo.ComparePriceExportVO;
import com.ejianc.business.material.vo.ComparePriceSubVO;
import com.ejianc.business.material.vo.ComparePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/comparePrice/"})
public class ComparePriceController {
    private static final String BILL_CODE = "comparePrice";
    @Autowired
    private IComparePriceService iComparePriceService;
    @Autowired
    private IComparePriceSubService iComparePriceSubService;
    @Autowired
    private IComparePriceSelectedSupplierService iComparePriceSelectedSupplierService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ComparePriceVO> saveOrUpdate(@RequestBody ComparePriceVO vo) {
        ComparePriceEntity entity = (ComparePriceEntity)((Object)BeanMapper.map((Object)((Object)vo), ComparePriceEntity.class));
        if (vo.getId() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.iComparePriceService.insertOrUpdate(entity);
        vo = (ComparePriceVO)((Object)BeanMapper.map((Object)((Object)entity), ComparePriceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ComparePriceVO> queryDetail(Long id) {
        ComparePriceEntity entity = (ComparePriceEntity)((Object)this.iComparePriceService.selectById(id));
        if (!ListUtil.isEmpty(entity.getPriceSubEntities())) {
            entity.getPriceSubEntities().forEach(sub -> {
                QueryParam param = new QueryParam();
                param.getParams().put("comparePriceSubId", new Parameter("eq", (Object)sub.getId()));
                sub.setSupplierEntities(this.iComparePriceSelectedSupplierService.queryList(param, false));
            });
        }
        ComparePriceVO vo = (ComparePriceVO)((Object)BeanMapper.map((Object)((Object)entity), ComparePriceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ComparePriceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("inquiryPerson");
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.iComparePriceService.queryForList(param));
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("ComparePrice", this.iComparePriceService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ComparePriceVO> vos) {
        this.iComparePriceService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("inquiryPerson");
        fuzzyFields.add("orgName");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<ComparePriceVO> voPage = this.iComparePriceService.queryForList(queryParam);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            ComparePriceExportVO exportVO = (ComparePriceExportVO)BeanMapper.map((Object)vo, ComparePriceExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)vo.getCreateTime()));
            if (vo.getInquiryDate() != null) {
                exportVO.setInquiryDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getInquiryDate()));
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("comparePriceListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refComparePrice"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ComparePriceVO>> refComparePrice(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String condition, String searchText) {
        Map conditionMap;
        QueryParam param = new QueryParam();
        param.setPageIndex(pageNumber.intValue());
        param.setPageSize(pageSize.intValue());
        param.setSearchText(searchText);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("inquiryPerson");
        fuzzyFields.add("orgName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("orgId")) {
            orgId = Long.valueOf(conditionMap.get("orgId").toString());
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be2\u4ef7\u5355\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", this.iComparePriceService.queryForList(param));
    }

    @RequestMapping(value={"/refComparePriceSubs"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ComparePriceSubVO>> refComparePriceSubs(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(value="searchText", required=false) String searchText) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        if (StringUtils.isBlank((CharSequence)con.getString("comparePriceId"))) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u6bd4\u4ef7\u5355Id\u3010comparePriceId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComparePriceEntity entity = (ComparePriceEntity)((Object)this.iComparePriceService.selectById(con.getLong("comparePriceId")));
        String selectedSupplierId = StringUtils.isNotBlank((CharSequence)entity.getRecommendSupplier()) ? entity.getRecommendSupplier().split(",")[0] : null;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter("eq", (Object)con.getLong("comparePriceId")));
        queryParam.setSearchText(searchText);
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("model");
        queryParam.getFuzzyFields().add("unit");
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.iComparePriceSubService.queryPage(queryParam, false);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), ComparePriceSubVO.class);
        voList.stream().forEach(vo -> {
            if (StringUtils.isNotBlank((CharSequence)selectedSupplierId)) {
                QueryParam param = new QueryParam();
                param.getParams().put("comparePriceSubId", new Parameter("eq", (Object)vo.getId()));
                param.getParams().put("supplierId", new Parameter("eq", (Object)selectedSupplierId));
                List supplierEntities = this.iComparePriceSelectedSupplierService.queryList(param, false);
                if (ListUtil.isNotEmpty((List)supplierEntities)) {
                    ComparePriceSelectedSupplierEntity supplierEntity = (ComparePriceSelectedSupplierEntity)((Object)((Object)supplierEntities.get(0)));
                    vo.setRecommendPrice(supplierEntity.getPrice() == null ? "0.00" : supplierEntity.getPrice().toString());
                    vo.setRecommendMoney(supplierEntity.getMoney() == null ? "0.00" : supplierEntity.getMoney().toString());
                } else {
                    vo.setRecommendPrice("0.00");
                    vo.setRecommendMoney("0.00");
                }
            } else {
                vo.setRecommendPrice("0.00");
                vo.setRecommendMoney("0.00");
            }
        });
        Page data = new Page();
        data.setRecords(voList);
        data.setTotal(pageData.getTotal());
        data.setSize(pageData.getSize());
        data.setCurrent(pageData.getCurrent());
        data.setPages(pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be2\u4ef7\u5355\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)data);
    }
}

