/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.controller.SqlParam;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.CommonBillCodeService;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.warn.MaterialWarnVo;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialService")
public class MaterialContractServiceImpl
extends BaseServiceImpl<MaterialContractMapper, MaterialContractEntity>
implements IMaterialContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String DEFAULT_RULE_CODE = "materialContract";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private CommonBillCodeService commonBillCodeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-8N9Au207";
    private static String PARAM_PLAN_PRICE = "P-2Ux27w08";
    private static String PARAM_PRICE_AREA = "P-126hYD10";

    @Override
    public MaterialContractVO save(MaterialContractVO materialContractVO) {
        MaterialContractEntity saveEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        materialContractVO.setBaseMoney(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBaseTaxMoney(materialContractVO.getAmountWithTax());
        materialContractVO.setBeforeChangeMny(materialContractVO.getAmountWithoutTax());
        materialContractVO.setBeforeChangeTaxMny(materialContractVO.getAmountWithTax());
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, 4);
        if (null != materialContractVO.getId()) {
            MaterialContractEntity dbEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)materialContractVO.getId()));
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());
        } else {
            materialContractVO.setCreateUserName(userContext.getUserName());
            if (StringUtils.isBlank((CharSequence)materialContractVO.getCode())) {
                String code = this.commonBillCodeService.getCodeByOrgId(materialContractVO.getOrgId(), "materialContract", (BaseVO)materialContractVO);
                materialContractVO.setCode(code);
            }
            materialContractVO.setChangeVersion(Integer.valueOf(1));
            materialContractVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            materialContractVO.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED);
            saveEntity = (MaterialContractEntity)((Object)BeanMapper.map((Object)materialContractVO, MaterialContractEntity.class));
        }
        super.saveOrUpdate((Object)saveEntity, false);
        return (MaterialContractVO)BeanMapper.map((Object)((Object)saveEntity), MaterialContractVO.class);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_tax_money) as originalAmount, sum(amount_with_tax) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("originalAmount", 0);
            resp.put("curAmount", 0);
        }
        return resp;
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        check.getParams().put("id", new Parameter("ne", (Object)id));
        check.getParams().put("code", new Parameter("eq", (Object)code));
        List contractEntityList = super.queryList(check, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntityList)) {
            return false;
        }
        check.getParams().remove("id");
        check.getParams().put("material_contract_id", new Parameter("ne", (Object)id));
        check.getParams().put("bill_state", new Parameter("ne", (Object)BillStateEnum.PASSED_STATE.getBillStateCode()));
        List changeList = this.contractChangeService.queryList(check, false);
        return !CollectionUtils.isNotEmpty((Collection)changeList);
    }

    @Override
    public void checkContract(Long id) {
        MaterialContractEntity contractEntity = (MaterialContractEntity)((Object)super.selectById((Serializable)id));
        if (contractEntity == null) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u4e0d\u5b58\u5728\uff01");
        }
        if (contractEntity.getBillState() != 1 && contractEntity.getBillState() != 3) {
            throw new BusinessException("\u6240\u9009\u5408\u540c\u672a\u751f\u6548\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> queryAllWarnContracts(List<SqlParam> sqlParamList) {
        return this.materialContractMapper.queryAllWarnContracts(sqlParamList);
    }

    @Override
    public List<MaterialWarnVo> materialProjectOutMny(List<Long> tenantIds) {
        return ((MaterialContractMapper)this.baseMapper).materialProjectOutMny(tenantIds);
    }

    @Override
    public List<MaterialReportVo> getMonthMaterialMny(Long projectId, Integer lastDay) {
        return ((MaterialContractMapper)this.baseMapper).getMonthMaterialMny(projectId, lastDay);
    }

    @Override
    public MaterialReportVo getMaterialContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal settleMny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MaterialContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(MaterialContractEntity::getBillState, billStatus);
        List quoteEntities = super.list((Wrapper)lambda);
        for (MaterialContractEntity ce : quoteEntities) {
            mny = mny.add(ce.getAmountWithTax());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, (Object)projectId);
        lambda2.eq(BaseEntity::getDr, (Object)0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List purchaseSettlementEntities = this.purchaseSettlementService.list((Wrapper)lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            settleMny = settleMny.add(ce.getCurrentSettlementAmountTax() == null ? BigDecimal.ZERO : ce.getCurrentSettlementAmountTax());
        }
        MaterialReportVo vo = new MaterialReportVo();
        vo.setMny(mny);
        vo.setNum(Integer.valueOf(quoteEntities.size()));
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<MaterialContractVO> queryWarnContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnContracts(tenantAllIds);
    }

    @Override
    public List<MaterialContractVO> queryWarnPrePayContracts(List<Long> tenantAllIds) {
        return this.materialContractMapper.queryWarnPrePayContracts(tenantAllIds);
    }

    @Override
    public MaterialPriceVO queryPrice(Integer isJc, Long contractId, MaterialPriceVO vo) {
        Long projectId = vo.getProjectId();
        List detail = vo.getDetail();
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            List<MaterialPriceVO> materialPrices;
            MaterialPriceVO p;
            Long materialId;
            List<MaterialPriceVO> materialPriceVOS;
            List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
            if (projectId != null && 1 != isJc && CollectionUtils.isNotEmpty(materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(projectId, materialIds))) {
                Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVOMap.get(materialId);
                    if (null == p) continue;
                    v.setPlanNum(p.getPlanNum());
                    v.setPlanPrice(p.getPlanPrice());
                }
            }
            if (CollectionUtils.isNotEmpty(materialPrices = this.materialContractMapper.querySettlePriceByTenantId(InvocationInfoProxy.getTenantid(), materialIds))) {
                Map<Long, MaterialPriceVO> priceVO = materialPrices.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                for (MaterialPriceVO v : detail) {
                    materialId = v.getMaterialId();
                    p = priceVO.get(materialId);
                    if (null == p) continue;
                    v.setMinPrice(p.getMinPrice());
                    v.setMaxPrice(p.getMaxPrice());
                    v.setPriceArea(p.getMinPrice().setScale(2, 4) + "~" + p.getMaxPrice().setScale(2, 4));
                }
            }
        }
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List detail = vo.getDetail();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            CommonResponse areaParamByCode;
            BillParamVO billParamVO;
            ArrayList checkDsVOS = new ArrayList();
            if (isJc == 0) {
                CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
                if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
                    billParamVO = (BillParamVO)countParamByCode.getData();
                    Integer n = controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    if (0 != billParamVO.getControlType()) {
                        List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        List<Object> vos = new ArrayList();
                        if (contractId != null) {
                            vos = this.materialContractMapper.queryMaterialContractCount(contractId, vo.getProjectId(), materialIds);
                        }
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        detail.forEach(d -> {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum().multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? (BigDecimal)priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(planNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "count");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u5408\u540c\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u5408\u540c\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u7b7e\u8ba2\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(planNum).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    this.logger.info(countParamByCode.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
                CommonResponse priceParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_PRICE);
                if (priceParamByCode.isSuccess() && null != priceParamByCode.getData()) {
                    BillParamVO billParamVO2 = (BillParamVO)priceParamByCode.getData();
                    Integer n = controlType = billParamVO2.getControlType() > controlType ? billParamVO2.getControlType() : controlType;
                    if (0 != billParamVO2.getControlType()) {
                        BigDecimal roleValue = billParamVO2.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        detail.forEach(d -> {
                            BigDecimal planPrice;
                            BigDecimal _planPrice;
                            BigDecimal price = d.getPrice();
                            if (price.compareTo(_planPrice = (planPrice = d.getPlanPrice()).multiply(divide)) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue).append("%: ").append(_planPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u5355\u4ef7\uff1a").append(price.subtract(_planPrice).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    this.logger.info(priceParamByCode.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
            }
            if ((areaParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PRICE_AREA)).isSuccess() && null != areaParamByCode.getData()) {
                billParamVO = (BillParamVO)areaParamByCode.getData();
                Integer n = controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                if (0 != billParamVO.getControlType()) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                    detail.forEach(d -> {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            if (price.compareTo(_maxPrice) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "unitPrice");
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u5408\u540c\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u4ef7");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u5408\u540c\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u7269\u8d44\u5386\u53f2\u4ef7*").append(roleValue).append("%: ").append(_minPrice.setScale(2, 4)).append("~").append(_maxPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(price.subtract(_maxPrice).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        }
                    });
                }
            } else {
                this.logger.info(areaParamByCode.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }

    @Override
    public void updateSettlementType(Long contractId, Integer settlementType) {
        this.materialContractMapper.updateSettlementType(contractId, settlementType);
    }

    @Override
    public List<MaterialSupplementEntity> querySupplement(Long mainContractId) {
        return this.materialContractMapper.querySupplement(mainContractId);
    }
}

