/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.mapper.PurchaseSettlementMapper;
import com.ejianc.business.material.mapper.PurchaseSettlementMaterialDetailMapper;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.PurchaseSettlementVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSettlementService
extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity>
implements IPurchaseSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PurchaseSettlementMaterialDetailMapper purchaseSettlementMaterialDetailMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private PurchaseSettlementMapper purchaseSettlementMapper;
    private static String PARAM_PLAN_COUNT = "P-41513I11";
    private static String PARAM_PLAN_PRICE = "P-u2AcaJ12";
    private static String PARAM_PRICE_AREA = "P-166rjs14";
    private static String PARAM_PRICE_CONTRACT = "P-hSH85015";

    @Override
    public IPage<PurchaseSettlementVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), PurchaseSettlementVO.class));
        }
        return voPage;
    }

    @Override
    public BigDecimal calculateTotalSettlement(QueryParam queryParam) {
        QueryWrapper query = PurchaseSettlementService.changeToQueryWrapper((QueryParam)queryParam);
        query.select(new String[]{"sum(current_settlement_amount_tax) as totalSettleAmount"});
        Map amount = super.getMap((Wrapper)query);
        return null != amount ? new BigDecimal(amount.get("totalSettleAmount").toString()) : BigDecimal.ZERO.setScale(8);
    }

    @Override
    public void processCost(PurchaseSettlementEntity entity) {
        BigDecimal happenMny;
        BigDecimal rate;
        CostDetailVO c;
        BaseEntity sub;
        int i;
        String factor = "1";
        boolean canPush = true;
        ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
        if (ListUtil.isNotEmpty(entity.getMaterialDetails())) {
            for (i = 0; i < entity.getMaterialDetails().size(); ++i) {
                sub = entity.getMaterialDetails().get(i);
                if (sub.getSubjectId() != null && sub.getSubjectId() > 0L) {
                    c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getMoney() == null ? new BigDecimal("0.00") : sub.getMoney());
                    if (sub.getMoney() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        rate = entity.getTaxRate() == null ? new BigDecimal("1.00") : new BigDecimal("1.00").add(entity.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                        happenMny = sub.getMoney().divide(rate, 8, 4);
                        this.logger.info("\u7269\u8d44\u7ed3\u7b97 happenMny=" + happenMny + " TaxRate=" + rate.toPlainString() + " sub.getMoney()=" + sub.getMoney());
                        c.setHappenMny(happenMny);
                    }
                } else {
                    canPush = false;
                    break;
                }
                c.setHappenDate(entity.getSettlementDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType("\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97");
                c.setSourceTabType("\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97-\u7269\u8d44\u660e\u7ec6\u5b50\u8868");
                list.add(c);
            }
        }
        if (ListUtil.isNotEmpty(entity.getFeeEntities())) {
            for (i = 0; i < entity.getFeeEntities().size(); ++i) {
                sub = entity.getFeeEntities().get(i);
                if (sub.getFeeSubjectId() != null && sub.getFeeSubjectId() > 0L) {
                    c = new CostDetailVO();
                    c.setSubjectId(sub.getFeeSubjectId());
                    c.setSourceDetailId(sub.getId());
                    c.setSourceId(entity.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getMoney() == null ? new BigDecimal("0.00") : sub.getMoney().multiply(new BigDecimal(factor)));
                    if (sub.getMoney() == null) {
                        c.setHappenMny(new BigDecimal("0.00"));
                    } else {
                        rate = entity.getTaxRate() == null ? new BigDecimal("1.00") : new BigDecimal("1.00").add(entity.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                        happenMny = sub.getMoney().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                } else {
                    canPush = false;
                    break;
                }
                c.setHappenDate(entity.getSettlementDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType("\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97");
                c.setSourceTabType("\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97-\u5176\u4ed6\u8d39\u7528\u660e\u7ec6\u5b50\u8868");
                list.add(c);
            }
        }
        if (ListUtil.isEmpty(entity.getFeeEntities()) && ListUtil.isEmpty(entity.getMaterialDetails())) {
            canPush = false;
        }
        if (canPush) {
            CommonResponse response = this.iCostDetailApi.saveSubject(list);
            this.logger.info("\u63a8\u9001\u6210\u672c \u7269\u8d44\u7ed3\u7b97 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag("1");
        } else {
            CommonResponse response = this.iCostDetailApi.deleteSubject(entity.getId());
            this.logger.info("\u5220\u9664\u6210\u672c \u7269\u8d44\u7ed3\u7b97 \u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public ParamsCheckVO checkParams(Integer isJc, Long contractId, BigDecimal settledAmount, BigDecimal currentSettlementAmount, BigDecimal contractAmount, String purchaseMethod, MaterialPriceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List detail = vo.getDetail();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty((Collection)detail)) {
            CommonResponse areaParamByCode;
            BigDecimal roleValue;
            BillParamVO billParamVO;
            BillParamVO billParamVO2;
            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            if (isJc == 0) {
                CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
                if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
                    billParamVO2 = (BillParamVO)countParamByCode.getData();
                    Integer n = controlType = billParamVO2.getControlType() > controlType ? billParamVO2.getControlType() : controlType;
                    if (0 != billParamVO2.getControlType()) {
                        List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                        List<MaterialPriceVO> vos = this.purchaseSettlementMaterialDetailMapper.purchaseSettlementMaterialDetailMapper(vo.getProjectId(), materialIds);
                        Map<Long, BigDecimal> priceVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                        BigDecimal roleValue2 = billParamVO2.getRoleValue();
                        BigDecimal divide = roleValue2.divide(BigDecimal.valueOf(100L));
                        detail.forEach(d -> {
                            BigDecimal num = d.getNum();
                            BigDecimal planNum = d.getPlanNum();
                            BigDecimal _planNum = planNum.multiply(divide);
                            BigDecimal hasNum = priceVOMap.get(d.getMaterialId()) != null ? (BigDecimal)priceVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                            BigDecimal allNum = hasNum.add(num);
                            if (allNum.compareTo(_planNum) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7269\u8d44\u7ed3\u7b97\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u7ed3\u7b97\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue2).append("%:").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    this.logger.info(countParamByCode.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
                CommonResponse priceParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_PRICE);
                if (priceParamByCode.isSuccess() && null != priceParamByCode.getData()) {
                    billParamVO = (BillParamVO)priceParamByCode.getData();
                    Integer n = controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    if (0 != billParamVO.getControlType()) {
                        roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        detail.forEach(d -> {
                            BigDecimal planPrice;
                            BigDecimal price = d.getPrice();
                            if (price.compareTo(planPrice = d.getPlanPrice()) > 0) {
                                BigDecimal _planPrice = planPrice.multiply(divide);
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u5355\u4ef7\u5927\u4e8e\u603b\u8ba1\u5212\u5355\u4ef7");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*").append(roleValue).append("%: ").append(_planPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(price.subtract(_planPrice).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                checkDsVOS.add(paramsCheckDsVO);
                            }
                        });
                    }
                } else {
                    this.logger.info(priceParamByCode.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
            }
            if ((areaParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PRICE_AREA)).isSuccess() && null != areaParamByCode.getData()) {
                billParamVO2 = (BillParamVO)areaParamByCode.getData();
                Integer n = controlType = billParamVO2.getControlType() > controlType ? billParamVO2.getControlType() : controlType;
                if (0 != billParamVO2.getControlType()) {
                    BigDecimal roleValue3 = billParamVO2.getRoleValue();
                    BigDecimal divide = roleValue3.divide(BigDecimal.valueOf(100L));
                    detail.forEach(d -> {
                        BigDecimal price = d.getPrice();
                        BigDecimal maxPrice = d.getMaxPrice() == null ? BigDecimal.ZERO : d.getMaxPrice();
                        BigDecimal minPrice = d.getMinPrice();
                        if (price.compareTo(maxPrice) > 0 && maxPrice.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal _maxPrice = maxPrice.multiply(divide);
                            BigDecimal _minPrice = minPrice.multiply(divide);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                            paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u5355\u4ef7\u5927\u4e8e\u7269\u8d44\u5386\u53f2\u4ef7");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u5355\u4ef7\uff1a").append(price.setScale(2, 4)).append("\uff0c\u7269\u8d44\u5386\u53f2\u4ef7*").append(roleValue3).append("%: ").append(_minPrice.setScale(2, 4)).append("~").append(_maxPrice.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(price.subtract(_maxPrice).setScale(2, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    });
                }
            } else {
                this.logger.info(areaParamByCode.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
            if ("\u9879\u76ee\u81ea\u91c7".equals(purchaseMethod)) {
                CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PRICE_CONTRACT);
                if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
                    billParamVO = (BillParamVO)billParamByCode.getData();
                    roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = contractAmount.multiply(roleValue.divide(BigDecimal.valueOf(100L)));
                    BigDecimal sumPayWithThisMny = settledAmount.add(currentSettlementAmount);
                    if (sumPayWithThisMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u7ed3");
                        paramsCheckDsVO.setWarnName("\u7ed3\u7b97\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\uff1a").append(currentSettlementAmount.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%: ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                } else {
                    this.logger.info(billParamByCode.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                }
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);
            paramsCheckVO.setDataSource(checkDsVOS);
        }
        return paramsCheckVO;
    }

    @Override
    public int queryById(Long id, Long contractId) {
        return this.purchaseSettlementMapper.queryById(id, contractId);
    }

    @Override
    public int queryByContractId(Long contractId) {
        return this.purchaseSettlementMapper.queryByContractId(contractId);
    }
}

