package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class OutStoreService extends BaseServiceImpl<OutStoreMapper, OutStoreEntity> implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        IPage<OutStoreVO> voPage = null;
        IPage<OutStoreEntity> entityPage = super.queryPage(queryParam,isEs);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(),OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if(ListUtil.isNotEmpty(entity.getOutStoreSubEntities())){
            List<CostDetailVO> list = new ArrayList<>();
            boolean canPush = true;
            for (int i = 0;i<entity.getOutStoreSubEntities().size();i++){
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if(sub.getSubjectId()!=null && sub.getSubjectId()>0L){
                    CostDetailVO c = new CostDetailVO();
                    c.setSubjectId(sub.getSubjectId());
                    c.setSourceId(entity.getId());
                    c.setSourceDetailId(sub.getId());
                    c.setProjectId(entity.getProjectId());
                    c.setHappenTaxMny(sub.getAmount()==null?new BigDecimal("0.00"):sub.getAmount().multiply(new BigDecimal(factor)));
                    if(sub.getAmount()==null){
                        c.setHappenMny(new BigDecimal("0.00"));
                    }else {
                        BigDecimal rate = sub.getTaxRate()== null?(new BigDecimal("1.00")):new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"),8,BigDecimal.ROUND_HALF_UP));
                        BigDecimal happenMny = sub.getAmount().divide(rate,8,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(factor));
                        c.setHappenMny(happenMny);
                    }
                    c.setHappenDate(entity.getOutDate());
                    c.setMemo(entity.getMemo());
                    c.setCreateUserName(sessionManager.getUserContext().getUserName());
                    c.setSourceType(MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType()));
                    c.setSourceTabType(MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"子表");
                    list.add(c);
                }else {
                    canPush = false;
                    break;
                }
            }
            if(canPush){
                CommonResponse<String> response = iCostDetailApi.saveSubject(list);
                logger.info("推送成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
                entity.setRelationFlag("1");
            }else {
                CommonResponse<String> response = iCostDetailApi.deleteSubject(entity.getId());
                logger.info("删除成本"+MaterialStoreType.getStoreTypeNameByCode(entity.getStoreType())+"结果:"+response.isSuccess()+" msg:"+response.getMsg()+" billId="+entity.getId());
                entity.setRelationFlag("0");
            }
        }else {
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    /**
     * @param topN
     * @param type
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate("yyyy-MM-dd",DateUtil.beginOfYear(new Date()));
        startDate = "'"+startDate+"'";
        List<OutStoreSubVO> outStoreSubEntities = outStoreSubMapper.queryMaterialCostTopN(topN,type,startDate,orgIds);
        List<JSONObject> result = new ArrayList<>();
        logger.info("查询物资开累年累消耗top n outStoreSubEntities 数量："+(ListUtil.isNotEmpty(outStoreSubEntities)?outStoreSubEntities.size():"空")+" 当前orgId："+InvocationInfoProxy.getOrgId());
        if(ListUtil.isNotEmpty(outStoreSubEntities)){
            outStoreSubEntities.forEach(en->{
                JSONObject object = new JSONObject();
                object.put("materialName",en.getMaterialName());
                object.put("materialSpec",en.getMaterialSpec());
                object.put("materialUnit",en.getMaterialUnit());
                object.put("outStoreNumber",en.getOutStoreNumber());
                object.put("amount",en.getAmount());
                object.put("weight",en.getUnitPrice().multiply(new BigDecimal("100")).setScale(0,BigDecimal.ROUND_HALF_UP)+"%");
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }
}
