/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.mapper.InstoreMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instoreMaterialService")
public class InstoreMaterialService
extends BaseServiceImpl<InstoreMaterialMapper, InstoreMaterialEntity>
implements IInstoreMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InstoreMaterialMapper instoreMaterialMapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-D80E4406";
    @Autowired
    private MaterialContractMapper materialContractMapper;

    @Override
    public List<InstoreMaterialVO> querylist(QueryWrapper<InstoreMaterialEntity> queryWrapper) {
        List list = this.list((Wrapper)queryWrapper);
        return BeanMapper.mapList((Iterable)list, InstoreMaterialVO.class);
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.eq((Object)"dr", (Object)0);
        return this.instoreMaterialMapper.countAmount((QueryWrapper<InstoreEntity>)queryWrapper);
    }

    @Override
    public IPage<InstoreMaterialVO> queryStoreCanUseNumPageData(String searchText, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        Page page = new Page();
        page.setCurrent((long)pageNum.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreMaterialMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<InstoreMaterialVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        Page page = new Page();
        Long count = this.instoreMaterialMapper.countStorematerialList(storeId, searchText);
        if (count > 0L) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent((long)pageNumber.intValue());
                page.setSize((long)pageSize.intValue());
            }
            List<InstoreMaterialVO> list = this.instoreMaterialMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count.longValue());
        return page;
    }

    @Override
    public InstoreMaterialVO censusStorematerial(Long storeIid) {
        return this.instoreMaterialMapper.censusStorematerial(storeIid);
    }

    @Override
    public IPage<InstoreMaterialVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds) {
        Page page = new Page();
        page.setCurrent((long)pageNumber.intValue());
        page.setPages((long)pageSize.intValue());
        page.setSize((long)pageSize.intValue());
        Long count = this.instoreMaterialMapper.queryUsableSubMaterialCount(searchText, outDate, storeId, materialIds);
        page.setTotal(count.longValue());
        List<InstoreMaterialVO> records = this.instoreMaterialMapper.queryUsableSubMaterialPageList(searchText, outDate, storeId, (pageNumber - 1) * pageSize, pageSize, materialIds);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<InstoreMaterialVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return this.instoreMaterialMapper.querySubMaterialStoreInfo(storeId, checkDate, materialId, inventory);
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        ArrayList checkDsVOS;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List detail = vo.getDetail();
        paramsCheckVO.setWarnType(paramsArray[0]);
        if (CollectionUtils.isEmpty((Collection)detail)) {
            return paramsCheckVO;
        }
        CommonResponse countParamByCode = this.paramConfigApi.getBillParamByCode(PARAM_PLAN_COUNT);
        if (countParamByCode.isSuccess() && null != countParamByCode.getData()) {
            BillParamVO billParamVO = (BillParamVO)countParamByCode.getData();
            paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            checkDsVOS = new ArrayList();
            if (0 != billParamVO.getControlType()) {
                List<Long> materialIds = detail.stream().map(MaterialPriceVO::getMaterialId).collect(Collectors.toList());
                List<MaterialPriceVO> vos = this.instoreMaterialMapper.queryMaterialInstoreCount(vo.getProjectId(), materialIds);
                List<MaterialPriceVO> materialPriceVOS = this.materialContractMapper.queryPlanPriceByProjectId(vo.getProjectId(), materialIds);
                if (CollectionUtils.isNotEmpty(materialPriceVOS)) {
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account, (v1, v2) -> v2));
                    for (MaterialPriceVO v : detail) {
                        Long materialId = v.getMaterialId();
                        MaterialPriceVO p = priceVOMap.get(materialId);
                        if (null == p) continue;
                        v.setPlanNum(p.getPlanNum());
                        v.setPlanPrice(p.getPlanPrice());
                    }
                }
                Map<Long, BigDecimal> numVOMap = vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                detail.forEach(d -> {
                    BigDecimal _planNum;
                    BigDecimal num = d.getNum();
                    BigDecimal planNum = d.getPlanNum();
                    BigDecimal hasNum = numVOMap.get(d.getMaterialId()) != null ? (BigDecimal)numVOMap.get(d.getMaterialId()) : BigDecimal.ZERO;
                    BigDecimal allNum = hasNum.add(num);
                    if (allNum.compareTo(_planNum = planNum.multiply(divide)) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "instoreNumber");
                        paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                        paramsCheckDsVO.setWarnName("\u6750\u6599\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u603b\u8ba1\u5212\u6570\u91cf");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u5df2\u5165\u5e93\u6570\u91cf\uff1a").append(hasNum.setScale(2, 4)).append("\uff0c\u603b\u8ba1\u5212\u6570\u91cf*").append(roleValue).append("%: ").append(_planNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(allNum.subtract(_planNum).setScale(2, 4));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                });
            }
        } else {
            this.logger.info(countParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        paramsCheckVO.setDataSource(checkDsVOS);
        return paramsCheckVO;
    }
}

