package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.bean.MaterialSupplementEntity;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IMaterialSupplementService;
import com.ejianc.business.material.vo.MaterialSupplementVO;
import com.ejianc.business.material.vo.SupplementContractRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资合同补充协议
 *
 * @author generator
 */
@Controller
@RequestMapping("materialSupplement")
public class MaterialSupplementController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialSupplementService service;

    @Autowired
    private IMaterialContractService materialContractService;

    @Autowired
    private IMaterialSupplementService materialSupplementService;


    @Autowired
    private IContractChangeService contractChangeService;



    private static final String SUPPLEMENT_BILL_CODE = "MATERIAL_SUPPLEMENT";

    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SupplementContractRecordVO> queryDetailRecord(Long id) {
        SupplementContractRecordVO vo = materialSupplementService.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /***
     * @description:补充协议新增获取合同信息
     *
     * @param contractId 合同id
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.MaterialSupplementVO>
     * @author songlx
     * @date: 2021/6/28
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> addConvertByConId(Long contractId) {
        MaterialSupplementVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> saveOrUpdate(@RequestBody MaterialSupplementVO saveorUpdateVO) {
        Long mainContractId = saveorUpdateVO.getMainContractId();
        if(mainContractId != null){
            CommonResponse.error("不存在主合同，保存失败！");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<MaterialContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(MaterialContractEntity::getId, mainContractId);
        lambda.eq(MaterialContractEntity::getTenantId, tenantId);
        lambda.eq(MaterialContractEntity::getSettlementType, 1);
        List<MaterialContractEntity> list = materialContractService.list(lambda);
        if(CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("该合同在相同组织下已经完工，不允许变更！");
        }
        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<MaterialSupplementEntity> lambdaQuery = new LambdaQueryWrapper<>();
        lambdaQuery.eq(MaterialSupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(MaterialSupplementEntity::getMainContractId, mainContractId);
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
            lambdaQuery.ne(MaterialSupplementEntity::getId, saveorUpdateVO.getId());
        }
        lambdaQuery.ne(MaterialSupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(MaterialSupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = materialSupplementService.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }
        //补充协议只能存在一条未生效的变更单
        LambdaQueryWrapper<ContractChangeEntity> lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ContractChangeEntity::getTenantId, tenantId);
        lambdachange.eq(ContractChangeEntity::getMaterialContractId, saveorUpdateVO.getMainContractId());
        lambdachange.ne(ContractChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = contractChangeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(saveorUpdateVO.getCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                saveorUpdateVO.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(saveorUpdateVO.getId() == null){
            saveorUpdateVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        }
        MaterialSupplementEntity entity = BeanMapper.map(saveorUpdateVO, MaterialSupplementEntity.class);
        service.saveOrUpdate(entity, false);
        MaterialSupplementVO vo = BeanMapper.map(entity, MaterialSupplementVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialSupplementVO> queryDetail(Long id) {
        MaterialSupplementEntity entity = service.selectById(id);
        MaterialSupplementVO vo = BeanMapper.map(entity, MaterialSupplementVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialSupplementVO> vos) {
        service.removeByIds(vos.stream().map(MaterialSupplementVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialSupplementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<MaterialSupplementEntity> page = service.queryPage(param, false);
        IPage<MaterialSupplementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialSupplementVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
