package com.ejianc.business.material.vo;

import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/12  出库子表
 * @Description OutStoreSubEntity
 */

public class OutStoreSubVO extends BaseVO {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
     * 主表id
     */
    private Long pid;

    /**
     * 仓库id
     */
    private Long storeId;

    /**
     * 出库物资占用库存状态，根据主表billState状态判断
     * 已提交和已通过的，状态为扣减库存态：1
     * 新增和审批中的均为库存占用态：0
     * 参见com.ejianc.business.material.pub.MaterialStoreState.java
     */
    private Integer storeState;

    /**
     * 出库类型,参见
     * com.ejianc.business.material.pub.MaterialStoreType.java 出库类型
     */
    private Integer storeType;

    /**
     * 出库类型名称（参照使用）
     * 
     */
    private String storeTypeName;

    /**
     * 出库日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate;

    /**
     * 物资分类名称
     */
    private String materialCategoryName;

    /**
     * 物资分类id
     */
    private Long materialCategoryId;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 规格型号
     */
    private String materialSpec;

    /**
     * 计量单位
     */
    private String materialUnit;

    /**
     * 出库数量
     */
    private BigDecimal outStoreNumber;

    /**
     * 单价
     */
    private BigDecimal unitPrice;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 剩余可退库数量
     */
    private BigDecimal surplusNumber;

    /**
     * 备注
     */
    private String remark;

    /**
     * 数据来源主表出库单id
     */
    private Long sourceMainId;

    /**
     * 数据来源出库单子表id
     */
    private Long sourceSubId;

    /**
     * 导入失败原因
     */
    private String errorMessage;

    /**
     * 退货金额差
     */
    private BigDecimal moneyDisparity;

    /**
     * 入库单价
     */
    private BigDecimal inStorePrice;

    /**
     * 入库金额
     */
    private BigDecimal inStoreMoney;

    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Integer getStoreState() {
        return storeState;
    }

    public void setStoreState(Integer storeState) {
        this.storeState = storeState;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }

    public BigDecimal getOutStoreNumber() {
        return outStoreNumber;
    }

    public void setOutStoreNumber(BigDecimal outStoreNumber) {
        this.outStoreNumber = outStoreNumber;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getSourceMainId() {
        return sourceMainId;
    }

    public void setSourceMainId(Long sourceMainId) {
        this.sourceMainId = sourceMainId;
    }

    public Long getSourceSubId() {
        return sourceSubId;
    }

    public void setSourceSubId(Long sourceSubId) {
        this.sourceSubId = sourceSubId;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public BigDecimal getMoneyDisparity() {
        return moneyDisparity;
    }

    public void setMoneyDisparity(BigDecimal moneyDisparity) {
        this.moneyDisparity = moneyDisparity;
    }

    public BigDecimal getInStorePrice() {
        return inStorePrice;
    }

    public void setInStorePrice(BigDecimal inStorePrice) {
        this.inStorePrice = inStorePrice;
    }

    public BigDecimal getInStoreMoney() {
        return inStoreMoney;
    }

    public void setInStoreMoney(BigDecimal inStoreMoney) {
        this.inStoreMoney = inStoreMoney;
    }
    
	public BigDecimal getSurplusNumber() {
		return surplusNumber;
	}

	public void setSurplusNumber(BigDecimal surplusNumber) {
		this.surplusNumber = surplusNumber;
	}

	public String getStoreTypeName() {
		if(storeType==MaterialStoreType.PICKING_OUT_STORE.getCode()){
			return "领料出库";
		}else if(storeType==MaterialStoreType.STRAIGHT_OUT_STORE.getCode()){
			return "直入直出";
		}else if(storeType==MaterialStoreType.ALLOCATION_OUT_STORE.getCode()){
			return "调拨出库";
		}else if(storeType==MaterialStoreType.RETURN_GOODS_OUT_STORE.getCode()){
			return "退货出库";
		}
		return storeTypeName;
	}

	public void setStoreTypeName(String storeTypeName) {
		this.storeTypeName = storeTypeName;
	}

    @ReferSerialTransfer(referCode="cost-subject-set")
    public Long getSubjectId() {
        return subjectId;
    }

    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
}
