package com.ejianc.business.plan.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 物资总计划变更-材料实体
 *
 * @author CJ
 * @Description: 物资总计划变更-材料实体
 * @date 2021/3/5 9:28
 */
@TableName(value = "ejc_material_master_plan_sub_change")
public class PlanChangeSubEntity extends BaseEntity {

    private static final long serialVersionUID = 1883656980223784424L;

    /**
     * 所属总计划Id
     */
    @TableField(value = "material_master_plan_id")
    private Long materialMasterPlanId;

    /**
     * 物资分类Id
     */
    @TableField(value = "material_category_id")
    private Long materialCategoryId;
    /**
     * 物资分类名称
     */
    @TableField(value = "material_category_name")
    private String materialCategoryName;
    /**
     * 物资Id
     */
    @TableField(value = "material_id")
    private Long materialId;
    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;
    /**
     * 规格型号
     */
    @TableField(value = "spec")
    private String spec;
    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 原始数量
     */
    @TableField(value = "original_num")
    private Double originalNum;
    /**
     * 数量
     */
    @TableField(value = "num")
    private Double num;
    /**
     * 单价
     */
    @TableField(value = "price")
    private BigDecimal price;
    /**
     * 金额
     */
    @TableField(value = "amount")
    private BigDecimal amount;

    /**
     * 物资来源：1-物料档案，2-导入
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 物资来源出业务Id
     */
    @TableField(value = "source_id")
    private String sourceId;

    /**
     * 变更类型
     */
    @TableField(value = "change_type")
    private String changeType;

    /**
     * 变更项数据Id
     */
    @TableField(value = "target_id")
    private Long targetId;

    public Double getOriginalNum() {
        return originalNum;
    }

    public void setOriginalNum(Double originalNum) {
        this.originalNum = originalNum;
    }

    public Long getMaterialMasterPlanId() {
        return materialMasterPlanId;
    }

    public void setMaterialMasterPlanId(Long materialMasterPlanId) {
        this.materialMasterPlanId = materialMasterPlanId;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getNum() {
        return num;
    }

    public void setNum(Double num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public Long getTargetId() {
        return targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }
}
