/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IInstoreMaterialService;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.InstoreExportVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.business.pub.tax.TaxCalculateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/instore/"})
public class InstoreController {
    private static final String BILL_CODE = "MATERIAL-INSTORE";
    @Autowired
    IInstoreService instoreService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IInstoreMaterialService instoreMaterialService;
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    IStoreService storeService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"checkParamsById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParamsById(@RequestBody MaterialPriceVO vo) {
        Long projectId;
        InstoreEntity byId;
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        Long id = vo.getId();
        if (id != null && null != (byId = (InstoreEntity)((Object)this.instoreService.selectById(id))) && null != (projectId = byId.getProjectId())) {
            List<InstoreMaterialEntity> instoreMaterialList;
            vo.setProjectId(projectId);
            if (CollectionUtils.isEmpty((Collection)vo.getDetail()) && CollectionUtils.isNotEmpty(instoreMaterialList = byId.getInstoreMaterialList())) {
                ArrayList detail = new ArrayList();
                instoreMaterialList.forEach(item -> {
                    MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                    materialPriceVO.setId(item.getMaterialId());
                    materialPriceVO.setMaterialId(item.getMaterialId());
                    materialPriceVO.setMaterialName(item.getMaterialName());
                    materialPriceVO.setSpec(item.getMaterialSpec());
                    materialPriceVO.setNum(item.getInstoreNumber());
                    detail.add(materialPriceVO);
                });
                vo.setDetail(detail);
            }
            paramsCheckVO = this.instoreMaterialService.checkParams(vo);
        }
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MaterialPriceVO vo) {
        ParamsCheckVO paramsCheckVO = this.instoreMaterialService.checkParams(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreVO> saveOrUpdate(@RequestBody InstoreVO vo) {
        List entities = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.beforeSave(vo);
        InstoreEntity entity = (InstoreEntity)((Object)BeanMapper.map((Object)vo, InstoreEntity.class));
        if (StringUtils.isEmpty((CharSequence)vo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            QueryParam queryParam;
            if (entity.getId() == null || entity.getId() == 0L) {
                queryParam = new QueryParam();
                queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
                queryParam.getParams().put("bill_code", new Parameter("eq", (Object)vo.getBillCode()));
                entities = this.instoreService.queryList(queryParam, false);
            } else {
                queryParam = new QueryParam();
                queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
                queryParam.getParams().put("bill_code", new Parameter("eq", (Object)vo.getBillCode()));
                queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
                entities = this.instoreService.queryList(queryParam, false);
            }
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u5355\u53f7\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setUserName(this.sessionManager.getUserContext().getUserName());
            entity.setPaymentFlag(0);
        }
        this.instoreService.saveOrUpdate((Object)entity, false);
        InstoreVO backVo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    public void beforeSave(InstoreVO vo) {
        if (vo.getTaxRate() == null && !MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
            vo.setTaxRate(new BigDecimal("0.00"));
        }
        BigDecimal totalCount = new BigDecimal(0);
        BigDecimal totalAmount = new BigDecimal(0);
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if (!ListUtil.isEmpty((List)vo.getInstoreMaterialList())) {
            String materialName = "";
            for (InstoreMaterialVO sub : vo.getInstoreMaterialList()) {
                if ("del".equals(sub.getRowState())) continue;
                sub.setStoreId(vo.getStoreId());
                sub.setInstoreDate(vo.getInstoreDate());
                sub.setStoreState(MaterialStoreState.STORING.getCode());
                sub.setInstoreType(vo.getInstoreType());
                materialName = materialName.length() > 0 ? materialName + "\u3001" + sub.getMaterialName() : materialName + sub.getMaterialName();
                totalCount = totalCount.add(sub.getInstoreNumber());
                totalAmount = totalAmount.add(sub.getAmount());
                if (!MaterialStoreType.RETURN_IN_STORE.getCode().equals(vo.getInstoreType())) {
                    sub.setTaxRate(vo.getTaxRate());
                }
                totalAmountNoTax = totalAmountNoTax.add(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate() == null ? new BigDecimal("0.00") : sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4)), 8, 4));
            }
            vo.setMaterialName(materialName);
        }
        vo.setTotalAmount(totalAmount);
        vo.setTotalAmountNoTax(totalAmountNoTax);
        vo.setTotalCount(totalCount);
        if ("hasContract".equals(vo.getContractType())) {
            this.materialContractService.checkContract(vo.getContractId());
        }
    }

    @RequestMapping(value={"pushToCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreVO> pushToCost(@RequestBody InstoreVO vo) {
        this.beforeSave(vo);
        InstoreEntity entity = (InstoreEntity)((Object)BeanMapper.map((Object)vo, InstoreEntity.class));
        this.instoreService.processCost(entity);
        this.instoreService.saveOrUpdate((Object)entity, false);
        InstoreVO backVo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u5173\u8054\u6210\u529f\uff01", (Object)backVo);
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InstoreVO> queryDetail(Long id) {
        InstoreEntity entity = (InstoreEntity)((Object)this.instoreService.selectById(id));
        InstoreVO vo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        IPage<InstoreVO> page = this.instoreService.queryForList(param, false);
        List list = page.getRecords();
        BigDecimal allTotalAmount = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            allTotalAmount = this.instoreMaterialService.countAmount(param);
        }
        for (InstoreVO vo : list) {
            vo.setAllTotalAmount(allTotalAmount);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", this.instoreService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InstoreVO> vos) {
        this.instoreService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage<InstoreVO> voPage = this.instoreService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        ArrayList exportVOS = new ArrayList();
        list.forEach(vo -> {
            InstoreExportVO exportVO = (InstoreExportVO)BeanMapper.map((Object)vo, InstoreExportVO.class);
            exportVO.setCreateTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getCreateTime()));
            exportVO.setInstoreDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getInstoreDate()));
            if (vo.getReceiveDate() != null) {
                exportVO.setReceiveDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)vo.getReceiveDate()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getReceiveState())) {
                if ("1".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("\u5f85\u6536");
                } else if ("2".equals(vo.getReceiveState())) {
                    exportVO.setReceiveState("\u5df2\u6536\u6599");
                } else {
                    exportVO.setReceiveState("\u5df2\u9000\u56de\uff1a" + vo.getPickReturnReason());
                }
            }
            exportVO.setBillState(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        String fileName = "instoreListExport.xlsx";
        if (queryParam.getParams().get("instoreType") != null) {
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.RECEIVE_IN_STORE.getCode().toString())) {
                fileName = "instoreListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.STRAIGHT_IN_STORE.getCode().toString())) {
                fileName = "straightInoutListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.RETURN_IN_STORE.getCode().toString())) {
                fileName = "pickReturnListExport.xlsx";
            }
            if (((Parameter)queryParam.getParams().get("instoreType")).getValue().toString().equals(MaterialStoreType.ALLOCATION_IN_STORE.getCode().toString())) {
                fileName = "allocationInExport.xlsx";
            }
        }
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-import.xlsx", (String)"\u7269\u6599\u5bfc\u5165\u6a21\u677f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<InstoreMaterialVO> successList = new ArrayList<InstoreMaterialVO>();
        ArrayList<InstoreMaterialVO> errorList = new ArrayList<InstoreMaterialVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 12) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                InstoreMaterialVO instoreMaterialVO = new InstoreMaterialVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(0)).length() > 20) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u5206\u7c7b\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    instoreMaterialVO.setMaterialCategoryName((String)datas.get(0));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(1)).length() > 20) {
                    instoreMaterialVO.setErrorMessage("\u7269\u8d44\u540d\u79f0\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    instoreMaterialVO.setMaterialName((String)datas.get(1));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    instoreMaterialVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(2)).length() > 20) {
                    instoreMaterialVO.setErrorMessage("\u89c4\u683c\u578b\u53f7\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    instoreMaterialVO.setMaterialSpec((String)datas.get(2));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    instoreMaterialVO.setErrorMessage("\u8ba1\u91cf\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879");
                } else if (((String)datas.get(3)).length() > 20) {
                    instoreMaterialVO.setErrorMessage("\u8ba1\u91cf\u5355\u4f4d\u586b\u5199\u957f\u5ea6\u4e3a0~20\u5b57");
                } else {
                    instoreMaterialVO.setMaterialUnit((String)datas.get(3));
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) || ((String)datas.get(11)).length() <= 50) {
                    instoreMaterialVO.setRemark((String)datas.get(11));
                }
                instoreMaterialVO.setSourceType("import");
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    try {
                        instoreMaterialVO.setInstoreNumber(new BigDecimal((String)datas.get(5)));
                        if (instoreMaterialVO.getInstoreNumber().longValue() < 0L) {
                            instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                        }
                    }
                    catch (Exception e) {
                        instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    instoreMaterialVO.setErrorMessage("\u5165\u5e93\u6570\u91cf\u4e3a\u5fc5\u586b\u9879");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        instoreMaterialVO.setUnitPrice(new BigDecimal((String)datas.get(6)));
                        if (!(instoreMaterialVO.getUnitPrice().doubleValue() < 0.0)) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        instoreMaterialVO.setErrorMessage("\u5355\u4ef7\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                } else {
                    instoreMaterialVO.setUnitPrice(new BigDecimal(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    instoreMaterialVO.setTaxDetailRate(new BigDecimal((String)datas.get(4)));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    instoreMaterialVO.setTaxUnitPrice(new BigDecimal((String)datas.get(7)));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8)))) {
                    instoreMaterialVO.setTotalAmount(new BigDecimal((String)datas.get(8)));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9)))) {
                    instoreMaterialVO.setTaxTotalAmount(new BigDecimal((String)datas.get(9)));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10)))) {
                    instoreMaterialVO.setTaxDetail(new BigDecimal((String)datas.get(10)));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)instoreMaterialVO.getErrorMessage())) {
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setName(instoreMaterialVO.getMaterialName());
                    materialVO.setSpec(instoreMaterialVO.getMaterialSpec());
                    materialVO.setUnitName(instoreMaterialVO.getMaterialUnit());
                    materialVO.setCategoryName(String.valueOf(datas.get(0)));
                    CommonResponse back = this.materialApi.queryExcelFlag(materialVO);
                    if (back.isSuccess()) {
                        List backVOList = (List)back.getData();
                        if (backVOList != null && backVOList.size() > 0) {
                            MaterialVO vo = (MaterialVO)backVOList.get(0);
                            instoreMaterialVO.setMaterialCategoryId(vo.getCategoryId());
                            instoreMaterialVO.setMaterialCategoryName(vo.getCategoryName());
                            instoreMaterialVO.setMaterialId(vo.getId());
                            successList.add(instoreMaterialVO);
                            continue;
                        }
                        instoreMaterialVO.setErrorMessage("\u7269\u8d44\u6863\u6848\u4e0d\u5b58\u5728");
                    } else {
                        instoreMaterialVO.setErrorMessage("\u7269\u8d44\u6863\u6848\u6821\u9a8c\u5931\u8d25");
                    }
                    instoreMaterialVO.setId(Long.valueOf(i));
                    errorList.add(instoreMaterialVO);
                    continue;
                }
                errorList.add(instoreMaterialVO);
            }
        }
        new TaxCalculateUtil().calculate(successList);
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"sureToReceive"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReceive(@RequestBody InstoreVO vo) {
        InstoreEntity entity = (InstoreEntity)((Object)this.instoreService.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setStoreId(vo.getStoreId());
        entity.setStoreName(vo.getStoreName());
        entity.setBillState(1);
        entity.setReceiveState(MaterialAllocationState.RECEIVED.getCode());
        this.instoreService.sureToReceive(entity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"sureToReturn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sureToReturn(@RequestBody InstoreVO vo) {
        InstoreEntity entity = (InstoreEntity)((Object)this.instoreService.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setReceivePerson(vo.getReceivePerson());
        entity.setReceiveDate(vo.getReceiveDate());
        entity.setReceiveState(MaterialAllocationState.REJECT.getCode());
        entity.setPickReturnReason(vo.getPickReturnReason());
        this.instoreService.sureToReturn(entity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryRefNopaymnetList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        Long orgId = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            orgId = Long.parseLong(json.get((Object)"orgId").toString());
            if (json.get((Object)"contractType") != null) {
                param.getParams().put("contractType", new Parameter("in", json.get((Object)"contractType")));
            }
            if (json.get((Object)"supplierId") != null) {
                param.getParams().put("supplierId", new Parameter("eq", json.get((Object)"supplierId")));
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("instoreType", new Parameter("in", (Object)"1,2"));
        ComplexParam c4 = new ComplexParam();
        c4.setLogic("and");
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("or");
        c5.getParams().put("paymentFlag", new Parameter("eq", (Object)"0"));
        c4.getComplexParams().add(c5);
        ComplexParam c6 = new ComplexParam();
        c6.setLogic("or");
        c6.getParams().put("paymentFlag", new Parameter("eq", null));
        c4.getComplexParams().add(c6);
        param.getComplexParams().add(c4);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        IPage<InstoreVO> page = this.instoreService.queryForList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5165\u5e93\u5355\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"queryRefNotSettlementList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryRefNotSettlementList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            param.getParams().put("orgId", new Parameter("eq", json.get((Object)"orgId")));
            if (json.get((Object)"contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", json.get((Object)"contractId")));
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        param.getParams().put("instoreType", new Parameter("in", (Object)"1,2"));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("settlementFlag", new Parameter("eq", (Object)"0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("settlementFlag", new Parameter("eq", null));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialName");
        IPage<InstoreVO> page = this.instoreService.queryForList(param, false);
        this.setType(page.getRecords());
        return CommonResponse.success((String)"\u67e5\u8be2\u5165\u5e93\u5355\u6570\u636e\u6210\u529f\uff01", page);
    }

    public void setType(List<InstoreVO> list) {
        if (ListUtil.isNotEmpty(list)) {
            list.forEach(l -> {
                InstoreEntity entity = (InstoreEntity)((Object)((Object)this.instoreService.selectById(l.getId())));
                if (ListUtil.isNotEmpty(entity.getInstoreMaterialList())) {
                    List<InstoreMaterialEntity> entities = entity.getInstoreMaterialList();
                    l.setInstoreMaterialList(BeanMapper.mapList(entities, InstoreMaterialVO.class));
                }
                l.setInstoreTypeName(MaterialStoreType.getStoreTypeNameByCode((Integer)l.getInstoreType()));
            });
        }
    }

    @GetMapping(value={"printDetail"})
    @ResponseBody
    public JSONObject printDetail(@RequestParam(value="id") Long id) {
        JSONObject resp = new JSONObject();
        JSONObject data = new JSONObject();
        InstoreEntity entity = (InstoreEntity)((Object)this.instoreService.selectById(id));
        Map entityMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)entity)), Map.class);
        entityMap.put("InstoreMaterial", entityMap.get("instoreMaterialList"));
        entityMap.remove("instoreMaterialList");
        data.put("Instore", (Object)entityMap);
        resp.put("data", (Object)data);
        resp.put("code", (Object)0);
        resp.put("msg", (Object)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01");
        return resp;
    }

    @RequestMapping(value={"queryPhotographList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InstoreVO>> queryPhotographList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        param.getOrderMap().put("createTime", "desc");
        IPage<InstoreVO> page = this.instoreService.queryForList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"saveOrUpdatePhotograph"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InstoreVO> saveOrUpdatePhotograph(@RequestBody InstoreVO vo) {
        if (vo.getId() == null || vo.getId() == 0L) {
            vo.setTaxRate(new BigDecimal("0.00"));
            BigDecimal totalCount = new BigDecimal(0);
            BigDecimal totalAmount = new BigDecimal(0);
            BigDecimal totalAmountNoTax = new BigDecimal(0);
            vo.setTotalAmount(totalAmount);
            vo.setTotalAmountNoTax(totalAmountNoTax);
            vo.setTotalCount(totalCount);
            vo.setContractType("hasContract");
            vo.setInstoreType(MaterialStoreType.STRAIGHT_IN_STORE.getCode());
            CommonResponse response = this.projectApi.queryProjectList(1);
            if (!response.isSuccess() || ListUtil.isEmpty((List)((List)response.getData()))) {
                return CommonResponse.error((String)"\u6ca1\u627e\u5230\u4efb\u4f55\u9879\u76ee\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\u9879\u76ee\uff01");
            }
            ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)response.getData()).get(0);
            vo.setOrgId(projectRegisterVO.getProjectDepartmentId());
            vo.setOrgName(projectRegisterVO.getName());
            vo.setProjectId(projectRegisterVO.getId());
            vo.setProjectName(projectRegisterVO.getName());
            vo.setInstoreDate(new Date());
            StoreVO storeVO = this.storeService.queryNewestStoreByOrgId(projectRegisterVO.getProjectDepartmentId());
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (storeVO != null) {
                vo.setStoreId(storeVO.getId());
                vo.setStoreName(vo.getStoreName());
            }
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            vo.setBillCode((String)billCode.getData());
            vo.setUserName(this.sessionManager.getUserContext().getUserName());
            vo.setPaymentFlag(Integer.valueOf(0));
        }
        InstoreEntity entity = (InstoreEntity)((Object)BeanMapper.map((Object)vo, InstoreEntity.class));
        this.instoreService.saveOrUpdate((Object)entity, false);
        InstoreVO backVo = (InstoreVO)BeanMapper.map((Object)((Object)entity), InstoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }
}

