/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.mapper.ReportMapper;
import com.ejianc.business.material.service.IReportService;
import com.ejianc.business.material.vo.BuyPriceDetailVO;
import com.ejianc.business.material.vo.BuyPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportService
implements IReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ReportMapper reportMapper;

    @Override
    public List<BuyPriceVO> queryBuyPriceList(Page<BuyPriceVO> page, QueryParam param) {
        Map params = param.getParams();
        Parameter para = (Parameter)params.get("materialTypeIds");
        List<Long> materialTypeIds = para != null && para.getValue() != null ? ReportService.castList(para.getValue()) : null;
        String startDate = this.getParamValue(params, "startDate") == null ? null : "'" + this.getParamValue(params, "startDate") + "'";
        String endDate = this.getParamValue(params, "endDate") == null ? null : "'" + this.getParamValue(params, "endDate") + "'";
        String materialTypeName = this.getParamValue(params, "materialTypeName");
        String materialName = this.getParamValue(params, "materialName");
        String model = this.getParamValue(params, "model");
        String unit = this.getParamValue(params, "unit");
        return this.reportMapper.queryBuyPrice(InvocationInfoProxy.getTenantid(), materialTypeIds, startDate, endDate, materialTypeName, materialName, model, unit);
    }

    public static List<Long> castList(Object obj) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(Long.valueOf(o.toString()));
            }
            return result;
        }
        return null;
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @Override
    public List<BuyPriceVO> queryBuyPriceList(QueryParam param) {
        Map params = param.getParams();
        Long tenantId = params.get("tenantId") != null ? Long.valueOf(String.valueOf(((Parameter)params.get("tenantId")).getValue())) : null;
        return this.reportMapper.queryBuyPriceList(tenantId);
    }

    @Override
    public List<BuyPriceDetailVO> queryBuyPriceDetailList(QueryParam param) {
        Map params = param.getParams();
        Long tenantId = params.get("tenantId") != null ? Long.valueOf(String.valueOf(((Parameter)params.get("tenantId")).getValue())) : null;
        return this.reportMapper.queryBuyPriceDetailList(tenantId);
    }
}

