/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storeCheck.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storeCheck.bean.StoreCheckEntity;
import com.ejianc.business.storeCheck.bean.StoreCheckSubEntity;
import com.ejianc.business.storeCheck.service.IStoreCheckService;
import com.ejianc.business.storeCheck.vo.StoreCheckExportVO;
import com.ejianc.business.storeCheck.vo.StoreCheckSubExportVO;
import com.ejianc.business.storeCheck.vo.StoreCheckSubVO;
import com.ejianc.business.storeCheck.vo.StoreCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storeCheck/"})
public class StoreCheckController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreCheckService storeCheckService;
    private final String BILL_CODE = "STORE_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<StoreCheckVO> saveOrUpdate(@RequestBody StoreCheckVO storeCheckVO) {
        if (StringUtils.isNotBlank((CharSequence)storeCheckVO.getBillCode())) {
            StoreCheckVO voByCode = this.storeCheckService.queryByCode(storeCheckVO.getBillCode());
            if (!(null == voByCode || null != storeCheckVO.getId() && voByCode.getId().equals(storeCheckVO.getId()))) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            CommonResponse codeResp = this.billCodeApi.getCodeBatchByRuleCode("STORE_CHECK", InvocationInfoProxy.getTenantid());
            if (!codeResp.isSuccess()) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
            }
            storeCheckVO.setBillCode((String)codeResp.getData());
        }
        StoreCheckVO voByStoreId = this.storeCheckService.queryInvalidBillByStoreId(storeCheckVO.getStoreId());
        if (!(null == voByStoreId || null != storeCheckVO.getId() && voByStoreId.getId().equals(storeCheckVO.getId()))) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u4ed3\u5e93\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u76d8\u70b9\u5355\u636e\uff01");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StoreCheckVO latestStoreCheck = this.storeCheckService.getLatestStoreCheck(storeCheckVO.getStoreId());
        if (null != latestStoreCheck) {
            try {
                if (!sdf.parse(sdf.format(storeCheckVO.getCheckDate())).after(sdf.parse(sdf.format(latestStoreCheck.getCheckDate())))) {
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u4ed3\u5e93\u4e0b\u5df2\u5b58\u5728\u5df2\u751f\u6548\u7684\u4e14\u665a\u4e8e\u5f53\u524d\u76d8\u70b9\u65e5\u671f\u7684\u76d8\u70b9\u5355\u636e\uff01");
                }
            }
            catch (Exception e) {
                this.logger.error("\u6821\u9a8c\u76d8\u70b9\u5355\u636e[{}]\u76d8\u70b9\u65e5\u671f\u5f02\u5e38\uff0c", (Object)JSONObject.toJSONString((Object)storeCheckVO), (Object)e);
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6821\u9a8c\u76d8\u70b9\u5355\u636e\u76d8\u70b9\u65e5\u671f\u5931\u8d25\uff01");
            }
        }
        StoreCheckEntity saveEntity = null;
        if (CollectionUtils.isNotEmpty((Collection)storeCheckVO.getMaterialSubList())) {
            for (StoreCheckSubVO subVo : storeCheckVO.getMaterialSubList()) {
                subVo.setInventory(Double.valueOf(subVo.getCheckNum() - subVo.getAccNum()));
            }
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (null == storeCheckVO.getId()) {
            saveEntity = (StoreCheckEntity)((Object)BeanMapper.map((Object)storeCheckVO, StoreCheckEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setCreateUserName(userContext.getUserName());
        } else {
            saveEntity = (StoreCheckEntity)((Object)this.storeCheckService.getById(storeCheckVO.getId()));
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setCheckDate(storeCheckVO.getCheckDate());
            saveEntity.setMaterialSubList(BeanMapper.mapList((Iterable)storeCheckVO.getMaterialSubList(), StoreCheckSubEntity.class));
        }
        storeCheckVO = this.storeCheckService.saveCheckStore(saveEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f!", (Object)storeCheckVO);
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<StoreCheckVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("storeName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.storeCheckService.queryPage(queryParam);
        Page resp = new Page();
        resp.setSize(pageData.getSize());
        resp.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), StoreCheckVO.class));
        resp.setCurrent(pageData.getCurrent());
        resp.setTotal(pageData.getTotal());
        resp.setPages(pageData.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u76d8\u70b9\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        return c1;
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<StoreCheckVO> queryDetail(@RequestParam(value="id") Long id) {
        StoreCheckVO vo = null;
        StoreCheckEntity dbEntity = (StoreCheckEntity)((Object)this.storeCheckService.selectById(id));
        if (null != dbEntity) {
            vo = (StoreCheckVO)BeanMapper.map((Object)((Object)dbEntity), StoreCheckVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"delete"})
    public CommonResponse<String> delete(@RequestBody List<StoreCheckVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.storeCheckService.removeByIds(ids, false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        queryParam.getFuzzyFields().add("storeName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("orgName");
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        queryParam.getComplexParams().add(this.getPageQueryParam(null));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.storeCheckService.queryPage(queryParam, false);
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List data = pageData.getRecords();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            data.forEach(storeCheck -> {
                StoreCheckExportVO vo = (StoreCheckExportVO)BeanMapper.map((Object)storeCheck, StoreCheckExportVO.class);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)storeCheck.getBillState()).getDescription());
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("storeCheck-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportMaterialList"})
    public void excelExportMaterialList(@RequestBody StoreCheckVO storeCheckVO, HttpServletResponse response) {
        JSONObject resp = new JSONObject();
        StoreCheckEntity entity = (StoreCheckEntity)((Object)this.storeCheckService.selectById(storeCheckVO.getId()));
        DecimalFormat df = new DecimalFormat("#,##0.00");
        HashMap beans = new HashMap();
        ArrayList list = new ArrayList();
        List<StoreCheckSubEntity> data = entity.getMaterialSubList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.forEach(storeCheckSub -> {
                StoreCheckSubExportVO vo = (StoreCheckSubExportVO)BeanMapper.map((Object)storeCheckSub, StoreCheckSubExportVO.class);
                vo.setAccAmountStr(df.format(vo.getAccAmount()));
                list.add(vo);
            });
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("storeCheckMaterialList-export.xlsx", beans, response);
    }
}

