package com.ejianc.business.material.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class OutStoreSubService extends BaseServiceImpl<OutStoreSubMapper, OutStoreSubEntity> implements IOutStoreSubService {

	@Autowired
	private OutStoreSubMapper outStoreSubMapper;

	@Override
	public IPage<OutStoreSubVO> queryOutStoreMaterialList(int pageNumber, int pageSize, Long storeId, String outDate, String storeType, String searchText) {
		IPage<OutStoreSubVO> page = new Page<OutStoreSubVO>();
		page.setCurrent(pageNumber);
		page.setSize(pageSize);
		Long count =outStoreSubMapper.countOutStoreMaterial(storeId, outDate, storeType, searchText);
		page.setTotal(count);
		List<OutStoreSubVO> list = new ArrayList<>();
		if(count>0){
			Integer startLine = ((pageNumber>0?pageNumber:1)-1)*pageSize;
			list = outStoreSubMapper.queryOutStoreMaterialList(startLine,pageSize,storeId,outDate, storeType, searchText);
			page.setRecords(list);
		}else{
			page.setRecords(null); 
		}
		return page;
	}
}
