package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.ComparePriceEntity;
import com.ejianc.business.material.bean.ComparePriceSelectedSupplierEntity;
import com.ejianc.business.material.mapper.ComparePriceMapper;
import com.ejianc.business.material.service.IComparePriceSelectedSupplierService;
import com.ejianc.business.material.service.IComparePriceService;
import com.ejianc.business.material.vo.ComparePriceVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;
import java.util.stream.Collectors;


@Service
public class ComparePriceService extends BaseServiceImpl<ComparePriceMapper, ComparePriceEntity> implements IComparePriceService {

    @Autowired
    private IComparePriceSelectedSupplierService iComparePriceSelectedSupplierService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean insertOrUpdate(ComparePriceEntity entity) {
        Boolean success = super.saveOrUpdate(entity,false);
        if(success){
            if(!ListUtil.isEmpty(entity.getPriceSubEntities())){
                entity.getPriceSubEntities().forEach(sub->{

                    QueryParam param = new QueryParam();
                    param.getParams().put("comparePriceSubId",new Parameter(QueryParam.EQ,sub.getId()));
                    List<ComparePriceSelectedSupplierEntity> suppliers = iComparePriceSelectedSupplierService.queryList(param,false);
                    if(!ListUtil.isEmpty(suppliers)){
                        iComparePriceSelectedSupplierService.removeByIds(suppliers.stream().map(ComparePriceSelectedSupplierEntity::getId).collect(Collectors.toList()),false);
                    }
                    if(!ListUtil.isEmpty(sub.getSupplierEntities())){
                        sub.getSupplierEntities().forEach(supplier-> {
                            supplier.setComparePriceSubId(sub.getId());
                            iComparePriceSelectedSupplierService.saveOrUpdate(supplier,false);
                        });
                    }
                });
            }
        }
        return true;
    }

    @Override
    public IPage<ComparePriceVO> queryForList(QueryParam param) {
        IPage<ComparePriceVO> voPage = null ;
        IPage<ComparePriceEntity> entityPage = super.queryPage(param,false);
        if(entityPage!=null){
            voPage = new Page<>();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize(param.getPageSize());
            voPage.setRecords(BeanMapper.mapList(entityPage.getRecords(), ComparePriceVO.class));
        }
        return voPage;
    }
}
