package com.ejianc.business.plan.service.impl;

import com.ejianc.business.plan.bean.MaterialMasterPlanSubEntity;
import com.ejianc.business.plan.mapper.MaterialMasterPlanSubMapper;
import com.ejianc.business.plan.service.IMaterialMasterPlanSubService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/2 17:12
 */
@Service(value = "materialMasterPlanSubService")
public class MaterialMasterPlanSubServiceImpl extends BaseServiceImpl<MaterialMasterPlanSubMapper, MaterialMasterPlanSubEntity> implements IMaterialMasterPlanSubService {

    @Autowired
    private MaterialMasterPlanSubMapper materialMasterPlanSubMapper;

    @Override
    public void delByPlanIdAndDetailIds(List<Long> delDetailIds, Long planId) {
        if(CollectionUtils.isNotEmpty(delDetailIds)) {
            materialMasterPlanSubMapper.delByPlanIdAndDetailIds(delDetailIds, planId);
        }
    }
}
