package com.ejianc.business.material.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.material.vo.MaterialSubjectsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface StatisticsMapper {
    Long queryInStoreDetailsPageListCount(@Param("sql") String sql);
    List<JSONObject> queryInStoreDetailsPageList(@Param("sql") String sql,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize);

    Long queryOutStoreDetailsPageListCount(@Param("sql") String sql);
    List<JSONObject> queryOutStoreDetailsPageList(@Param("sql") String sql,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize);

    Long queryInOutStorePageListCount(@Param("searchText") String searchText, @Param("orgIds") String orgIds, @Param("ciDate") String ciDate, @Param("moDate") String moDate);
    List<JSONObject> queryInOutStorePageList(@Param("searchText") String searchText, @Param("orgIds") String orgIds, @Param("ciDate") String ciDate, @Param("moDate") String moDate, @Param("startLine") Integer startLine, @Param("pageSize") Integer pageSize);

    BigDecimal queryOutStoreNumByStoreIdAndMaterialId(@Param("orgIds") String orgIds, @Param("ciDate") String ciDate, @Param("moDate") String moDate, @Param("storeId") String storeId, @Param("materialId") String materialId);

    BigDecimal queryReturnStoreNumByStoreIdAndMaterialId(@Param("orgIds") String orgIds,@Param("ciDate") String ciDate,@Param("moDate") String moDate, @Param("storeId") String storeId, @Param("materialId") String materialId);

    Long queryPlanInOutStorePageListCount(@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay);
    List<JSONObject> queryPlanInOutStorePageList(@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay,@Param("startLine") Integer startLine,@Param("pageSize") Integer pageSize);

    List<JSONObject> queryPlanOutStoreListTopN(@Param("projectId") String projectId,@Param("topN") Integer topN);

    Map<String,BigDecimal> queryReturnStoreNumByProjectIdAndMaterialId(@Param("projectId") String projectId,@Param("startDay") String startDay,@Param("endDay") String endDay, @Param("materialId") String materialId);

    List<MaterialSubjectsVO> queryMaterialCost(@Param("projectId") Long projectId, @Param("tenantId") Long tenantId);
}
