package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/1  用料申请子实体
 * @Description UseApplySubEntity
 */

@TableName("ejc_material_apply_sub")
public class UseApplySubEntity  extends BaseEntity {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 主表id
     */
    @TableField(value = "pid")
    private Long pid;

    /**
     * 物资分类名称
     */
    @TableField(value = "material_type_name")
    private String materialTypeName;


    /**
     * 物资分类id
     */
    @TableField(value = "material_type_id")
    private Long materialTypeId;

    /**
     * 物资名称
     */
    @TableField(value = "material_name")
    private String materialName;

    /**
     * 物资id
     */
    @TableField(value = "material_id")
    private Long materialId;

    /**
     * 规格型号
     */
    @TableField(value = "model")
    private String model;

    /**
     * 计量单位
     */
    @TableField(value = "unit")
    private String unit;

    /**
     * 申请数量
     */
    @TableField(value = "apply_num")
    private BigDecimal applyNum;

    /**
     * 暂估单价
     */
    @TableField(value = "estimate_price")
    private BigDecimal estimatePrice;

    /**
     * 暂估金额
     */
    @TableField(value = "estimate_money")
    private BigDecimal estimateMoney;

    /**
     * 计划进场日期
     */
    @TableField(value = "sub_plan_enter_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPlanEnterDate;

    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(BigDecimal applyNum) {
        this.applyNum = applyNum;
    }

    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateMoney() {
        return estimateMoney;
    }

    public void setEstimateMoney(BigDecimal estimateMoney) {
        this.estimateMoney = estimateMoney;
    }

    public Date getSubPlanEnterDate() {
        return subPlanEnterDate;
    }

    public void setSubPlanEnterDate(Date subPlanEnterDate) {
        this.subPlanEnterDate = subPlanEnterDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
