/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.PurchaseSettlementEntity;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPurchaseSettlementService;
import com.ejianc.business.qdsz.nc.vo.ApBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.ApBillVO;
import com.ejianc.business.utils.NCUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseSettlement")
public class PurchaseSettlementBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IPurchaseSettlementService iPurchaseSettlementService;
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    IOutStoreService iOutStoreService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private NCUtil ncUtil;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u63d0\u4ea4\u524d\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u63d0\u4ea4\u5b8c\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        return CommonResponse.success();
    }

    @Transactional
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        if (ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            ArrayList outStoreIds = new ArrayList();
            ArrayList inStoreIds = new ArrayList();
            purchaseSettlementEntity.getMaterialDetails().forEach(p -> {
                if (Objects.equals("2", p.getSourceType()) && !inStoreIds.contains(p.getSourceMainId())) {
                    inStoreIds.add(p.getSourceMainId());
                }
                if (Objects.equals("4", p.getSourceType()) && !outStoreIds.contains(p.getSourceMainId())) {
                    outStoreIds.add(p.getSourceMainId());
                }
            });
            StringBuffer msg = new StringBuffer("");
            inStoreIds.forEach(s -> {
                InstoreEntity entity = (InstoreEntity)((Object)((Object)this.iInstoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    this.iInstoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg.append("1");
                }
            });
            if (msg.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u5165\u5e93\u5355\u4fe1\u606f\uff01");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = (OutStoreEntity)((Object)((Object)this.iOutStoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(1);
                    this.iOutStoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u9000\u8d27\u5355\u4fe1\u606f\uff01");
            }
        }
        if (purchaseSettlementEntity.getBillState() == BillStateEnum.COMMITED_STATE.getBillStateCode() || purchaseSettlementEntity.getBillState() == BillStateEnum.PASSED_STATE.getBillStateCode()) {
            this.iPurchaseSettlementService.processCost(purchaseSettlementEntity);
        }
        this.iPurchaseSettlementService.saveOrUpdate((Object)purchaseSettlementEntity);
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(purchaseSettlementEntity.getProjectId())).get(0);
        if (Objects.equals("1", project.getIndustryIntegrationFlag())) {
            this.pushToNC(purchaseSettlementEntity);
        }
        return CommonResponse.success();
    }

    private void pushToNC(PurchaseSettlementEntity entity) {
        ProjectRegisterVO project = this.ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        ApBillVO vo = this.transferToNCVO(entity, project);
        List<Long> orgIds = this.ncUtil.validateDaoQiaoOrg(project.getOrgId(), project.getInvoiceMainCategory());
        String sourceIds = "";
        for (Long orgId : orgIds) {
            OrgVO orgVO = this.ncUtil.queryOrgById(orgId);
            vo.setPk_org(orgVO.getCode());
            String sourceId = this.ncUtil.postByJson(JSONObject.toJSON((Object)vo).toString());
            sourceIds = sourceIds + sourceId + ",";
        }
        sourceIds = sourceIds.substring(0, sourceIds.length() - 1);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(PurchaseSettlementEntity::getSourceId, (Object)sourceIds);
        wrapper.eq(BaseEntity::getId, (Object)entity.getId());
        this.iPurchaseSettlementService.update((Wrapper)wrapper);
    }

    private ApBillVO transferToNCVO(PurchaseSettlementEntity entity, ProjectRegisterVO project) {
        this.logger.info("----\u5e94\u4ed8\u5355\u4f20\u51ed\u8bc1\u5f00\u59cb:");
        OrgVO orgVO = this.ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierVO = this.ncUtil.querySupplierById(entity.getSupplierId());
        ApBillVO vo = new ApBillVO();
        vo.setBusitype("apbill");
        vo.setTradetype("F1-Cxx-001");
        vo.setPk_project(String.valueOf(entity.getProjectId()));
        vo.setDef12(String.valueOf(entity.getId()));
        vo.setDef19(entity.getBillCode());
        vo.setPk_org(orgVO.getCode());
        vo.setDef1(Boolean.valueOf(false));
        vo.setDef2(this.ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));
        vo.setDef3(this.ncUtil.getTaxWayDefCode(project.getTaxWay()));
        if (StringUtils.isEmpty((CharSequence)project.getAreaCode())) {
            throw new BusinessException("\u9879\u76ee-\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        vo.setDef5(project.getAreaCode());
        vo.setPk_supplier(String.valueOf(entity.getSupplierId()));
        vo.setDef6(Boolean.valueOf(supplierVO.getInsideOrgId() != null));
        vo.setPk_dept(String.valueOf(entity.getDeptId()));
        vo.setDef16(entity.getSettlementStatus());
        vo.setDef7(this.ncUtil.getTaxRateDefCode(entity.getTaxRate()));
        vo.setDef13(project.getExcuteConstructState());
        ArrayList<ApBillDetailVO> detailVOS = new ArrayList<ApBillDetailVO>();
        ApBillDetailVO detailVO = new ApBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setNotaxmny(entity.getCurrentSettlementAmount());
        detailVO.setLocal_mny(entity.getCurrentSettlementAmountTax());
        detailVO.setTaxmny(entity.getTax());
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)purchaseSettlementEntity.getContractId()));
        param.getParams().put("orgId", new Parameter("eq", (Object)purchaseSettlementEntity.getOrgId()));
        param.getParams().put("createTime", new Parameter("gt", (Object)purchaseSettlementEntity.getCreateTime()));
        List entities = this.iPurchaseSettlementService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)entities)) {
            return CommonResponse.error((String)("\u8be5\u7ed3\u7b97\u5355\u7ed3\u7b97\u4e4b\u540e\u5b58\u5728\u5355\u636e\u7f16\u53f7\u4e3a\u3010" + ((PurchaseSettlementEntity)((Object)entities.get(0))).getBillCode() + "\u3011\u7684\u76f8\u540c\u5408\u540c\u548c\u7ec4\u7ec7\u7684\u7ed3\u7b97\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\uff01"));
        }
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            this.logger.info("\u7269\u8d44\u5408\u540c\u7ed3\u7b97\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ed3\u7b97 \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03 billId=" + billId + " state=" + state + " billTypeCode=" + billTypeCode);
        PurchaseSettlementEntity purchaseSettlementEntity = (PurchaseSettlementEntity)((Object)this.iPurchaseSettlementService.selectById(billId));
        if (purchaseSettlementEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u7ed3\u7b97\u5355\uff01");
        }
        if (ListUtil.isNotEmpty(purchaseSettlementEntity.getMaterialDetails())) {
            ArrayList inStoreIds = new ArrayList();
            ArrayList outStoreIds = new ArrayList();
            purchaseSettlementEntity.getMaterialDetails().forEach(p -> {
                if (Objects.equals("2", p.getSourceType()) && !inStoreIds.contains(p.getSourceMainId())) {
                    inStoreIds.add(p.getSourceMainId());
                }
                if (Objects.equals("4", p.getSourceType()) && !outStoreIds.contains(p.getSourceMainId())) {
                    outStoreIds.add(p.getSourceMainId());
                }
            });
            String[] msg = new StringBuffer("");
            inStoreIds.forEach(arg_0 -> this.lambda$afterAbstainingProcessor$4((StringBuffer)msg, arg_0));
            if (msg.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u5165\u5e93\u5355\u4fe1\u606f\uff01");
            }
            StringBuffer msg1 = new StringBuffer("");
            outStoreIds.forEach(s -> {
                OutStoreEntity entity = (OutStoreEntity)((Object)((Object)this.iOutStoreService.selectById(Long.valueOf(Long.parseLong(s)))));
                if (entity != null) {
                    entity.setSettlementFlag(0);
                    this.iOutStoreService.saveOrUpdate((Object)entity, false);
                } else {
                    msg1.append("1");
                }
            });
            if (msg1.length() > 0) {
                return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u7ed3\u7b97\u5355\u4e2d\u9000\u8d27\u5355\u4fe1\u606f\uff01");
            }
        }
        this.iCostDetailApi.deleteSubject(purchaseSettlementEntity.getId());
        purchaseSettlementEntity.setRelationFlag("0");
        this.iPurchaseSettlementService.saveOrUpdate((Object)purchaseSettlementEntity);
        if (StringUtils.isNotEmpty((CharSequence)purchaseSettlementEntity.getSourceId())) {
            String[] split;
            String sourceId = purchaseSettlementEntity.getSourceId();
            for (String s2 : split = sourceId.split(",")) {
                JSONObject json = new JSONObject();
                json.put("busitype", (Object)"deleteapbill");
                json.put("pk_bill", (Object)s2);
                this.ncUtil.postByJson(json.toJSONString());
            }
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(PurchaseSettlementEntity::getSourceId, null);
            wrapper.eq(BaseEntity::getId, (Object)billId);
            this.iPurchaseSettlementService.update((Wrapper)wrapper);
        }
        return CommonResponse.success();
    }

    private /* synthetic */ void lambda$afterAbstainingProcessor$4(StringBuffer msg, String s) {
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(Long.valueOf(Long.parseLong(s))));
        if (entity != null) {
            entity.setSettlementFlag(0);
            this.iInstoreService.saveOrUpdate((Object)entity, false);
        } else {
            msg.append("1");
        }
    }
}

