package com.ejianc.business.material.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

public interface IOutStoreService extends IBaseService<OutStoreEntity> {
    IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs);

    void processCost(OutStoreEntity entity);

    /**
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return java.util.List<com.alibaba.fastjson.JSONObject>
     */
    CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type);
}
