package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.ComparePriceEntity;
import com.ejianc.business.material.service.IComparePriceService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service("comparePrice")
public class ComparePriceBpmService implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IComparePriceService iComparePriceService;

    @Autowired
    private IBillTypeApi billTypeApi;

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ComparePriceEntity entity = iComparePriceService.selectById(billId);
        if(entity == null){
            return CommonResponse.error("没有找到询比价单据！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("采购询比价单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        return CommonResponse.success();
    }
}
